/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.coreutils.internal.parsing;

import androidx.annotation.Nullable;

public class ParseUtils {
    public static final int NEGATIVE_INT = -1;
    public static final int ZERO = 0;

    public static int parseInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static long parseLong(String string, long l) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    @Nullable
    public static Long parseLong(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Nullable
    public static Float parseFloat(String string) {
        try {
            return Float.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Nullable
    public static Integer parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Nullable
    public static Integer intValueOf(@Nullable String string) {
        if (string != null) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public static int parseIntOrZero(String string) {
        return ParseUtils.parseInt(string, 0);
    }

    public static int parseIntOrNegative(String string) {
        return ParseUtils.parseInt(string, -1);
    }
}

