/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.coreutils.internal.io;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.VisibleForTesting;
import io.appmetrica.analytics.coreutils.internal.AndroidUtils;
import io.appmetrica.analytics.coreutils.internal.io.AppDataDirProviderForN;
import io.appmetrica.analytics.coreutils.internal.io.AppStorageDirectoryProviderForLollipop;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0007H\u0007J\b\u0010\u0010\u001a\u00020\u000fH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007J\b\u0010\u0013\u001a\u00020\u0012H\u0007J\u0018\u0010\u0015\u001a\u00020\u000f*\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0007J\u0018\u0010\u0016\u001a\u00020\u000f*\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0007J\u0016\u0010\u0017\u001a\u00020\u000f*\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\u0018\u001a\u00020\u000f*\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004R\u0014\u0010\u0019\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lio/appmetrica/analytics/coreutils/internal/io/FileUtils;", "", "Landroid/content/Context;", "context", "Ljava/io/File;", "sdkStorage", "getAppStorageDirectory", "", "fileName", "getFileFromSdkStorage", "getFileFromAppStorage", "getCrashesDirectory", "getNativeCrashDirectory", "filePath", "getFileFromPath", "", "needToUseNoBackup", "getAppDataDir", "", "resetSdkStorage", "to", "move", "copyToNullable", "moveByCopy", "moveByRename", "SDK_STORAGE_RELATIVE_PATH", "Ljava/lang/String;", "SDK_FILES_PREFIX", "core-utils_release"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    @NotNull
    public static final String SDK_STORAGE_RELATIVE_PATH = "/appmetrica/analytics";
    @NotNull
    public static final String SDK_FILES_PREFIX = "appmetrica_analytics";
    private static volatile File a;

    private FileUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final File sdkStorage(@NotNull Context object) {
        if (a != null) return a;
        Object object2 = object;
        object = INSTANCE;
        synchronized (object) {
            File file = FileUtils.getAppStorageDirectory((Context)object2);
            object.getClass();
            if (file == null) {
                file = null;
            } else {
                File file2;
                block10: {
                    File file3;
                    file2 = file3;
                    if (new File(file, SDK_STORAGE_RELATIVE_PATH).exists()) break block10;
                    file2.mkdirs();
                }
                file = file2;
            }
            Object object3 = object;
            a = file;
            return a;
        }
    }

    @JvmStatic
    @Nullable
    public static final File getAppStorageDirectory(@NotNull Context context) {
        return FileUtils.needToUseNoBackup() ? AppStorageDirectoryProviderForLollipop.INSTANCE.getAppStorageDirectory(context) : context.getFilesDir();
    }

    @JvmStatic
    @Nullable
    public static final File getFileFromSdkStorage(@NotNull Context object, @NotNull String string) {
        File file;
        if ((object = FileUtils.sdkStorage(object)) != null) {
            File file2;
            file = file2;
            file2 = new File((File)object, string);
        } else {
            file = null;
        }
        return file;
    }

    @JvmStatic
    @Nullable
    public static final File getFileFromAppStorage(@NotNull Context object, @NotNull String string) {
        File file;
        if ((object = FileUtils.getAppStorageDirectory(object)) != null) {
            File file2;
            file = file2;
            file2 = new File((File)object, string);
        } else {
            file = null;
        }
        return file;
    }

    @JvmStatic
    @Nullable
    public static final File getCrashesDirectory(@NotNull Context context) {
        return FileUtils.getFileFromSdkStorage(context, "crashes");
    }

    @JvmStatic
    @Nullable
    public static final File getNativeCrashDirectory(@NotNull Context context) {
        return FileUtils.getFileFromSdkStorage(context, "native_crashes");
    }

    @JvmStatic
    @NotNull
    public static final File getFileFromPath(@NotNull String string) {
        return new File(string);
    }

    @JvmStatic
    public static final boolean needToUseNoBackup() {
        return AndroidUtils.isApiAchieved(21);
    }

    @JvmStatic
    @SuppressLint(value={"NewApi"})
    @Nullable
    public static final File getAppDataDir(@NotNull Context object) {
        return AndroidUtils.isApiAchieved(24) ? AppDataDirProviderForN.INSTANCE.dataDir((Context)object) : ((object = object.getFilesDir()) != null ? ((File)object).getParentFile() : null);
    }

    @JvmStatic
    @VisibleForTesting
    public static final void resetSdkStorage() {
        FileUtils fileUtils = INSTANCE;
        synchronized (fileUtils) {
            a = null;
            return;
        }
    }

    @JvmStatic
    public static final boolean move(@Nullable File file, @Nullable File file2) {
        FileUtils fileUtils = INSTANCE;
        return fileUtils.moveByRename(file, file2) || fileUtils.moveByCopy(file, file2);
    }

    @JvmStatic
    public static final boolean copyToNullable(@Nullable File file, @Nullable File file2) {
        if (file != null && file2 != null) {
            if (file.exists()) {
                try {
                    FilesKt.copyTo$default((File)file, (File)file2, (boolean)false, (int)0, (int)6, null);
                }
                catch (Throwable throwable) {}
                return true;
            }
            return false;
        }
        return false;
    }

    public final boolean moveByCopy(@Nullable File file, @Nullable File file2) {
        if (file != null && file2 != null) {
            if (file.exists()) {
                File file3;
                try {
                    File file4 = file;
                    file3 = file4;
                    FilesKt.copyTo$default((File)file4, (File)file2, (boolean)false, (int)0, (int)6, null);
                }
                catch (Throwable throwable) {}
                file3.delete();
                return true;
            }
            return false;
        }
        return false;
    }

    public final boolean moveByRename(@Nullable File file, @Nullable File file2) {
        return file2 != null && (this = file != null ? Boolean.valueOf(file.renameTo(file2)) : null) != null ? (Boolean)this : false;
    }
}

