/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.coreutils.internal;

import android.content.ContentValues;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.List;
import java.util.Locale;

public final class StringUtils {
    public static final String EMPTY = "";
    public static final String COMMA = ",";
    public static final String PROCESS_POSTFIX_DELIMITER = ":";

    public static boolean equalsNullSafety(@Nullable String string, @Nullable String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string != null && string2 != null) {
            return string.equals(string2);
        }
        return false;
    }

    public static String ifIsNullToDef(String string, String string2) {
        if (string == null) {
            string = string2;
        }
        return string;
    }

    public static String ifIsEmptyToDef(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = string2;
        }
        return string;
    }

    public static String emptyIfNull(String string) {
        return StringUtils.ifIsNullToDef(string, EMPTY);
    }

    public static String capitalize(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return EMPTY;
        }
        char c2 = string.charAt(0);
        if (Character.isUpperCase(c2)) {
            return string;
        }
        return Character.toUpperCase(c2) + string.substring(1);
    }

    public static byte[] getUTF8Bytes(@Nullable String string) {
        if (string != null) {
            try {
                return string.getBytes("UTF-8");
            }
            catch (Throwable throwable) {}
        }
        return new byte[0];
    }

    public static int getUtf8BytesLength(@Nullable String string) {
        return StringUtils.getUTF8Bytes(string).length;
    }

    public static byte[][] getUTF8Bytes(@Nullable List<String> list) {
        byte[][] byArrayArray = new byte[][]{};
        if (list != null) {
            byArrayArray = new byte[list.size()][];
            for (int k = 0; k < list.size(); ++k) {
                byArrayArray[k] = StringUtils.getUTF8Bytes(list.get(k));
            }
        }
        return byArrayArray;
    }

    public static final String wrapFeatures(String ... stringArray) {
        return TextUtils.join((CharSequence)COMMA, (Object[])stringArray);
    }

    @NonNull
    public static byte[] stringToBytesForProtobuf(@Nullable String string) {
        return string == null ? new byte[]{} : string.getBytes();
    }

    public static String toHexString(@NonNull byte[] byArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder2.append("0123456789abcdef".charAt((by & 0xF0) >> 4));
            stringBuilder2.append("0123456789abcdef".charAt(by & 0xF));
        }
        return stringBuilder2.toString();
    }

    public static String formatSha1(@NonNull byte[] byArray) {
        return StringUtils.toHexString(byArray).toUpperCase(Locale.US).replaceAll("(.{2})(?=.+)", "$1:");
    }

    public static byte[] hexToBytes(@NonNull String string) {
        if (string.length() % 2 == 0) {
            int n = string.length();
            byte[] byArray = new byte[n / 2];
            for (int k = 0; k < n; k += 2) {
                int n2 = k;
                int n3 = n2 / 2;
                int n4 = Character.digit(string.charAt(n2), 16) << 4;
                byArray[n3] = (byte)(Character.digit(string.charAt(k + 1), 16) + n4);
            }
            return byArray;
        }
        throw new IllegalArgumentException("Input string must contain an even number of characters");
    }

    public static int compare(@Nullable String string, @Nullable String string2) {
        if (string == null) {
            return string2 == null ? 0 : -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    @NonNull
    public static String contentValuesToString(@Nullable ContentValues contentValues) {
        return contentValues == null ? "null" : contentValues.toString();
    }
}

