/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface WithTimeout {
    public long time();

    @Deprecated
    public TimeUnit unit() default TimeUnit.NANOSECONDS;

    public ChronoUnit chronoUnit() default ChronoUnit.FOREVER;

    public static class DurationBuilder {
        static Duration build(WithTimeout withTimeout) {
            if (!ChronoUnit.FOREVER.equals(withTimeout.chronoUnit())) {
                return Duration.of(withTimeout.time(), withTimeout.chronoUnit());
            }
            return Duration.of(TimeUnit.MILLISECONDS.convert(withTimeout.time(), withTimeout.unit()), ChronoUnit.MILLIS);
        }
    }
}

