/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.appium.java_client.AppiumCommandInfo;
import io.appium.java_client.remote.AppiumProtocolHandShake;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.internal.ApacheHttpClient;
import org.openqa.selenium.remote.service.DriverService;

public class AppiumCommandExecutor
implements CommandExecutor {
    private final URL remoteServer;
    private final HttpClient client;
    private final Map<String, AppiumCommandInfo> additionalCommands;
    private CommandCodec<HttpRequest> commandCodec;
    private ResponseCodec<HttpResponse> responseCodec;
    private DriverService service;

    public AppiumCommandExecutor(Map<String, AppiumCommandInfo> additionalCommands, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        Preconditions.checkNotNull((Object)addressOfRemoteServer);
        this.remoteServer = addressOfRemoteServer;
        this.additionalCommands = additionalCommands;
        this.client = httpClientFactory.createClient(this.remoteServer);
    }

    public AppiumCommandExecutor(Map<String, AppiumCommandInfo> additionalCommands, DriverService service, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, service.getUrl(), httpClientFactory);
        this.service = service;
    }

    public AppiumCommandExecutor(Map<String, AppiumCommandInfo> additionalCommands, URL addressOfRemoteServer) {
        this(additionalCommands, addressOfRemoteServer, (HttpClient.Factory)new ApacheHttpClient.Factory());
    }

    public AppiumCommandExecutor(Map<String, AppiumCommandInfo> additionalCommands, DriverService service) {
        this(additionalCommands, service, (HttpClient.Factory)new ApacheHttpClient.Factory());
    }

    public URL getAddressOfRemoteServer() {
        return this.remoteServer;
    }

    private Response doExecute(Command command) throws IOException, WebDriverException {
        if (command.getSessionId() == null) {
            if ("quit".equals(command.getName())) {
                return new Response();
            }
            if (!"getAllSessions".equals(command.getName()) && !"newSession".equals(command.getName())) {
                throw new NoSuchSessionException("Session ID is null. Using WebDriver after calling quit()?");
            }
        }
        if ("newSession".equals(command.getName())) {
            if (this.commandCodec != null) {
                throw new SessionNotCreatedException("Session already exists");
            }
            AppiumProtocolHandShake handshake = new AppiumProtocolHandShake();
            AppiumProtocolHandShake.Result result = handshake.createSession(this.client, command);
            Dialect dialect = result.getDialect();
            this.commandCodec = dialect.getCommandCodec();
            this.additionalCommands.forEach((key, value) -> {
                Preconditions.checkNotNull((Object)key);
                Preconditions.checkNotNull((Object)value);
                this.commandCodec.defineCommand(key, value.getMethod(), value.getUrl());
            });
            this.responseCodec = dialect.getResponseCodec();
            return result.createResponse();
        }
        if (this.commandCodec == null || this.responseCodec == null) {
            throw new WebDriverException("No command or response codec has been defined. Unable to proceed");
        }
        HttpRequest httpRequest = (HttpRequest)this.commandCodec.encode(command);
        try {
            HttpResponse httpResponse = this.client.execute(httpRequest, true);
            Response response = this.responseCodec.decode((Object)httpResponse);
            if (response.getSessionId() == null) {
                if (httpResponse.getTargetHost() != null) {
                    response.setSessionId(HttpSessionId.getSessionId((String)httpResponse.getTargetHost()));
                } else {
                    response.setSessionId(command.getSessionId().toString());
                }
            }
            if ("quit".equals(command.getName())) {
                this.client.close();
            }
            return response;
        }
        catch (UnsupportedCommandException e) {
            if (e.getMessage() == null || "".equals(e.getMessage())) {
                throw new UnsupportedOperationException("No information from server. Command name was: " + command.getName(), e.getCause());
            }
            throw e;
        }
    }

    public Response execute(Command command) throws IOException, WebDriverException {
        if ("newSession".equals(command.getName()) && this.service != null) {
            this.service.start();
        }
        try {
            Response response = this.doExecute(command);
            return response;
        }
        catch (Throwable t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            if (rootCause instanceof ConnectException && rootCause.getMessage().contains("Connection refused") && this.service != null) {
                if (this.service.isRunning()) {
                    throw new WebDriverException("The session is closed!", t);
                }
                if (!this.service.isRunning()) {
                    throw new WebDriverException("The appium server has accidentally died!", t);
                }
            }
            Throwables.throwIfUnchecked((Throwable)t);
            throw new WebDriverException(t);
        }
        finally {
            if ("quit".equals(command.getName()) && this.service != null) {
                this.service.stop();
            }
        }
    }
}

