/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.logger;

import io.apimatic.core.logger.LoggerUtilities;
import io.apimatic.coreinterfaces.http.request.Request;
import io.apimatic.coreinterfaces.http.response.Response;
import io.apimatic.coreinterfaces.logger.ApiLogger;
import io.apimatic.coreinterfaces.logger.Logger;
import io.apimatic.coreinterfaces.logger.configuration.HttpLoggingConfiguration;
import io.apimatic.coreinterfaces.logger.configuration.LoggingConfiguration;
import io.apimatic.coreinterfaces.logger.configuration.RequestLoggingConfiguration;
import io.apimatic.coreinterfaces.logger.configuration.ResponseLoggingConfiguration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.event.Level;

public class SdkLogger
implements ApiLogger {
    private final Logger logger;
    private final LoggingConfiguration config;
    private final RequestLoggingConfiguration requestLoggingConfiguration;
    private final ResponseLoggingConfiguration responseLoggingConfiguration;

    public SdkLogger(LoggingConfiguration config) {
        this.config = config;
        this.logger = config.getLogger();
        this.requestLoggingConfiguration = config.getRequestConfig();
        this.responseLoggingConfiguration = config.getResponseConfig();
    }

    public void logRequest(Request request) {
        Level level = this.config.getLevel() != null ? this.config.getLevel() : Level.INFO;
        String contentType = request.getHeaders().value("content-type");
        String url = this.getRequestUrl(request);
        LinkedHashMap<String, Object> requestArguments = new LinkedHashMap<String, Object>();
        requestArguments.put("method", request.getHttpMethod());
        requestArguments.put("url", url);
        requestArguments.put("contentType", contentType);
        this.logger.log(level, "Request {} {} {}", requestArguments);
        if (this.requestLoggingConfiguration.shouldLogHeaders()) {
            Map<String, Object> requestHeaderArguments = this.getHeaderArguments((HttpLoggingConfiguration)this.requestLoggingConfiguration, request.getHeaders().asSimpleMap());
            this.logger.log(level, "Request Headers {}", requestHeaderArguments);
        }
        if (this.requestLoggingConfiguration.shouldLogBody()) {
            Object body = request.getBody() != null ? request.getBody() : request.getParameters();
            LinkedHashMap<String, Object> requestBodyArguments = new LinkedHashMap<String, Object>();
            requestBodyArguments.put("body", body);
            this.logger.log(level, "Request Body {}", requestBodyArguments);
        }
    }

    public void logResponse(Response response) {
        Level level = this.config.getLevel() != null ? this.config.getLevel() : Level.INFO;
        String contentLength = response.getHeaders().value("content-length");
        String contentType = response.getHeaders().value("content-type");
        LinkedHashMap<String, Object> responseArguments = new LinkedHashMap<String, Object>();
        responseArguments.put("statusCode", response.getStatusCode());
        responseArguments.put("contentType", contentType);
        responseArguments.put("contentLength", contentLength);
        this.logger.log(level, "Response {} {} {}", responseArguments);
        if (this.responseLoggingConfiguration.shouldLogHeaders()) {
            Map<String, Object> responseHeaderArguments = this.getHeaderArguments((HttpLoggingConfiguration)this.responseLoggingConfiguration, response.getHeaders().asSimpleMap());
            this.logger.log(level, "Response Headers {}", responseHeaderArguments);
        }
        if (this.responseLoggingConfiguration.shouldLogBody()) {
            LinkedHashMap<String, String> responseBodyArguments = new LinkedHashMap<String, String>();
            responseBodyArguments.put("body", response.getBody());
            this.logger.log(level, "Response Body {}", responseBodyArguments);
        }
    }

    private String getRequestUrl(Request request) {
        if (this.requestLoggingConfiguration.shouldIncludeQueryInPath()) {
            return request.getQueryUrl();
        }
        return request.getUrl();
    }

    private Map<String, Object> getHeaderArguments(HttpLoggingConfiguration loggingConfig, Map<String, String> headers) {
        return Collections.singletonMap("headers", LoggerUtilities.getHeadersToLog(loggingConfig, headers, this.config.getMaskSensitiveHeaders()));
    }
}

