/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.quickstarts.es;

import java.io.File;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

public class Bootstrapper
implements ServletContextListener {
    private static Node node = null;

    public void contextInitialized(ServletContextEvent sce) {
        System.out.println("------------------------------");
        System.out.println("Starting apiman-elasticsearch.");
        System.out.println("------------------------------");
        File esHome = new File(System.getProperty("jboss.server.data.dir"), "es");
        System.out.println("ES Home: " + esHome);
        if (!esHome.exists()) {
            esHome.mkdirs();
        }
        ImmutableSettings.Builder settings = NodeBuilder.nodeBuilder().settings();
        settings.put("path.home", esHome.getAbsolutePath());
        String clusterName = "apiman";
        node = NodeBuilder.nodeBuilder().client(false).clusterName(clusterName).data(true).local(false).settings((Settings.Builder)settings).build();
        node.start();
        System.out.println("-----------------------------");
        System.out.println("apiman-elasticsearch started!");
        System.out.println("-----------------------------");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        node.stop();
        System.out.println("-----------------------------");
        System.out.println("apiman-elasticsearch stopped!");
        System.out.println("-----------------------------");
    }
}

