/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.security.impl;

import io.apiman.manager.api.beans.idm.UserDto;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.UserRepresentation;

public class KeycloakAdminClient {
    public static final String APIMAN_CLIENT = "apiman";
    private final KeycloakDeployment keycloakDeployment;

    public KeycloakAdminClient(KeycloakDeployment keycloakDeployment) {
        this.keycloakDeployment = keycloakDeployment;
    }

    public List<UserDto> getUsersForRole(String roleName) {
        Keycloak client = this.getClient();
        Set users = client.realm(this.keycloakDeployment.getRealm()).clients().get(APIMAN_CLIENT).roles().get(roleName).getRoleUserMembers();
        return users.stream().filter(UserRepresentation::isEnabled).map(this::toUserBean).collect(Collectors.toList());
    }

    private UserDto toUserBean(UserRepresentation userRepresentation) {
        return new UserDto().setUsername(userRepresentation.getUsername()).setEmail(userRepresentation.getEmail()).setFullName(userRepresentation.getFirstName() + " " + userRepresentation.getLastName());
    }

    private Keycloak getClient() {
        String secret = (String)this.keycloakDeployment.getResourceCredentials().get("secret");
        if (secret == null) {
            throw new IllegalArgumentException("No client secret defined in Keycloak config");
        }
        return Keycloak.getInstance((String)this.keycloakDeployment.getAuthServerBaseUrl(), (String)this.keycloakDeployment.getRealm(), (String)APIMAN_CLIENT, (String)secret, (String)APIMAN_CLIENT);
    }
}

