/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.security.impl;

import io.apiman.manager.api.beans.idm.PermissionBean;
import io.apiman.manager.api.beans.idm.PermissionType;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IndexedPermissions
implements Serializable {
    private static final long serialVersionUID = -474966481686691421L;
    private Set<String> organizations = new HashSet<String>();
    private Set<String> qualifiedPermissions = new HashSet<String>();
    private Map<PermissionType, Set<String>> permissionToOrgsMap = new HashMap<PermissionType, Set<String>>();

    public IndexedPermissions(Set<PermissionBean> permissions) {
        this.index(permissions);
    }

    public boolean hasQualifiedPermission(PermissionType permissionName, String orgQualifier) {
        String key = this.createQualifiedPermissionKey(permissionName, orgQualifier);
        return this.qualifiedPermissions.contains(key);
    }

    public boolean isMemberOf(String organizationId) {
        return this.organizations.contains(organizationId);
    }

    public Set<String> getOrgQualifiers(PermissionType permissionName) {
        Set<String> orgs = this.permissionToOrgsMap.get(permissionName);
        if (orgs == null) {
            orgs = Collections.emptySet();
        }
        return Collections.unmodifiableSet(orgs);
    }

    private void index(Set<PermissionBean> permissions) {
        for (PermissionBean permissionBean : permissions) {
            PermissionType permissionName = permissionBean.getName();
            String orgQualifier = permissionBean.getOrganizationId();
            String qualifiedPermission = this.createQualifiedPermissionKey(permissionName, orgQualifier);
            this.organizations.add(orgQualifier);
            this.qualifiedPermissions.add(qualifiedPermission);
            Set orgs = this.permissionToOrgsMap.computeIfAbsent(permissionName, k -> new HashSet());
            orgs.add(orgQualifier);
        }
    }

    protected String createQualifiedPermissionKey(PermissionType permissionName, String orgQualifier) {
        return permissionName.name() + "||" + orgQualifier;
    }
}

