/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.security.impl;

import io.apiman.manager.api.beans.idm.DiscoverabilityDto;
import io.apiman.manager.api.beans.idm.DiscoverabilityEntity;
import io.apiman.manager.api.beans.idm.DiscoverabilityLevel;
import io.apiman.manager.api.beans.idm.DiscoverabilityMapper;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class IndexedDiscoverabilities {
    private final PatriciaTrie<DiscoverabilityDto> discoverabilityIndex = new PatriciaTrie();
    private final DiscoverabilityMapper mapper = DiscoverabilityMapper.INSTANCE;

    public void index(Collection<DiscoverabilityEntity> discoverabilityEntities) {
        for (DiscoverabilityDto discoverabilityDto : this.mapper.toDto(discoverabilityEntities)) {
            this.insertIntoIndex(this.createApiLookupKey(discoverabilityDto), discoverabilityDto);
            if (discoverabilityDto.getPlanId() == null || discoverabilityDto.getPlanVersion() == null) continue;
            this.insertIntoIndex(this.createPlanLookupKey(discoverabilityDto), discoverabilityDto);
        }
    }

    private void insertIntoIndex(String lookupKey, DiscoverabilityDto discoverabilityDto) {
        this.discoverabilityIndex.compute((Object)lookupKey, (k, existingVal) -> {
            if (existingVal == null) {
                return discoverabilityDto;
            }
            int compare = existingVal.getDiscoverability().compareTo((Enum)discoverabilityDto.getDiscoverability());
            if (compare > 0) {
                return discoverabilityDto;
            }
            return existingVal;
        });
    }

    @NotNull
    public SortedMap<String, DiscoverabilityDto> getAll(String orgId) {
        Validate.notBlank((CharSequence)orgId, (String)"orgId must not be blank", (Object[])new Object[0]);
        return this.discoverabilityIndex.prefixMap((Object)this.createLookupKey(orgId));
    }

    @NotNull
    public SortedMap<String, DiscoverabilityDto> getAll(ISecurityContext.EntityType entityType, String orgId) {
        Objects.requireNonNull(entityType, "entityType must not be null");
        Validate.notBlank((CharSequence)orgId, (String)"orgId must not be blank", (Object[])new Object[0]);
        return this.discoverabilityIndex.prefixMap((Object)this.createLookupKey(entityType, orgId));
    }

    @NotNull
    public SortedMap<String, DiscoverabilityDto> getAll(ISecurityContext.EntityType entityType, String orgId, String entityId) {
        Objects.requireNonNull(entityType, "entityType must not be null");
        Validate.notBlank((CharSequence)orgId, (String)"orgId must not be blank", (Object[])new Object[0]);
        return this.discoverabilityIndex.prefixMap((Object)this.createLookupKey(entityType, orgId, entityId));
    }

    @Nullable
    public DiscoverabilityDto get(ISecurityContext.EntityType entityType, String orgId, String entityId, String entityVersion) {
        Objects.requireNonNull(entityType, "entityType must not be null");
        Validate.notBlank((CharSequence)orgId, (String)"orgId must not be blank", (Object[])new Object[0]);
        return (DiscoverabilityDto)this.discoverabilityIndex.get((Object)this.createLookupKey(entityType, orgId, entityId, entityVersion));
    }

    @NotNull
    public DILookupResult isDiscoverable(ISecurityContext.EntityType entityType, String orgId, String entityId, String entityVersion, Set<DiscoverabilityLevel> discoverabilities) {
        Objects.requireNonNull(entityType, "entityType must not be null");
        Validate.notBlank((CharSequence)orgId, (String)"orgId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entityId, (String)"entityId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entityVersion, (String)"entityVersion must not be blank", (Object[])new Object[0]);
        String key = this.createLookupKey(entityType, orgId, entityId, entityVersion);
        DiscoverabilityDto result = (DiscoverabilityDto)this.discoverabilityIndex.get((Object)key);
        if (result == null) {
            return DILookupResult.NOT_IN_INDEX;
        }
        if (discoverabilities.contains(result.getDiscoverability())) {
            return DILookupResult.DISCOVERABLE;
        }
        return DILookupResult.NOT_DISCOVERABLE;
    }

    @NotNull
    public DILookupResult isAnyDiscoverable(ISecurityContext.EntityType entityType, String orgId, String entityId, Set<DiscoverabilityLevel> discoverabilities) {
        Objects.requireNonNull(entityType, "entityType must not be null");
        Validate.notBlank((CharSequence)orgId, (String)"orgId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entityId, (String)"entityId must not be blank", (Object[])new Object[0]);
        String key = this.createLookupKey(entityType, orgId, entityId);
        List prefixDiscoverabilities = this.discoverabilityIndex.prefixMap((Object)key).values().stream().map(DiscoverabilityDto::getDiscoverability).collect(Collectors.toList());
        if (prefixDiscoverabilities.isEmpty()) {
            return DILookupResult.NOT_IN_INDEX;
        }
        if (Collections.disjoint(prefixDiscoverabilities, discoverabilities)) {
            return DILookupResult.NOT_DISCOVERABLE;
        }
        return DILookupResult.DISCOVERABLE;
    }

    private String createLookupKey(String orgId) {
        return String.join((CharSequence)".", orgId);
    }

    private String createLookupKey(ISecurityContext.EntityType entityType, String orgId) {
        return String.join((CharSequence)".", orgId, entityType.name());
    }

    private String createLookupKey(ISecurityContext.EntityType entityType, String orgId, String entityId) {
        return String.join((CharSequence)".", orgId, entityType.name(), entityId);
    }

    private String createLookupKey(ISecurityContext.EntityType entityType, String orgId, String entityId, String entityVersion) {
        return String.join((CharSequence)".", orgId, entityType.name(), entityId, "VERSION", entityVersion);
    }

    private String createApiLookupKey(DiscoverabilityDto DiscoverabilityDto2) {
        return String.join((CharSequence)".", DiscoverabilityDto2.getOrgId(), ISecurityContext.EntityType.API.name(), DiscoverabilityDto2.getApiId(), "VERSION", DiscoverabilityDto2.getApiVersion());
    }

    private String createPlanLookupKey(DiscoverabilityDto DiscoverabilityDto2) {
        return String.join((CharSequence)".", DiscoverabilityDto2.getOrgId(), ISecurityContext.EntityType.PLAN.name(), DiscoverabilityDto2.getPlanId(), "VERSION", DiscoverabilityDto2.getPlanVersion());
    }

    public static enum DILookupResult {
        DISCOVERABLE,
        NOT_DISCOVERABLE,
        NOT_IN_INDEX;

    }
}

