/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.service;

import io.apiman.manager.api.beans.idm.PermissionBean;
import io.apiman.manager.api.beans.idm.RoleMembershipBean;
import io.apiman.manager.api.beans.idm.UpdateUserBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.rest.exceptions.UserNotFoundException;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.util.DataAccessUtilMixin;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;

@ApplicationScoped
@Transactional
public class UserService
implements DataAccessUtilMixin {
    private IStorage storage;
    private IStorageQuery query;

    @Inject
    public UserService(IStorage storage, IStorageQuery query) {
        this.storage = storage;
        this.query = query;
    }

    public UserService() {
    }

    public UserBean getUserById(String userId) {
        return this.tryAction(() -> this.storage.getUser(userId));
    }

    public void update(String userId, UpdateUserBean user) throws UserNotFoundException {
        UserBean updatedUser = this.tryAction(() -> this.storage.getUser(userId));
        if (updatedUser == null) {
            throw ExceptionFactory.userNotFoundException((String)userId);
        }
        if (user.getEmail() != null) {
            updatedUser.setEmail(user.getEmail());
        }
        if (user.getFullName() != null) {
            updatedUser.setFullName(user.getFullName());
        }
        if (user.getLocale() != null) {
            updatedUser.setLocale(user.getLocale());
        }
        this.tryAction(() -> this.storage.updateUser(updatedUser));
    }

    public List<OrganizationSummaryBean> getPermittedOrgs(String userId) {
        if (userId == null || userId.isBlank()) {
            return Collections.emptyList();
        }
        return this.tryAction(() -> {
            Set permittedOrganizations = this.query.getUserMemberships(userId).stream().map(RoleMembershipBean::getOrganizationId).collect(Collectors.toSet());
            return this.query.getOrgs(permittedOrganizations);
        });
    }

    public Set<PermissionBean> getPermissions(String userId) {
        if (userId == null || userId.isBlank()) {
            return Collections.emptySet();
        }
        return this.tryAction(() -> this.query.getPermissions(userId));
    }
}

