/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.service;

import io.apiman.manager.api.beans.idm.PermissionConstraint;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterOperator;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.ClientSummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.rest.impl.util.DataAccessUtilMixin;
import io.apiman.manager.api.rest.impl.util.SearchCriteriaUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;

@ApplicationScoped
@Transactional
@ParametersAreNonnullByDefault
public class SearchService
implements DataAccessUtilMixin {
    private IStorageQuery query;

    @Inject
    public SearchService(IStorageQuery query) {
        this.query = query;
    }

    public SearchService() {
    }

    public SearchResultsBean<OrganizationSummaryBean> findOrganizations(SearchCriteriaBean criteria, PermissionConstraint constraints) {
        SearchCriteriaUtil.validateSearchCriteria(criteria);
        return this.tryAction(() -> this.query.findOrganizations(criteria, constraints));
    }

    public SearchResultsBean<ClientSummaryBean> findClients(SearchCriteriaBean criteria, PermissionConstraint constraints) {
        SearchCriteriaUtil.validateSearchCriteria(criteria);
        return this.tryAction(() -> this.query.findClients(criteria, constraints));
    }

    public SearchResultsBean<ApiSummaryBean> findApis(SearchCriteriaBean criteria, PermissionConstraint constraints) {
        SearchCriteriaUtil.validateSearchCriteria(criteria);
        return this.tryAction(() -> this.query.findApis(criteria, constraints, true));
    }

    public SearchResultsBean<ApiSummaryBean> findAllFeaturedApis(PermissionConstraint constraints) {
        SearchCriteriaBean criteria = new SearchCriteriaBean().addFilter("tags.key", "featured", SearchCriteriaFilterOperator.eq);
        return this.tryAction(() -> this.query.findApis(criteria, constraints, false));
    }

    public SearchResultsBean<UserBean> findUsers(SearchCriteriaBean criteria) {
        SearchCriteriaUtil.validateSearchCriteria(criteria);
        return this.tryAction(() -> this.query.findUsers(criteria));
    }

    public SearchResultsBean<RoleBean> findRoles(SearchCriteriaBean criteria) {
        SearchCriteriaUtil.validateSearchCriteria(criteria);
        return this.tryAction(() -> this.query.findRoles(criteria));
    }
}

