/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.service;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.beans.clients.ClientVersionBean;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.policies.NewPolicyBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.util.PolicyTemplateUtil;
import io.apiman.manager.api.rest.exceptions.PolicyDefinitionNotFoundException;
import io.apiman.manager.api.rest.exceptions.PolicyNotFoundException;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.audit.AuditUtils;
import io.apiman.manager.api.rest.impl.util.DataAccessUtilMixin;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;

@ApplicationScoped
@Transactional
public class PolicyService
implements DataAccessUtilMixin {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(PolicyService.class);
    private IStorage storage;
    private IStorageQuery query;
    private ISecurityContext securityContext;

    @Inject
    public PolicyService(IStorage storage, IStorageQuery query, ISecurityContext securityContext) {
        this.storage = storage;
        this.query = query;
        this.securityContext = securityContext;
    }

    public PolicyService() {
    }

    public PolicyBean createPolicy(String organizationId, String entityId, String entityVersion, NewPolicyBean bean, PolicyType type) throws PolicyDefinitionNotFoundException {
        return this.tryAction(() -> {
            if (bean.getDefinitionId() == null) {
                throw ExceptionFactory.policyDefNotFoundException((String)"null");
            }
            PolicyDefinitionBean def = this.storage.getPolicyDefinition(bean.getDefinitionId());
            if (def == null) {
                throw ExceptionFactory.policyDefNotFoundException((String)bean.getDefinitionId());
            }
            int newIdx = this.query.getMaxPolicyOrderIndex(organizationId, entityId, entityVersion, type) + 1;
            PolicyBean policy = new PolicyBean();
            policy.setId(null);
            policy.setDefinition(def);
            policy.setName(def.getName());
            policy.setConfiguration(bean.getConfiguration());
            policy.setCreatedBy(this.securityContext.getCurrentUser());
            policy.setCreatedOn(new Date());
            policy.setModifiedBy(this.securityContext.getCurrentUser());
            policy.setModifiedOn(new Date());
            policy.setOrganizationId(organizationId);
            policy.setEntityId(entityId);
            policy.setEntityVersion(entityVersion);
            policy.setType(type);
            policy.setOrderIndex(newIdx);
            if (type == PolicyType.Client) {
                ClientVersionBean cvb = this.storage.getClientVersion(organizationId, entityId, entityVersion);
                cvb.setModifiedBy(this.securityContext.getCurrentUser());
                cvb.setModifiedOn(new Date());
                this.storage.updateClientVersion(cvb);
            } else if (type == PolicyType.Api) {
                ApiVersionBean avb = this.storage.getApiVersion(organizationId, entityId, entityVersion);
                avb.setModifiedBy(this.securityContext.getCurrentUser());
                avb.setModifiedOn(new Date());
                this.storage.updateApiVersion(avb);
            } else if (type == PolicyType.Plan) {
                PlanVersionBean pvb = this.storage.getPlanVersion(organizationId, entityId, entityVersion);
                pvb.setModifiedBy(this.securityContext.getCurrentUser());
                pvb.setModifiedOn(new Date());
                this.storage.updatePlanVersion(pvb);
            }
            this.storage.createPolicy(policy);
            this.storage.createAuditEntry(AuditUtils.policyAdded(policy, type, this.securityContext));
            PolicyTemplateUtil.generatePolicyDescription((PolicyBean)policy);
            LOGGER.debug(String.format("Created client policy: %s", policy));
            return policy;
        });
    }

    public PolicyBean getPolicy(PolicyType type, String organizationId, String entityId, String entityVersion, long policyId) throws PolicyNotFoundException {
        PolicyBean policy = this.tryAction(() -> this.storage.getPolicy(type, organizationId, entityId, entityVersion, Long.valueOf(policyId)));
        if (policy == null) {
            throw ExceptionFactory.policyNotFoundException((long)policyId);
        }
        if (policy.getType() != type) {
            throw ExceptionFactory.policyNotFoundException((long)policyId);
        }
        if (!policy.getOrganizationId().equals(organizationId)) {
            throw ExceptionFactory.policyNotFoundException((long)policyId);
        }
        if (!policy.getEntityId().equals(entityId)) {
            throw ExceptionFactory.policyNotFoundException((long)policyId);
        }
        if (!policy.getEntityVersion().equals(entityVersion)) {
            throw ExceptionFactory.policyNotFoundException((long)policyId);
        }
        this.tryAction(() -> PolicyTemplateUtil.generatePolicyDescription((PolicyBean)policy));
        return policy;
    }
}

