/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.service;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.BeanUtils;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.audit.data.EntityUpdatedData;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.plans.NewPlanBean;
import io.apiman.manager.api.beans.plans.NewPlanVersionBean;
import io.apiman.manager.api.beans.plans.PlanBean;
import io.apiman.manager.api.beans.plans.PlanStatus;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.plans.UpdatePlanBean;
import io.apiman.manager.api.beans.policies.NewPolicyBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyChainBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.beans.policies.UpdatePolicyBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.PlanSummaryBean;
import io.apiman.manager.api.beans.summary.PlanVersionSummaryBean;
import io.apiman.manager.api.beans.summary.PolicySummaryBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.exceptions.ApiNotFoundException;
import io.apiman.manager.api.rest.exceptions.InvalidNameException;
import io.apiman.manager.api.rest.exceptions.InvalidPlanStatusException;
import io.apiman.manager.api.rest.exceptions.InvalidVersionException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.OrganizationNotFoundException;
import io.apiman.manager.api.rest.exceptions.PlanAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.PlanNotFoundException;
import io.apiman.manager.api.rest.exceptions.PlanVersionAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.PlanVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.PolicyNotFoundException;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.audit.AuditUtils;
import io.apiman.manager.api.rest.impl.util.DataAccessUtilMixin;
import io.apiman.manager.api.rest.impl.util.FieldValidator;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.service.OrganizationService;
import io.apiman.manager.api.service.PolicyService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;

@ApplicationScoped
@Transactional
public class PlanService
implements DataAccessUtilMixin {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(PlanService.class);
    private IStorage storage;
    private IStorageQuery query;
    private ISecurityContext securityContext;
    private OrganizationService organizationService;
    private PolicyService policyService;

    @Inject
    public PlanService(IStorage storage, IStorageQuery query, ISecurityContext securityContext, OrganizationService organizationService, PolicyService policyService) {
        this.storage = storage;
        this.query = query;
        this.securityContext = securityContext;
        this.organizationService = organizationService;
        this.policyService = policyService;
    }

    public PlanService() {
    }

    public PlanBean createPlan(String organizationId, NewPlanBean bean) throws OrganizationNotFoundException, PlanAlreadyExistsException, NotAuthorizedException, InvalidNameException {
        this.securityContext.checkPermissions(PermissionType.planEdit, organizationId);
        FieldValidator.validateName(bean.getName());
        PlanBean newPlan = new PlanBean();
        newPlan.setName(bean.getName());
        newPlan.setDescription(bean.getDescription());
        newPlan.setId(BeanUtils.idFromName((String)bean.getName()));
        newPlan.setCreatedOn(new Date());
        newPlan.setCreatedBy(this.securityContext.getCurrentUser());
        return this.tryAction(() -> {
            OrganizationBean orgBean = this.organizationService.getOrg(organizationId);
            if (this.storage.getPlan(orgBean.getId(), newPlan.getId()) != null) {
                throw ExceptionFactory.planAlreadyExistsException((String)newPlan.getName());
            }
            newPlan.setOrganization(orgBean);
            this.storage.createPlan(newPlan);
            this.storage.createAuditEntry(AuditUtils.planCreated(newPlan, this.securityContext));
            if (bean.getInitialVersion() != null) {
                NewPlanVersionBean newPlanVersion = new NewPlanVersionBean();
                newPlanVersion.setVersion(bean.getInitialVersion());
                this.createPlanVersionInternal(newPlanVersion, newPlan);
            }
            LOGGER.debug(String.format("Created plan: %s", newPlan));
            return newPlan;
        });
    }

    public PlanBean getPlan(String organizationId, String planId) throws PlanNotFoundException, NotAuthorizedException {
        return this.tryAction(() -> {
            PlanBean bean = this.storage.getPlan(organizationId, planId);
            if (bean == null) {
                throw ExceptionFactory.planNotFoundException((String)planId);
            }
            LOGGER.debug(String.format("Got plan: %s", bean));
            return bean;
        });
    }

    public SearchResultsBean<AuditEntryBean> getPlanActivity(String organizationId, String planId, int page, int pageSize) throws PlanNotFoundException, NotAuthorizedException {
        PagingBean paging = PagingBean.create((int)page, (int)pageSize);
        return this.tryAction(() -> this.query.auditEntity(organizationId, planId, null, PlanBean.class, paging));
    }

    public List<PlanSummaryBean> listPlans(String organizationId) throws OrganizationNotFoundException, NotAuthorizedException {
        this.organizationService.getOrg(organizationId);
        return this.tryAction(() -> this.query.getPlansInOrg(organizationId));
    }

    public void updatePlan(String organizationId, String planId, UpdatePlanBean bean) throws PlanNotFoundException, NotAuthorizedException {
        EntityUpdatedData auditData = new EntityUpdatedData();
        this.tryAction(() -> {
            PlanBean planForUpdate = this.storage.getPlan(organizationId, planId);
            if (planForUpdate == null) {
                throw ExceptionFactory.planNotFoundException((String)planId);
            }
            if (AuditUtils.valueChanged(planForUpdate.getDescription(), bean.getDescription())) {
                auditData.addChange("description", planForUpdate.getDescription(), bean.getDescription());
                planForUpdate.setDescription(bean.getDescription());
            }
            this.storage.updatePlan(planForUpdate);
            this.storage.createAuditEntry(AuditUtils.planUpdated(planForUpdate, auditData, this.securityContext));
            LOGGER.debug(String.format("Updated plan: %s", planForUpdate));
        });
    }

    public PlanVersionBean createPlanVersion(String organizationId, String planId, NewPlanVersionBean bean) throws PlanNotFoundException, NotAuthorizedException, InvalidVersionException, PlanVersionAlreadyExistsException {
        FieldValidator.validateVersion(bean.getVersion());
        PlanVersionBean newVersion = this.tryAction(() -> {
            PlanBean plan = this.storage.getPlan(organizationId, planId);
            if (plan == null) {
                throw ExceptionFactory.planNotFoundException((String)planId);
            }
            if (this.storage.getPlanVersion(organizationId, planId, bean.getVersion()) != null) {
                throw ExceptionFactory.planVersionAlreadyExistsException((String)planId, (String)bean.getVersion());
            }
            return this.createPlanVersionInternal(bean, plan);
        });
        if (bean.isClone() && bean.getCloneVersion() != null) {
            try {
                List<PolicySummaryBean> policies = this.listPlanPolicies(organizationId, planId, bean.getCloneVersion());
                for (PolicySummaryBean policySummary : policies) {
                    PolicyBean policy = this.getPlanPolicy(organizationId, planId, bean.getCloneVersion(), policySummary.getId());
                    NewPolicyBean npb = new NewPolicyBean();
                    npb.setDefinitionId(policy.getDefinition().getId());
                    npb.setConfiguration(policy.getConfiguration());
                    this.createPlanPolicy(organizationId, planId, newVersion.getVersion(), npb);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LOGGER.debug(String.format("Created plan %s version: %s", planId, newVersion));
        return newVersion;
    }

    private PlanVersionBean createPlanVersionInternal(NewPlanVersionBean bean, PlanBean plan) throws StorageException {
        if (!BeanUtils.isValidVersion((String)bean.getVersion())) {
            throw new StorageException("Invalid/illegal plan version: " + bean.getVersion());
        }
        PlanVersionBean newVersion = new PlanVersionBean();
        newVersion.setCreatedBy(this.securityContext.getCurrentUser());
        newVersion.setCreatedOn(new Date());
        newVersion.setModifiedBy(this.securityContext.getCurrentUser());
        newVersion.setModifiedOn(new Date());
        newVersion.setStatus(PlanStatus.Created);
        newVersion.setPlan(plan);
        newVersion.setVersion(bean.getVersion());
        this.storage.createPlanVersion(newVersion);
        this.storage.createAuditEntry(AuditUtils.planVersionCreated(newVersion, this.securityContext));
        return newVersion;
    }

    public PlanVersionBean getPlanVersion(String organizationId, String planId, String version) throws PlanVersionNotFoundException, NotAuthorizedException {
        return this.getPlanVersionInternal(organizationId, planId, version);
    }

    private PlanVersionBean getPlanVersionInternal(String organizationId, String planId, String version) throws PlanVersionNotFoundException {
        return this.tryAction(() -> {
            PlanVersionBean planVersion = this.getPlanVersionFromStorage(organizationId, planId, version);
            LOGGER.debug(String.format("Got plan %s version: %s", planId, planVersion));
            return planVersion;
        });
    }

    private PlanVersionBean getPlanVersionFromStorage(String organizationId, String planId, String version) throws PlanVersionNotFoundException, StorageException {
        PlanVersionBean planVersion = this.storage.getPlanVersion(organizationId, planId, version);
        if (planVersion == null) {
            throw ExceptionFactory.planVersionNotFoundException((String)planId, (String)version);
        }
        return planVersion;
    }

    public SearchResultsBean<AuditEntryBean> getPlanVersionActivity(String organizationId, String planId, String version, int page, int pageSize) throws PlanVersionNotFoundException, NotAuthorizedException {
        PagingBean paging = PagingBean.create((int)page, (int)pageSize);
        return this.tryAction(() -> this.query.auditEntity(organizationId, planId, version, PlanBean.class, paging));
    }

    public List<PlanVersionSummaryBean> listPlanVersions(String organizationId, String planId) throws PlanNotFoundException, NotAuthorizedException {
        this.getPlan(organizationId, planId);
        return this.tryAction(() -> this.query.getPlanVersions(organizationId, planId));
    }

    public PolicyBean createPlanPolicy(String organizationId, String planId, String version, NewPolicyBean bean) throws OrganizationNotFoundException, PlanVersionNotFoundException, NotAuthorizedException {
        PlanVersionBean pvb = this.getPlanVersionInternal(organizationId, planId, version);
        if (pvb.getStatus() == PlanStatus.Locked) {
            throw ExceptionFactory.invalidPlanStatusException();
        }
        return this.tryAction(() -> {
            pvb.setModifiedOn(new Date());
            pvb.setModifiedBy(this.securityContext.getCurrentUser());
            LOGGER.debug(String.format("Creating plan %s policy %s", planId, pvb));
            return this.policyService.createPolicy(organizationId, planId, version, bean, PolicyType.Plan);
        });
    }

    public PolicyBean getPlanPolicy(String organizationId, String planId, String version, long policyId) throws OrganizationNotFoundException, PlanVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        this.getPlanVersionInternal(organizationId, planId, version);
        PolicyBean policy = this.policyService.getPolicy(PolicyType.Plan, organizationId, planId, version, policyId);
        LOGGER.debug(String.format("Got plan policy %s", policy));
        return policy;
    }

    public void updatePlanPolicy(String organizationId, String planId, String version, long policyId, UpdatePolicyBean bean) throws OrganizationNotFoundException, PlanVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        PlanVersionBean pvb = this.getPlanVersionInternal(organizationId, planId, version);
        this.tryAction(() -> {
            PolicyBean policy = this.storage.getPolicy(PolicyType.Plan, organizationId, planId, version, Long.valueOf(policyId));
            if (policy == null) {
                throw ExceptionFactory.policyNotFoundException((long)policyId);
            }
            if (AuditUtils.valueChanged(policy.getConfiguration(), bean.getConfiguration())) {
                policy.setConfiguration(bean.getConfiguration());
            }
            policy.setModifiedOn(new Date());
            policy.setModifiedBy(this.securityContext.getCurrentUser());
            this.storage.updatePolicy(policy);
            this.storage.createAuditEntry(AuditUtils.policyUpdated(policy, PolicyType.Plan, this.securityContext));
            pvb.setModifiedBy(this.securityContext.getCurrentUser());
            pvb.setModifiedOn(new Date());
            this.storage.updatePlanVersion(pvb);
            LOGGER.debug(String.format("Updated plan policy %s", policy));
        });
    }

    public void deletePlanPolicy(String organizationId, String planId, String version, long policyId) throws OrganizationNotFoundException, PlanVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        PlanVersionBean pvb = this.getPlanVersionInternal(organizationId, planId, version);
        if (pvb.getStatus() == PlanStatus.Locked) {
            throw ExceptionFactory.invalidPlanStatusException();
        }
        this.tryAction(() -> {
            PolicyBean policy = this.storage.getPolicy(PolicyType.Plan, organizationId, planId, version, Long.valueOf(policyId));
            if (policy == null) {
                throw ExceptionFactory.policyNotFoundException((long)policyId);
            }
            this.storage.deletePolicy(policy);
            this.storage.createAuditEntry(AuditUtils.policyRemoved(policy, PolicyType.Plan, this.securityContext));
            pvb.setModifiedBy(this.securityContext.getCurrentUser());
            pvb.setModifiedOn(new Date());
            this.storage.updatePlanVersion(pvb);
            LOGGER.debug(String.format("Deleted plan policy %s", policy));
        });
    }

    public void deletePlan(String organizationId, String planId) throws ApiNotFoundException, NotAuthorizedException, InvalidPlanStatusException {
        List lockedPlans = this.listPlanVersions(organizationId, planId).stream().filter(summary -> summary.getStatus() == PlanStatus.Locked).collect(Collectors.toList());
        if (!lockedPlans.isEmpty()) {
            throw ExceptionFactory.invalidPlanStatusException(lockedPlans);
        }
        this.tryAction(() -> {
            PlanBean plan = this.storage.getPlan(organizationId, planId);
            this.storage.deletePlan(plan);
        });
    }

    public List<PolicySummaryBean> listPlanPolicies(String organizationId, String planId, String version) throws OrganizationNotFoundException, PlanVersionNotFoundException, NotAuthorizedException {
        this.getPlanVersionInternal(organizationId, planId, version);
        return this.tryAction(() -> this.query.getPolicies(organizationId, planId, version, PolicyType.Plan));
    }

    public void reorderPlanPolicies(String organizationId, String planId, String version, PolicyChainBean policyChain) throws OrganizationNotFoundException, PlanVersionNotFoundException, NotAuthorizedException {
        PlanVersionBean pvb = this.getPlanVersionInternal(organizationId, planId, version);
        this.tryAction(() -> {
            ArrayList<Long> newOrder = new ArrayList<Long>(policyChain.getPolicies().size());
            for (PolicySummaryBean psb : policyChain.getPolicies()) {
                newOrder.add(psb.getId());
            }
            this.storage.reorderPolicies(PolicyType.Plan, organizationId, planId, version, newOrder);
            this.storage.createAuditEntry(AuditUtils.policiesReordered(pvb, PolicyType.Plan, this.securityContext));
            pvb.setModifiedBy(this.securityContext.getCurrentUser());
            pvb.setModifiedOn(new Date());
            this.storage.updatePlanVersion(pvb);
        });
    }
}

