/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.service;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.gateway.engine.beans.ApiEndpoint;
import io.apiman.manager.api.beans.BeanUtils;
import io.apiman.manager.api.beans.apis.ApiStatus;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.audit.data.EntityUpdatedData;
import io.apiman.manager.api.beans.audit.data.MembershipData;
import io.apiman.manager.api.beans.clients.ClientStatus;
import io.apiman.manager.api.beans.clients.ClientVersionBean;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.idm.GrantRolesBean;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.idm.RoleMembershipBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.members.MemberBean;
import io.apiman.manager.api.beans.members.MemberRoleBean;
import io.apiman.manager.api.beans.orgs.NewOrganizationBean;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.orgs.UpdateOrganizationBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterOperator;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.ApiEntryBean;
import io.apiman.manager.api.beans.summary.ApiRegistryBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.config.ApiManagerConfig;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.gateway.GatewayAuthenticationException;
import io.apiman.manager.api.gateway.IGatewayLink;
import io.apiman.manager.api.gateway.IGatewayLinkFactory;
import io.apiman.manager.api.rest.IRoleResource;
import io.apiman.manager.api.rest.exceptions.ClientVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.EntityStillActiveException;
import io.apiman.manager.api.rest.exceptions.InvalidNameException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.OrganizationAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.OrganizationNotFoundException;
import io.apiman.manager.api.rest.exceptions.RoleNotFoundException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.exceptions.UserNotFoundException;
import io.apiman.manager.api.rest.exceptions.i18n.Messages;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.audit.AuditUtils;
import io.apiman.manager.api.rest.impl.util.DataAccessUtilMixin;
import io.apiman.manager.api.rest.impl.util.FieldValidator;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.service.ClientAppService;
import io.apiman.manager.api.service.UserService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;

@ApplicationScoped
@Transactional
public class OrganizationService
implements DataAccessUtilMixin {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(OrganizationService.class);
    private ApiManagerConfig config;
    private IStorage storage;
    private IStorageQuery query;
    private UserService userService;
    private IRoleResource roles;
    private ISecurityContext securityContext;
    private IGatewayLinkFactory gatewayLinkFactory;
    private ClientAppService clientService;

    @Inject
    public OrganizationService(ApiManagerConfig config, IStorage storage, IStorageQuery query, UserService userService, IRoleResource roles, ISecurityContext securityContext, IGatewayLinkFactory gatewayLinkFactory, ClientAppService clientService) {
        this.config = config;
        this.storage = storage;
        this.query = query;
        this.userService = userService;
        this.roles = roles;
        this.securityContext = securityContext;
        this.gatewayLinkFactory = gatewayLinkFactory;
        this.clientService = clientService;
    }

    public OrganizationService() {
    }

    public OrganizationBean createOrg(NewOrganizationBean bean) throws OrganizationAlreadyExistsException, InvalidNameException {
        List autoGrantedRoles;
        FieldValidator.validateName(bean.getName());
        SearchCriteriaBean criteria = new SearchCriteriaBean();
        criteria.setPage(1);
        criteria.setPageSize(100);
        criteria.addFilter("autoGrant", "true", SearchCriteriaFilterOperator.bool_eq);
        try {
            autoGrantedRoles = this.query.findRoles(criteria).getBeans();
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
        if ("true".equals(System.getProperty("apiman.manager.require-auto-granted-org", "true")) && autoGrantedRoles.isEmpty()) {
            throw new SystemErrorException(Messages.i18n.format("OrganizationResourceImpl.NoAutoGrantRoleAvailable", new Object[0]));
        }
        return this.tryAction(() -> {
            OrganizationBean orgBean = new OrganizationBean();
            orgBean.setName(bean.getName());
            orgBean.setDescription(bean.getDescription());
            orgBean.setId(BeanUtils.idFromName((String)bean.getName()));
            orgBean.setCreatedOn(new Date());
            orgBean.setCreatedBy(this.securityContext.getCurrentUser());
            orgBean.setModifiedOn(new Date());
            orgBean.setModifiedBy(this.securityContext.getCurrentUser());
            if (this.storage.getOrganization(orgBean.getId()) != null) {
                throw ExceptionFactory.organizationAlreadyExistsException((String)bean.getName());
            }
            this.storage.createOrganization(orgBean);
            this.storage.createAuditEntry(AuditUtils.organizationCreated(orgBean, this.securityContext));
            for (RoleBean roleBean : autoGrantedRoles) {
                String currentUser = this.securityContext.getCurrentUser();
                String orgId = orgBean.getId();
                RoleMembershipBean membership = RoleMembershipBean.create((String)currentUser, (String)roleBean.getId(), (String)orgId);
                membership.setCreatedOn(new Date());
                this.storage.createMembership(membership);
            }
            LOGGER.debug(String.format("Created organization %s: %s", orgBean.getName(), orgBean));
            return orgBean;
        });
    }

    public void deleteOrg(String organizationId) throws OrganizationNotFoundException, NotAuthorizedException, EntityStillActiveException {
        this.tryAction(() -> {
            OrganizationBean organizationBean = this.getOrganizationFromStorage(organizationId);
            Iterator clientAppsVers = this.storage.getAllClientVersions(organizationBean, ClientStatus.Registered, 5);
            if (clientAppsVers.hasNext()) {
                throw ExceptionFactory.entityStillActiveExceptionClientVersions((Iterator)clientAppsVers);
            }
            Iterator apiVers = this.storage.getAllApiVersions(organizationBean, ApiStatus.Published, 5);
            if (apiVers.hasNext()) {
                throw ExceptionFactory.entityStillActiveExceptionApiVersions((Iterator)apiVers);
            }
            Iterator contracts = this.storage.getAllContracts(organizationBean, 5);
            if (contracts.hasNext()) {
                throw ExceptionFactory.entityStillActiveExceptionContracts((Iterator)contracts);
            }
            Iterator planVers = this.storage.getAllPlanVersions(organizationBean, 5);
            if (planVers.hasNext()) {
                LOGGER.warn("There are locked plans(s): these will be deleted.");
            }
            this.storage.deleteOrganization(organizationBean);
            LOGGER.debug("Deleted Organization: " + organizationBean.getName());
        });
    }

    public OrganizationBean getOrg(String organizationId) throws OrganizationNotFoundException {
        OrganizationBean organizationBean = this.tryAction(() -> this.getOrganizationFromStorage(organizationId));
        LOGGER.debug("Got organization {0}: {1}", new Object[]{organizationBean.getName(), organizationBean});
        return organizationBean;
    }

    public void updateOrg(String organizationId, UpdateOrganizationBean bean) throws OrganizationNotFoundException, NotAuthorizedException {
        OrganizationBean orgForUpdate = this.tryAction(() -> this.getOrganizationFromStorage(organizationId));
        EntityUpdatedData auditData = new EntityUpdatedData();
        if (AuditUtils.valueChanged(orgForUpdate.getDescription(), bean.getDescription())) {
            auditData.addChange("description", orgForUpdate.getDescription(), bean.getDescription());
            orgForUpdate.setDescription(bean.getDescription());
        }
        this.tryAction(() -> {
            this.storage.updateOrganization(orgForUpdate);
            this.storage.createAuditEntry(AuditUtils.organizationUpdated(orgForUpdate, auditData, this.securityContext));
        });
        LOGGER.debug(String.format("Updated organization %s: %s", orgForUpdate.getName(), orgForUpdate));
    }

    public SearchResultsBean<AuditEntryBean> activity(String organizationId, int page, int pageSize) throws OrganizationNotFoundException, NotAuthorizedException {
        PagingBean paging = PagingBean.create((int)page, (int)pageSize);
        return this.tryAction(() -> this.query.auditEntity(organizationId, null, null, null, paging));
    }

    public ApiRegistryBean getApiRegistry(String organizationId, String clientId, String version) throws ClientVersionNotFoundException {
        ClientVersionBean clientVersion = this.clientService.getClientVersion(organizationId, clientId, version);
        HashMap<String, IGatewayLink> gatewayLinks = new HashMap<String, IGatewayLink>();
        HashMap<String, GatewayBean> gateways = new HashMap<String, GatewayBean>();
        try {
            ApiRegistryBean apiRegistry = this.query.getApiRegistry(organizationId, clientId, version);
            apiRegistry.setApiKey(clientVersion.getApikey());
            List apis = apiRegistry.getApis();
            for (ApiEntryBean api : apis) {
                IGatewayLink link;
                String gatewayId = api.getGatewayId();
                api.setGatewayId(null);
                GatewayBean gateway = (GatewayBean)gateways.get(gatewayId);
                if (gateway == null) {
                    gateway = this.storage.getGateway(gatewayId);
                    gateways.put(gatewayId, gateway);
                }
                if ((link = (IGatewayLink)gatewayLinks.get(gatewayId)) == null) {
                    link = this.gatewayLinkFactory.create(gateway);
                    gatewayLinks.put(gatewayId, link);
                }
                ApiEndpoint se = link.getApiEndpoint(api.getApiOrgId(), api.getApiId(), api.getApiVersion());
                String apiEndpoint = se.getEndpoint();
                api.setHttpEndpoint(apiEndpoint);
            }
            ApiRegistryBean apiRegistryBean = apiRegistry;
            return apiRegistryBean;
        }
        catch (StorageException | GatewayAuthenticationException e) {
            throw new SystemErrorException(e);
        }
        finally {
            for (IGatewayLink link : gatewayLinks.values()) {
                link.close();
            }
        }
    }

    public void grant(String organizationId, GrantRolesBean bean) throws OrganizationNotFoundException, RoleNotFoundException, UserNotFoundException, NotAuthorizedException {
        this.getOrg(organizationId);
        this.userService.getUserById(bean.getUserId());
        for (String roleId : bean.getRoleIds()) {
            this.roles.get(roleId);
        }
        MembershipData auditData = new MembershipData();
        auditData.setUserId(bean.getUserId());
        this.tryAction(() -> {
            for (String roleId : bean.getRoleIds()) {
                RoleMembershipBean membership = RoleMembershipBean.create((String)bean.getUserId(), (String)roleId, (String)organizationId);
                membership.setCreatedOn(new Date());
                if (this.storage.getMembership(bean.getUserId(), roleId, organizationId) == null) {
                    this.storage.createMembership(membership);
                }
                auditData.addRole(roleId);
            }
            this.storage.createAuditEntry(AuditUtils.membershipGranted(organizationId, auditData, this.securityContext));
        });
    }

    public void revoke(String organizationId, String roleId, String userId) throws OrganizationNotFoundException, RoleNotFoundException, UserNotFoundException, NotAuthorizedException {
        this.getOrg(organizationId);
        this.userService.getUserById(userId);
        this.roles.get(roleId);
        MembershipData auditData = new MembershipData();
        auditData.setUserId(userId);
        this.tryAction(() -> {
            this.storage.deleteMembership(userId, roleId, organizationId);
            auditData.addRole(roleId);
            this.storage.createAuditEntry(AuditUtils.membershipRevoked(organizationId, auditData, this.securityContext));
            LOGGER.debug(String.format("Revoked User %s Role %s Org %s", userId, roleId, organizationId));
        });
    }

    public void revokeAll(String organizationId, String userId) throws OrganizationNotFoundException, RoleNotFoundException, UserNotFoundException, NotAuthorizedException {
        this.getOrg(organizationId);
        this.userService.getUserById(userId);
        MembershipData auditData = new MembershipData();
        auditData.setUserId(userId);
        auditData.addRole("*");
        this.tryAction(() -> {
            this.storage.deleteMemberships(userId, organizationId);
            this.storage.createAuditEntry(AuditUtils.membershipRevoked(organizationId, auditData, this.securityContext));
        });
    }

    public List<MemberBean> listMembers(String organizationId) throws OrganizationNotFoundException, NotAuthorizedException {
        this.getOrg(organizationId);
        return this.tryAction(() -> {
            Set memberships = this.query.getOrgMemberships(organizationId);
            TreeMap<String, MemberBean> members = new TreeMap<String, MemberBean>();
            for (RoleMembershipBean membershipBean : memberships) {
                String userId = membershipBean.getUserId();
                String roleId = membershipBean.getRoleId();
                RoleBean role = this.storage.getRole(roleId);
                if (role == null) continue;
                MemberBean member = (MemberBean)members.get(userId);
                if (member == null) {
                    UserBean user = this.storage.getUser(userId);
                    member = new MemberBean();
                    member.setEmail(user.getEmail());
                    member.setUserId(userId);
                    member.setUserName(user.getFullName());
                    member.setRoles(new ArrayList());
                    members.put(userId, member);
                }
                MemberRoleBean mrb = new MemberRoleBean();
                mrb.setRoleId(roleId);
                mrb.setRoleName(role.getName());
                member.getRoles().add(mrb);
                if (member.getJoinedOn() != null && membershipBean.getCreatedOn().compareTo(member.getJoinedOn()) >= 0) continue;
                member.setJoinedOn(membershipBean.getCreatedOn());
            }
            return new ArrayList(members.values());
        });
    }

    private OrganizationBean getOrganizationFromStorage(String organizationId) throws OrganizationNotFoundException, StorageException {
        OrganizationBean organizationBean = this.storage.getOrganization(organizationId);
        if (organizationBean == null) {
            throw ExceptionFactory.organizationNotFoundException((String)organizationId);
        }
        return organizationBean;
    }
}

