/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.service;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.BeanUtils;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.audit.data.EntityUpdatedData;
import io.apiman.manager.api.beans.clients.ApiKeyBean;
import io.apiman.manager.api.beans.clients.ClientBean;
import io.apiman.manager.api.beans.clients.ClientStatus;
import io.apiman.manager.api.beans.clients.ClientVersionBean;
import io.apiman.manager.api.beans.clients.NewClientBean;
import io.apiman.manager.api.beans.clients.NewClientVersionBean;
import io.apiman.manager.api.beans.clients.UpdateClientBean;
import io.apiman.manager.api.beans.contracts.NewContractBean;
import io.apiman.manager.api.beans.events.ApimanEventHeaders;
import io.apiman.manager.api.beans.events.ClientVersionStatusEvent;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.policies.NewPolicyBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyChainBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.beans.policies.UpdatePolicyBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.ClientSummaryBean;
import io.apiman.manager.api.beans.summary.ClientVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.beans.summary.PolicySummaryBean;
import io.apiman.manager.api.core.IApiKeyGenerator;
import io.apiman.manager.api.core.IBlobStore;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.events.EventService;
import io.apiman.manager.api.rest.exceptions.AbstractRestException;
import io.apiman.manager.api.rest.exceptions.ClientAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.ClientNotFoundException;
import io.apiman.manager.api.rest.exceptions.ClientVersionAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.ClientVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.EntityStillActiveException;
import io.apiman.manager.api.rest.exceptions.InvalidClientStatusException;
import io.apiman.manager.api.rest.exceptions.InvalidNameException;
import io.apiman.manager.api.rest.exceptions.InvalidVersionException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.OrganizationNotFoundException;
import io.apiman.manager.api.rest.exceptions.PolicyNotFoundException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.audit.AuditUtils;
import io.apiman.manager.api.rest.impl.util.DataAccessUtilMixin;
import io.apiman.manager.api.rest.impl.util.FieldValidator;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.service.ContractService;
import io.apiman.manager.api.service.OrganizationService;
import io.apiman.manager.api.service.PolicyService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
@Transactional
public class ClientAppService
implements DataAccessUtilMixin {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(ClientAppService.class);
    private IStorage storage;
    private IStorageQuery query;
    private ISecurityContext securityContext;
    private OrganizationService organizationService;
    private ContractService contractService;
    private PolicyService policyService;
    private IApiKeyGenerator apiKeyGenerator;
    private EventService eventService;
    private IBlobStore blobstore;

    @Inject
    public ClientAppService(IStorage storage, IStorageQuery query, ISecurityContext securityContext, OrganizationService organizationService, ContractService contractService, PolicyService policyService, IApiKeyGenerator apiKeyGenerator, EventService eventService, IBlobStore blobstore) {
        this.storage = storage;
        this.query = query;
        this.securityContext = securityContext;
        this.organizationService = organizationService;
        this.contractService = contractService;
        this.policyService = policyService;
        this.apiKeyGenerator = apiKeyGenerator;
        this.eventService = eventService;
        this.blobstore = blobstore;
    }

    public ClientAppService() {
    }

    public ClientBean createClient(String organizationId, NewClientBean bean) throws OrganizationNotFoundException, ClientAlreadyExistsException, NotAuthorizedException, InvalidNameException {
        FieldValidator.validateName(bean.getName());
        ClientBean newClient = new ClientBean();
        newClient.setId(BeanUtils.idFromName((String)bean.getName()));
        newClient.setName(bean.getName());
        newClient.setDescription(bean.getDescription());
        newClient.setCreatedBy(this.securityContext.getCurrentUser());
        newClient.setCreatedOn(new Date());
        newClient.setImage(bean.getImage());
        this.blobstore.attachToBlob(bean.getImage());
        this.tryAction(() -> {
            OrganizationBean org = this.organizationService.getOrg(organizationId);
            newClient.setOrganization(org);
            if (this.storage.getClient(org.getId(), newClient.getId()) != null) {
                throw ExceptionFactory.clientAlreadyExistsException((String)bean.getName());
            }
            this.storage.createClient(newClient);
            this.storage.createAuditEntry(AuditUtils.clientCreated(newClient, this.securityContext));
            if (bean.getInitialVersion() != null) {
                NewClientVersionBean newClientVersion = new NewClientVersionBean();
                newClientVersion.setVersion(bean.getInitialVersion());
                this.createClientVersionInternal(newClientVersion, newClient);
            }
        });
        LOGGER.debug("Created client {0}: {1}", new Object[]{newClient.getName(), newClient});
        return newClient;
    }

    public ClientBean getClient(String organizationId, String clientId) throws ClientNotFoundException, NotAuthorizedException {
        ClientBean clientBean = this.tryAction(() -> this.getClientFromStorage(organizationId, clientId));
        LOGGER.debug("Got client {0}: {1}", new Object[]{clientBean.getName(), clientBean});
        return clientBean;
    }

    public void deleteClient(String organizationId, String clientId) throws OrganizationNotFoundException, NotAuthorizedException, EntityStillActiveException {
        this.tryAction(() -> {
            ClientBean client = this.getClientFromStorage(organizationId, clientId);
            Iterator clientVersions = this.storage.getAllClientVersions(organizationId, clientId);
            Iterable iterable = () -> clientVersions;
            List registeredElems = StreamSupport.stream(iterable.spliterator(), false).filter(clientVersion -> clientVersion.getStatus() == ClientStatus.Registered).limit(5L).collect(Collectors.toList());
            if (!registeredElems.isEmpty()) {
                throw ExceptionFactory.entityStillActiveExceptionClientVersions(registeredElems);
            }
            this.storage.deleteClient(client);
            if (client.getImage() != null) {
                this.blobstore.remove(client.getImage());
            }
            LOGGER.debug("Deleted ClientApp: {0}", new Object[]{client.getName()});
        });
    }

    public List<ClientSummaryBean> listClients(String organizationId) throws OrganizationNotFoundException, NotAuthorizedException {
        return this.tryAction(() -> this.query.getClientsInOrg(organizationId));
    }

    public void updateClient(String organizationId, String clientId, UpdateClientBean bean) throws ClientNotFoundException, NotAuthorizedException {
        this.tryAction(() -> {
            ClientBean clientForUpdate = this.getClientFromStorage(organizationId, clientId);
            EntityUpdatedData auditData = new EntityUpdatedData();
            if (AuditUtils.valueChanged(clientForUpdate.getDescription(), bean.getDescription())) {
                auditData.addChange("description", clientForUpdate.getDescription(), bean.getDescription());
                clientForUpdate.setDescription(bean.getDescription());
            }
            if (AuditUtils.valueChanged(clientForUpdate.getImage(), bean.getImage())) {
                auditData.addChange("image", clientForUpdate.getImage(), bean.getImage());
                if (clientForUpdate.getImage() != null) {
                    this.blobstore.remove(clientForUpdate.getImage());
                }
                clientForUpdate.setImage(bean.getImage());
                if (bean.getImage() != null) {
                    this.blobstore.attachToBlob(bean.getImage());
                }
            }
            this.storage.updateClient(clientForUpdate);
            this.storage.createAuditEntry(AuditUtils.clientUpdated(clientForUpdate, auditData, this.securityContext));
            LOGGER.debug("Updated client {0}: {1}", new Object[]{clientForUpdate.getName(), clientForUpdate});
        });
    }

    public ClientVersionBean createClientVersion(String organizationId, String clientId, NewClientVersionBean bean) throws ClientNotFoundException, NotAuthorizedException, InvalidVersionException, ClientVersionAlreadyExistsException {
        ClientVersionBean newVersion;
        FieldValidator.validateVersion(bean.getVersion());
        try {
            ClientBean client = this.getClientFromStorage(organizationId, clientId);
            if (this.storage.getClientVersion(organizationId, clientId, bean.getVersion()) != null) {
                throw ExceptionFactory.clientVersionAlreadyExistsException((String)clientId, (String)bean.getVersion());
            }
            newVersion = this.createClientVersionInternal(bean, client);
        }
        catch (AbstractRestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemErrorException((Throwable)e);
        }
        if (bean.isClone() && bean.getCloneVersion() != null) {
            try {
                List<ContractSummaryBean> contracts = this.getClientVersionContracts(organizationId, clientId, bean.getCloneVersion());
                for (ContractSummaryBean contract : contracts) {
                    NewContractBean ncb = new NewContractBean();
                    ncb.setPlanId(contract.getPlanId());
                    ncb.setApiId(contract.getApiId());
                    ncb.setApiOrgId(contract.getApiOrganizationId());
                    ncb.setApiVersion(contract.getApiVersion());
                    this.contractService.createContract(organizationId, clientId, newVersion.getVersion(), ncb);
                }
                List<PolicySummaryBean> policies = this.listClientPolicies(organizationId, clientId, bean.getCloneVersion());
                for (PolicySummaryBean policySummary : policies) {
                    PolicyBean policy = this.getClientPolicy(organizationId, clientId, bean.getCloneVersion(), policySummary.getId());
                    NewPolicyBean npb = new NewPolicyBean();
                    npb.setDefinitionId(policy.getDefinition().getId());
                    npb.setConfiguration(policy.getConfiguration());
                    this.createClientPolicy(organizationId, clientId, newVersion.getVersion(), npb);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return newVersion;
    }

    public ApiKeyBean getClientApiKey(String organizationId, String clientId, String version) throws ClientNotFoundException, NotAuthorizedException, InvalidVersionException {
        ClientVersionBean client = this.tryAction(() -> this.getClientVersionInternal(organizationId, clientId, version));
        ApiKeyBean apiKeyBean = new ApiKeyBean();
        apiKeyBean.setApiKey(client.getApikey());
        return apiKeyBean;
    }

    public ApiKeyBean updateClientApiKey(String organizationId, String clientId, String version, ApiKeyBean bean) throws ClientNotFoundException, NotAuthorizedException, InvalidVersionException, InvalidClientStatusException {
        ClientVersionBean clientVersion = this.tryAction(() -> this.getClientVersionInternal(organizationId, clientId, version));
        if (clientVersion.getStatus() == ClientStatus.Registered) {
            throw ExceptionFactory.invalidClientStatusException();
        }
        String newApiKey = bean.getApiKey();
        if (StringUtils.isEmpty((CharSequence)newApiKey)) {
            newApiKey = this.apiKeyGenerator.generate();
        }
        clientVersion.setApikey(newApiKey);
        clientVersion.setModifiedBy(this.securityContext.getCurrentUser());
        clientVersion.setModifiedOn(new Date());
        this.tryAction(() -> this.storage.updateClientVersion(clientVersion));
        LOGGER.debug("Updated an API Key for client {0} version {1}", new Object[]{clientVersion.getClient().getName(), clientVersion});
        ApiKeyBean rval = new ApiKeyBean();
        rval.setApiKey(newApiKey);
        return rval;
    }

    protected ClientVersionBean createClientVersionInternal(NewClientVersionBean bean, ClientBean client) throws StorageException {
        if (!BeanUtils.isValidVersion((String)bean.getVersion())) {
            throw new StorageException("Invalid/illegal client version: " + bean.getVersion());
        }
        ClientVersionBean newVersion = new ClientVersionBean();
        newVersion.setClient(client);
        newVersion.setCreatedBy(this.securityContext.getCurrentUser());
        newVersion.setCreatedOn(new Date());
        newVersion.setModifiedBy(this.securityContext.getCurrentUser());
        newVersion.setModifiedOn(new Date());
        newVersion.setStatus(ClientStatus.Created);
        newVersion.setVersion(bean.getVersion());
        newVersion.setApikey(bean.getApiKey());
        if (newVersion.getApikey() == null) {
            newVersion.setApikey(this.apiKeyGenerator.generate());
        }
        this.storage.createClientVersion(newVersion);
        this.storage.createAuditEntry(AuditUtils.clientVersionCreated(newVersion, this.securityContext));
        LOGGER.debug("Created new client version {0}: {1}", new Object[]{newVersion.getClient().getName(), newVersion});
        return newVersion;
    }

    public ClientVersionBean getClientVersion(String organizationId, String clientId, String version) throws ClientVersionNotFoundException, NotAuthorizedException {
        return this.getClientVersionInternal(organizationId, clientId, version);
    }

    protected ClientVersionBean getClientVersionInternal(String organizationId, String clientId, String version) throws ClientVersionNotFoundException {
        ClientVersionBean clientVersion = this.tryAction(() -> this.getClientVersionFromStorage(organizationId, clientId, version));
        LOGGER.debug("Got new client version {0}: {1}", new Object[]{clientVersion.getClient().getName(), clientVersion});
        return clientVersion;
    }

    private ClientVersionBean getClientVersionFromStorage(String organizationId, String clientId, String version) throws StorageException, ClientVersionNotFoundException {
        ClientVersionBean clientVersion = this.storage.getClientVersion(organizationId, clientId, version);
        if (clientVersion == null) {
            throw ExceptionFactory.clientVersionNotFoundException((String)clientId, (String)version);
        }
        return clientVersion;
    }

    public SearchResultsBean<AuditEntryBean> getClientVersionActivity(String organizationId, String clientId, String version, int page, int pageSize) throws ClientVersionNotFoundException, NotAuthorizedException {
        PagingBean paging = PagingBean.create((int)page, (int)pageSize);
        return this.tryAction(() -> this.query.auditEntity(organizationId, clientId, version, ClientBean.class, paging));
    }

    public SearchResultsBean<AuditEntryBean> getClientActivity(String organizationId, String clientId, int page, int pageSize) throws ClientNotFoundException, NotAuthorizedException {
        PagingBean paging = PagingBean.create((int)page, (int)pageSize);
        return this.tryAction(() -> this.query.auditEntity(organizationId, clientId, null, ClientBean.class, paging));
    }

    public List<ClientVersionSummaryBean> listClientVersions(String organizationId, String clientId) throws ClientNotFoundException, NotAuthorizedException {
        this.getClient(organizationId, clientId);
        return this.tryAction(() -> this.query.getClientVersions(organizationId, clientId));
    }

    public List<ContractSummaryBean> getClientVersionContracts(String organizationId, String clientId, String version) throws ClientNotFoundException, NotAuthorizedException {
        this.getClientVersionInternal(organizationId, clientId, version);
        return this.tryAction(() -> this.query.getClientContracts(organizationId, clientId, version));
    }

    @Transactional
    public PolicyBean createClientPolicy(String organizationId, String clientId, String version, NewPolicyBean bean) throws OrganizationNotFoundException, ClientVersionNotFoundException, NotAuthorizedException {
        return this.tryAction(() -> {
            ClientVersionBean cvb = this.getClientVersionInternal(organizationId, clientId, version);
            PolicyBean policy = this.policyService.createPolicy(organizationId, clientId, version, bean, PolicyType.Client);
            cvb.setModifiedBy(this.securityContext.getCurrentUser());
            cvb.setModifiedOn(new Date());
            return policy;
        });
    }

    public PolicyBean getClientPolicy(String organizationId, String clientId, String version, long policyId) throws OrganizationNotFoundException, ClientVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        this.getClientVersionInternal(organizationId, clientId, version);
        return this.policyService.getPolicy(PolicyType.Client, organizationId, clientId, version, policyId);
    }

    @Transactional
    public void updateClientPolicy(String organizationId, String clientId, String version, long policyId, UpdatePolicyBean bean) throws OrganizationNotFoundException, ClientVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        ClientVersionBean cvb = this.getClientVersionInternal(organizationId, clientId, version);
        this.tryAction(() -> {
            PolicyBean policy = this.storage.getPolicy(PolicyType.Client, organizationId, clientId, version, Long.valueOf(policyId));
            if (policy == null) {
                throw ExceptionFactory.policyNotFoundException((long)policyId);
            }
            if (AuditUtils.valueChanged(policy.getConfiguration(), bean.getConfiguration())) {
                policy.setConfiguration(bean.getConfiguration());
            }
            policy.setModifiedOn(new Date());
            policy.setModifiedBy(this.securityContext.getCurrentUser());
            this.storage.updatePolicy(policy);
            this.storage.createAuditEntry(AuditUtils.policyUpdated(policy, PolicyType.Client, this.securityContext));
            cvb.setModifiedOn(new Date());
            cvb.setModifiedBy(this.securityContext.getCurrentUser());
            this.storage.updateClientVersion(cvb);
        });
    }

    @Transactional
    public void deleteClientPolicy(String organizationId, String clientId, String version, long policyId) throws OrganizationNotFoundException, ClientVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        ClientVersionBean cvb = this.getClientVersionInternal(organizationId, clientId, version);
        this.tryAction(() -> {
            PolicyBean policy = this.storage.getPolicy(PolicyType.Client, organizationId, clientId, version, Long.valueOf(policyId));
            if (policy == null) {
                throw ExceptionFactory.policyNotFoundException((long)policyId);
            }
            this.storage.deletePolicy(policy);
            this.storage.createAuditEntry(AuditUtils.policyRemoved(policy, PolicyType.Client, this.securityContext));
            cvb.setModifiedBy(this.securityContext.getCurrentUser());
            cvb.setModifiedOn(new Date());
            this.storage.updateClientVersion(cvb);
        });
    }

    @Transactional
    public List<PolicySummaryBean> listClientPolicies(String organizationId, String clientId, String version) throws OrganizationNotFoundException, ClientVersionNotFoundException, NotAuthorizedException {
        this.getClientVersionInternal(organizationId, clientId, version);
        return this.tryAction(() -> this.query.getPolicies(organizationId, clientId, version, PolicyType.Client));
    }

    @Transactional
    public void reorderClientPolicies(String organizationId, String clientId, String version, PolicyChainBean policyChain) throws OrganizationNotFoundException, ClientVersionNotFoundException, NotAuthorizedException {
        ClientVersionBean cvb = this.getClientVersionInternal(organizationId, clientId, version);
        this.tryAction(() -> {
            ArrayList<Long> newOrder = new ArrayList<Long>(policyChain.getPolicies().size());
            for (PolicySummaryBean psb : policyChain.getPolicies()) {
                newOrder.add(psb.getId());
            }
            this.storage.reorderPolicies(PolicyType.Client, organizationId, clientId, version, newOrder);
            this.storage.createAuditEntry(AuditUtils.policiesReordered(cvb, PolicyType.Client, this.securityContext));
            cvb.setModifiedBy(this.securityContext.getCurrentUser());
            cvb.setModifiedOn(new Date());
            this.storage.updateClientVersion(cvb);
        });
    }

    public void changeStatus(ClientVersionBean cvb, ClientStatus newStatus) {
        ClientStatus oldStatus = cvb.getStatus();
        cvb.setStatus(newStatus);
        this.fireClientStatusChangeEvent(cvb, oldStatus);
        LOGGER.debug("Change status of client version {0} -> {1}: {2}", new Object[]{oldStatus, newStatus, cvb});
        this.tryAction(() -> this.storage.updateClientVersion(cvb));
    }

    private ClientBean getClientFromStorage(String organizationId, String clientId) throws StorageException {
        ClientBean client = this.storage.getClient(organizationId, clientId);
        if (client == null) {
            throw ExceptionFactory.clientNotFoundException((String)clientId);
        }
        return client;
    }

    public void fireClientStatusChangeEvent(ClientVersionBean cvb, ClientStatus oldStatus) {
        if (oldStatus == cvb.getStatus()) {
            LOGGER.debug("Old status and new status same {0} => {1}", new Object[]{cvb.getId(), cvb.getStatus()});
            return;
        }
        ClientBean cb = cvb.getClient();
        ApimanEventHeaders headers = ApimanEventHeaders.builder().setId(UUID.randomUUID().toString().substring(8)).setSource(URI.create("/apiman/events/clients")).setSubject("status.change").build();
        ClientVersionStatusEvent event = ClientVersionStatusEvent.builder().setHeaders(headers).setClientOrgId(cb.getOrganization().getId()).setClientId(cvb.getClient().getId()).setClientVersion(cvb.getVersion()).setPreviousStatus(oldStatus).setNewStatus(cvb.getStatus()).build();
        this.eventService.fireEvent(event);
        LOGGER.debug("Sending client status change event: {0}");
    }
}

