/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.schema.format;

import io.apiman.manager.api.beans.apis.ApiDefinitionType;
import io.apiman.manager.api.beans.apis.ApiGatewayBean;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.gateway.GatewayAuthenticationException;
import io.apiman.manager.api.gateway.IGatewayLink;
import io.apiman.manager.api.schema.format.ApiDefinitionProvider;
import io.apiman.manager.api.schema.format.ProviderContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WsdlRewriter
implements ApiDefinitionProvider {
    private static final String LOCATION = "location";
    private static final String SOAP_ADDRESS = "address";
    private static final String[] SOAP_NAMESPACES = new String[]{"http://schemas.xmlsoap.org/wsdl/soap/", "http://schemas.xmlsoap.org/wsdl/soap12/"};

    @Override
    public String rewrite(ProviderContext ctx, InputStream wsdlStream, ApiDefinitionType apiDefinitionType) throws IOException, StorageException, GatewayAuthenticationException, Exception {
        IStorage storage = ctx.getStorage();
        ApiVersionBean avb = ctx.getAvb();
        String orgId = avb.getApi().getOrganization().getId();
        String apiId = avb.getApi().getId();
        String apiVersion = avb.getVersion();
        Document document = this.readWsdlInputStream(wsdlStream);
        LinkedList<Element> allSoapAddresses = new LinkedList<Element>();
        for (String soapNamespace : SOAP_NAMESPACES) {
            NodeList soapAddresses = document.getDocumentElement().getElementsByTagNameNS(soapNamespace, SOAP_ADDRESS);
            if (soapAddresses.getLength() <= 0) continue;
            for (int j = 0; j < soapAddresses.getLength(); ++j) {
                allSoapAddresses.add((Element)soapAddresses.item(j));
            }
        }
        String firstGateway = avb.getGateways().stream().map(ApiGatewayBean::getGatewayId).findFirst().orElse("");
        GatewayBean gateway = storage.getGateway(firstGateway);
        IGatewayLink link = ctx.getGatewayLinkFactory().create(gateway);
        String endpoint = link.getApiEndpoint(orgId, apiId, apiVersion).getEndpoint();
        for (Element addressElem : allSoapAddresses) {
            String location = addressElem.getAttribute(LOCATION);
            if (location.equals(endpoint)) continue;
            addressElem.setAttribute(LOCATION, endpoint);
        }
        return this.xmlDocumentToString(document);
    }

    private Document readWsdlInputStream(InputStream wsdlStream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        return documentBuilder.parse(wsdlStream);
    }

    private String xmlDocumentToString(Document document) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.getBuffer().toString();
    }
}

