/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.schema.format;

import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apiman.manager.api.beans.apis.ApiGatewayBean;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.gateway.GatewayAuthenticationException;
import io.apiman.manager.api.gateway.IGatewayLink;
import io.apiman.manager.api.schema.format.OAIRewriter;
import io.apiman.manager.api.schema.format.ProviderContext;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class OpenApi3
implements OAIRewriter {
    @Override
    public void rewrite(ProviderContext ctx, Document schema) throws StorageException, GatewayAuthenticationException {
        ApiVersionBean avb = ctx.getAvb();
        String orgId = avb.getApi().getOrganization().getId();
        String apiId = avb.getApi().getId();
        String apiVersion = avb.getVersion();
        Set gatewayIds = avb.getGateways().stream().map(ApiGatewayBean::getGatewayId).collect(Collectors.toUnmodifiableSet());
        HashSet<ApiEndpointWithDescription> endpoints = new HashSet<ApiEndpointWithDescription>(gatewayIds.size());
        for (GatewayBean gateway : ctx.getStorage().getGateways(gatewayIds)) {
            IGatewayLink link = ctx.getGatewayLinkFactory().create(gateway);
            endpoints.add(new ApiEndpointWithDescription(link.getApiEndpoint(orgId, apiId, apiVersion).getEndpoint(), gateway.getName(), gateway.getDescription()));
        }
        Oas30Document oas3 = (Oas30Document)schema;
        if (oas3.servers != null) {
            oas3.servers.clear();
        }
        for (ApiEndpointWithDescription endpoint : endpoints) {
            Object nameAndDesc = endpoint.getName();
            if (StringUtils.isNotBlank((String)endpoint.getDescription())) {
                nameAndDesc = (String)nameAndDesc + ": " + endpoint.getDescription();
            }
            oas3.addServer(endpoint.getEndpoint(), (String)nameAndDesc);
        }
    }

    private static final class ApiEndpointWithDescription {
        private final String endpoint;
        private final String name;
        private final String description;

        public ApiEndpointWithDescription(String endpoint, String name, String description) {
            this.endpoint = endpoint;
            this.name = name;
            this.description = description;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

