/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.schema.format;

import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apiman.manager.api.beans.apis.ApiGatewayBean;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.gateway.GatewayAuthenticationException;
import io.apiman.manager.api.gateway.IGatewayLink;
import io.apiman.manager.api.schema.format.OAIRewriter;
import io.apiman.manager.api.schema.format.ProviderContext;
import java.net.URI;
import java.util.List;

public class OpenApi2
implements OAIRewriter {
    @Override
    public void rewrite(ProviderContext ctx, Document schema) throws StorageException, GatewayAuthenticationException {
        ApiVersionBean avb = ctx.getAvb();
        String orgId = avb.getApi().getOrganization().getId();
        String apiId = avb.getApi().getId();
        String apiVersion = avb.getVersion();
        String firstGateway = avb.getGateways().stream().map(ApiGatewayBean::getGatewayId).findFirst().orElse("");
        GatewayBean gateway = ctx.getStorage().getGateway(firstGateway);
        IGatewayLink link = ctx.getGatewayLinkFactory().create(gateway);
        String apiEndpoint = link.getApiEndpoint(orgId, apiId, apiVersion).getEndpoint();
        URI apiEndpointUri = URI.create(apiEndpoint);
        Oas20Document oas2 = (Oas20Document)schema;
        oas2.schemes = List.of(apiEndpointUri.getScheme());
        oas2.host = apiEndpointUri.getPort() == -1 ? apiEndpointUri.getHost() : apiEndpointUri.getHost() + ":" + apiEndpointUri.getPort();
        oas2.basePath = apiEndpointUri.getPath();
    }
}

