/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl.util;

import io.apiman.manager.api.beans.apis.dto.ApiBeanDto;
import io.apiman.manager.api.beans.apis.dto.ApiVersionBeanDto;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.PolicySummaryBean;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.ArrayList;
import java.util.List;

public final class RestHelper {
    public static RoleBean hideSensitiveDataFromRoleBean(ISecurityContext securityContext, RoleBean roleBean) {
        if (securityContext.isAdmin()) {
            return roleBean;
        }
        RoleBean role = new RoleBean();
        role.setId(roleBean.getId());
        role.setName(roleBean.getName());
        role.setPermissions(roleBean.getPermissions());
        role.setAutoGrant(roleBean.getAutoGrant());
        role.setDescription(roleBean.getDescription());
        if (securityContext.getCurrentUser().equals(roleBean.getCreatedBy())) {
            role.setCreatedBy(roleBean.getCreatedBy());
            role.setCreatedOn(roleBean.getCreatedOn());
        }
        return role;
    }

    public static List<ApiSummaryBean> hideSensitiveDataFromApiSummaryBeanList(List<ApiSummaryBean> apiSummaryBeans) {
        ArrayList<ApiSummaryBean> apis = new ArrayList<ApiSummaryBean>();
        for (ApiSummaryBean apiSummaryBean : apiSummaryBeans) {
            ApiSummaryBean apiSummary = new ApiSummaryBean();
            apiSummary.setOrganizationId(apiSummaryBean.getOrganizationId());
            apiSummary.setOrganizationName(apiSummaryBean.getOrganizationName());
            apiSummary.setId(apiSummaryBean.getId());
            apiSummary.setName(apiSummaryBean.getName());
            apiSummary.setDescription(apiSummaryBean.getDescription());
            apiSummary.setImage(apiSummaryBean.getImage());
            apiSummary.setTags(apiSummaryBean.getTags());
            apis.add(apiSummary);
        }
        return apis;
    }

    public static List<PolicySummaryBean> hideSensitiveDataFromPolicySummaryBeanList(ISecurityContext securityContext, List<PolicySummaryBean> policySummaryBeans) {
        ArrayList<PolicySummaryBean> policies = new ArrayList<PolicySummaryBean>();
        for (PolicySummaryBean policySummaryBean : policySummaryBeans) {
            PolicySummaryBean policySummary = new PolicySummaryBean();
            policySummary.setId(policySummaryBean.getId());
            policySummary.setPolicyDefinitionId(policySummaryBean.getPolicyDefinitionId());
            policySummary.setName(policySummaryBean.getName());
            policySummary.setDescription(policySummaryBean.getDescription());
            policySummary.setIcon(policySummaryBean.getIcon());
            if (securityContext.getCurrentUser().equals(policySummaryBean.getCreatedBy())) {
                policySummary.setCreatedBy(policySummaryBean.getCreatedBy());
                policySummary.setCreatedOn(policySummaryBean.getCreatedOn());
            }
            policies.add(policySummary);
        }
        return policies;
    }

    public static ApiVersionBeanDto hideSensitiveDataFromApiVersionBean(ApiVersionBeanDto apiVersionBean) {
        ApiBeanDto api = new ApiBeanDto();
        api.setId(apiVersionBean.getApi().getId());
        api.setName(apiVersionBean.getApi().getName());
        api.setDescription(apiVersionBean.getApi().getDescription());
        api.setImage(apiVersionBean.getApi().getImage());
        OrganizationBean org = new OrganizationBean();
        org.setId(apiVersionBean.getApi().getOrganization().getId());
        org.setName(apiVersionBean.getApi().getOrganization().getName());
        org.setDescription(apiVersionBean.getApi().getOrganization().getDescription());
        api.setOrganization(org);
        ApiVersionBeanDto apiVersion = new ApiVersionBeanDto();
        apiVersion.setApi(api);
        apiVersion.setStatus(apiVersionBean.getStatus());
        apiVersion.setEndpointType(apiVersionBean.getEndpointType());
        apiVersion.setEndpointContentType(apiVersionBean.getEndpointContentType());
        apiVersion.setGateways(apiVersionBean.getGateways());
        apiVersion.setPublicAPI(apiVersionBean.isPublicAPI());
        apiVersion.setPlans(apiVersionBean.getPlans());
        apiVersion.setVersion(apiVersionBean.getVersion());
        apiVersion.setDefinitionType(apiVersionBean.getDefinitionType());
        apiVersion.setPublicDiscoverability(apiVersionBean.getPublicDiscoverability());
        apiVersion.setExtendedDescription(apiVersionBean.getExtendedDescription());
        apiVersion.setCreatedOn(apiVersionBean.getCreatedOn());
        apiVersion.setModifiedOn(apiVersionBean.getModifiedOn());
        apiVersion.setPublishedOn(apiVersionBean.getPublishedOn());
        apiVersion.setRetiredOn(apiVersionBean.getRetiredOn());
        return apiVersion;
    }

    public static OrganizationBean hideSensitiveDataFromOrganizationBean(OrganizationBean organizationBean) {
        OrganizationBean org = new OrganizationBean();
        org.setId(organizationBean.getId());
        org.setName(organizationBean.getName());
        org.setDescription(organizationBean.getDescription());
        return org;
    }
}

