/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterOperator;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.search.searchResults.UserSearchResult;
import io.apiman.manager.api.beans.summary.ApiNamespaceBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.AvailableApiBean;
import io.apiman.manager.api.beans.summary.ClientSummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.core.IApiCatalog;
import io.apiman.manager.api.rest.ISearchResource;
import io.apiman.manager.api.rest.exceptions.InvalidSearchCriteriaException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.OrganizationNotFoundException;
import io.apiman.manager.api.rest.impl.util.PermissionsHelper;
import io.apiman.manager.api.rest.impl.util.RestHelper;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.service.SearchService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;

@ApplicationScoped
@Transactional
public class SearchResourceImpl
implements ISearchResource {
    private IApiCatalog apiCatalog;
    private ISecurityContext securityContext;
    private SearchService searchService;

    @Inject
    public SearchResourceImpl(IApiCatalog apiCatalog, ISecurityContext securityContext, SearchService searchService) {
        this.apiCatalog = apiCatalog;
        this.securityContext = securityContext;
        this.searchService = searchService;
    }

    public SearchResourceImpl() {
    }

    public SearchResultsBean<OrganizationSummaryBean> searchOrgs(SearchCriteriaBean criteria) throws InvalidSearchCriteriaException {
        return this.searchService.findOrganizations(criteria, PermissionsHelper.orgConstraints(this.securityContext, PermissionType.orgView));
    }

    public SearchResultsBean<ClientSummaryBean> searchClients(SearchCriteriaBean criteria) throws OrganizationNotFoundException, InvalidSearchCriteriaException, NotAuthorizedException {
        return this.searchService.findClients(criteria, PermissionsHelper.orgConstraints(this.securityContext, PermissionType.clientView));
    }

    public SearchResultsBean<ApiSummaryBean> searchApis(SearchCriteriaBean criteria) throws OrganizationNotFoundException, InvalidSearchCriteriaException {
        return this.searchService.findApis(criteria, PermissionsHelper.orgConstraints(this.securityContext, PermissionType.apiView));
    }

    public SearchResultsBean<AvailableApiBean> searchApiCatalog(SearchCriteriaBean criteria) throws InvalidSearchCriteriaException {
        int totalSize;
        int pageSize;
        int page;
        int start;
        SearchResultsBean rval = new SearchResultsBean();
        if (criteria.getFilters().isEmpty()) {
            return rval;
        }
        SearchCriteriaFilterBean bean = (SearchCriteriaFilterBean)criteria.getFilters().get(0);
        if (bean == null) {
            return rval;
        }
        if (!bean.getName().equals("name")) {
            return rval;
        }
        String keyword = bean.getValue();
        String namespace = null;
        if (criteria.getFilters().size() >= 2 && (bean = (SearchCriteriaFilterBean)criteria.getFilters().get(1)) != null && bean.getName().equals("namespace") && bean.getOperator() == SearchCriteriaFilterOperator.eq) {
            namespace = bean.getValue();
        }
        List catalogEntries = this.apiCatalog.search(keyword, namespace);
        ArrayList<AvailableApiBean> apis = new ArrayList<AvailableApiBean>();
        if (this.securityContext.getPermittedOrganizations(PermissionType.apiEdit).isEmpty() && !this.securityContext.isAdmin()) {
            for (AvailableApiBean api : catalogEntries) {
                AvailableApiBean entry = new AvailableApiBean();
                entry.setId(api.getId());
                entry.setIcon(api.getIcon());
                entry.setRouteEndpoint(api.getRouteEndpoint());
                entry.setEndpointType(api.getEndpointType());
                entry.setName(api.getName());
                entry.setDescription(api.getDescription());
                entry.setDefinitionType(api.getDefinitionType());
                entry.setNamespace(api.getNamespace());
                entry.setTags(api.getTags());
                entry.setInternal(api.isInternal());
                apis.add(entry);
            }
        } else {
            apis.addAll(catalogEntries);
        }
        PagingBean paging = criteria.getPaging();
        if (paging == null) {
            paging = new PagingBean();
            paging.setPage(1);
            paging.setPageSize(500);
        }
        if ((start = ((page = paging.getPage()) - 1) * (pageSize = paging.getPageSize())) <= (totalSize = apis.size())) {
            int end = Math.min(start + pageSize, apis.size());
            rval.getBeans().addAll(apis.subList(start, end));
        }
        rval.setTotalSize(totalSize);
        return rval;
    }

    public SearchResultsBean<UserSearchResult> searchUsers(SearchCriteriaBean criteria) throws InvalidSearchCriteriaException {
        List users = this.searchService.findUsers(criteria).getBeans().stream().map(user -> new UserSearchResult(user.getUsername(), user.getFullName())).collect(Collectors.toList());
        return new SearchResultsBean().setTotalSize(users.size()).setBeans(users);
    }

    public SearchResultsBean<RoleBean> searchRoles(SearchCriteriaBean criteria) throws InvalidSearchCriteriaException {
        List roles = this.searchService.findRoles(criteria).getBeans().stream().map(bean -> RestHelper.hideSensitiveDataFromRoleBean(this.securityContext, bean)).collect(Collectors.toList());
        return new SearchResultsBean().setBeans(roles).setTotalSize(roles.size());
    }

    public List<ApiNamespaceBean> getApiNamespaces() {
        return this.apiCatalog.getNamespaces(this.securityContext.getCurrentUser());
    }
}

