/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.manager.api.beans.BeanUtils;
import io.apiman.manager.api.beans.idm.NewRoleBean;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.idm.UpdateRoleBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.IRoleResource;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.RoleAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.RoleNotFoundException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.util.RestHelper;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;

@ApplicationScoped
@Transactional
public class RoleResourceImpl
implements IRoleResource {
    private IStorage storage;
    private IStorageQuery query;
    private ISecurityContext securityContext;

    @Inject
    public RoleResourceImpl(IStorage storage, IStorageQuery query, ISecurityContext securityContext) {
        this.storage = storage;
        this.query = query;
        this.securityContext = securityContext;
    }

    public RoleResourceImpl() {
    }

    public RoleBean create(NewRoleBean bean) throws RoleAlreadyExistsException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        RoleBean role = new RoleBean();
        role.setAutoGrant(bean.getAutoGrant());
        role.setCreatedBy(this.securityContext.getCurrentUser());
        role.setCreatedOn(new Date());
        role.setDescription(bean.getDescription());
        role.setId(BeanUtils.idFromName((String)bean.getName()));
        role.setName(bean.getName());
        role.setPermissions(bean.getPermissions());
        try {
            if (this.storage.getRole(role.getId()) != null) {
                throw ExceptionFactory.roleAlreadyExistsException((String)role.getId());
            }
            this.storage.createRole(role);
            return role;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public RoleBean get(String roleId) throws RoleNotFoundException {
        try {
            RoleBean role = this.getRoleFromStorage(roleId);
            RoleBean roleBean = RestHelper.hideSensitiveDataFromRoleBean(this.securityContext, role);
            return roleBean;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void update(String roleId, UpdateRoleBean bean) throws RoleNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        try {
            RoleBean role = this.getRoleFromStorage(roleId);
            if (bean.getDescription() != null) {
                role.setDescription(bean.getDescription());
            }
            if (bean.getAutoGrant() != null) {
                role.setAutoGrant(bean.getAutoGrant());
            }
            if (bean.getName() != null) {
                role.setName(bean.getName());
            }
            if (bean.getPermissions() != null) {
                role.getPermissions().clear();
                role.getPermissions().addAll(bean.getPermissions());
            }
            this.storage.updateRole(role);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    private RoleBean getRoleFromStorage(String roleId) throws StorageException, RoleNotFoundException {
        RoleBean role = this.storage.getRole(roleId);
        if (role == null) {
            throw ExceptionFactory.roleNotFoundException((String)roleId);
        }
        return role;
    }

    public void delete(String roleId) throws RoleNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        RoleBean bean = this.get(roleId);
        try {
            this.storage.deleteRole(bean);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<RoleBean> list() {
        try {
            SearchCriteriaBean criteria = new SearchCriteriaBean();
            criteria.setOrder("name", true);
            if (this.securityContext.isAdmin()) {
                return this.query.findRoles(criteria).getBeans();
            }
            ArrayList<RoleBean> roles = new ArrayList<RoleBean>();
            for (RoleBean role : this.query.findRoles(criteria).getBeans()) {
                roles.add(RestHelper.hideSensitiveDataFromRoleBean(this.securityContext, role));
            }
            return roles;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }
}

