/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.gateway.engine.beans.IPolicyProbeResponse;
import io.apiman.manager.api.beans.apis.ApiDefinitionType;
import io.apiman.manager.api.beans.apis.ApiVersionStatusBean;
import io.apiman.manager.api.beans.apis.NewApiBean;
import io.apiman.manager.api.beans.apis.NewApiDefinitionBean;
import io.apiman.manager.api.beans.apis.NewApiVersionBean;
import io.apiman.manager.api.beans.apis.UpdateApiBean;
import io.apiman.manager.api.beans.apis.UpdateApiVersionBean;
import io.apiman.manager.api.beans.apis.dto.ApiBeanDto;
import io.apiman.manager.api.beans.apis.dto.ApiPlanOrderDto;
import io.apiman.manager.api.beans.apis.dto.ApiVersionBeanDto;
import io.apiman.manager.api.beans.apis.dto.KeyValueTagDto;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.clients.ApiKeyBean;
import io.apiman.manager.api.beans.clients.ClientBean;
import io.apiman.manager.api.beans.clients.ClientVersionBean;
import io.apiman.manager.api.beans.clients.NewClientBean;
import io.apiman.manager.api.beans.clients.NewClientVersionBean;
import io.apiman.manager.api.beans.clients.UpdateClientBean;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.contracts.NewContractBean;
import io.apiman.manager.api.beans.download.DownloadBean;
import io.apiman.manager.api.beans.download.DownloadType;
import io.apiman.manager.api.beans.idm.GrantRolesBean;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.members.MemberBean;
import io.apiman.manager.api.beans.metrics.ClientUsagePerApiBean;
import io.apiman.manager.api.beans.metrics.HistogramIntervalType;
import io.apiman.manager.api.beans.metrics.ResponseStatsHistogramBean;
import io.apiman.manager.api.beans.metrics.ResponseStatsPerClientBean;
import io.apiman.manager.api.beans.metrics.ResponseStatsPerPlanBean;
import io.apiman.manager.api.beans.metrics.ResponseStatsSummaryBean;
import io.apiman.manager.api.beans.metrics.UsageHistogramBean;
import io.apiman.manager.api.beans.metrics.UsagePerClientBean;
import io.apiman.manager.api.beans.metrics.UsagePerPlanBean;
import io.apiman.manager.api.beans.orgs.NewOrganizationBean;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.orgs.UpdateOrganizationBean;
import io.apiman.manager.api.beans.plans.NewPlanBean;
import io.apiman.manager.api.beans.plans.NewPlanVersionBean;
import io.apiman.manager.api.beans.plans.PlanBean;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.plans.UpdatePlanBean;
import io.apiman.manager.api.beans.policies.NewPolicyBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyChainBean;
import io.apiman.manager.api.beans.policies.UpdatePolicyBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.ApiPlanSummaryBean;
import io.apiman.manager.api.beans.summary.ApiRegistryBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.ApiVersionEndpointSummaryBean;
import io.apiman.manager.api.beans.summary.ApiVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ClientSummaryBean;
import io.apiman.manager.api.beans.summary.ClientVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.beans.summary.PlanSummaryBean;
import io.apiman.manager.api.beans.summary.PlanVersionSummaryBean;
import io.apiman.manager.api.beans.summary.PolicySummaryBean;
import io.apiman.manager.api.core.IBlobStore;
import io.apiman.manager.api.core.IDownloadManager;
import io.apiman.manager.api.core.config.ApiManagerConfig;
import io.apiman.manager.api.rest.IOrganizationResource;
import io.apiman.manager.api.rest.exceptions.ApiAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.ApiNotFoundException;
import io.apiman.manager.api.rest.exceptions.ApiVersionAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.ApiVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.ClientAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.ClientNotFoundException;
import io.apiman.manager.api.rest.exceptions.ClientVersionAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.ClientVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.ContractAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.ContractNotFoundException;
import io.apiman.manager.api.rest.exceptions.EntityStillActiveException;
import io.apiman.manager.api.rest.exceptions.GatewayNotFoundException;
import io.apiman.manager.api.rest.exceptions.InvalidApiStatusException;
import io.apiman.manager.api.rest.exceptions.InvalidClientStatusException;
import io.apiman.manager.api.rest.exceptions.InvalidMetricCriteriaException;
import io.apiman.manager.api.rest.exceptions.InvalidNameException;
import io.apiman.manager.api.rest.exceptions.InvalidPlanStatusException;
import io.apiman.manager.api.rest.exceptions.InvalidVersionException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.OrganizationAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.OrganizationNotFoundException;
import io.apiman.manager.api.rest.exceptions.PlanAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.PlanNotFoundException;
import io.apiman.manager.api.rest.exceptions.PlanVersionAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.PlanVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.PolicyNotFoundException;
import io.apiman.manager.api.rest.exceptions.RoleNotFoundException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.exceptions.UserNotFoundException;
import io.apiman.manager.api.rest.exceptions.i18n.Messages;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.util.DataAccessUtilMixin;
import io.apiman.manager.api.rest.impl.util.RestHelper;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.service.ApiService;
import io.apiman.manager.api.service.ClientAppService;
import io.apiman.manager.api.service.ContractService;
import io.apiman.manager.api.service.OrganizationService;
import io.apiman.manager.api.service.PlanService;
import io.apiman.manager.api.service.StatsService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import javax.validation.Valid;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;

@RequestScoped
@Transactional
public class OrganizationResourceImpl
implements IOrganizationResource,
DataAccessUtilMixin {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(OrganizationResourceImpl.class);
    private ApiManagerConfig config;
    private OrganizationService organizationService;
    private ApiService apiService;
    private PlanService planService;
    private ClientAppService clientService;
    private ContractService contractService;
    private StatsService statsService;
    private IDownloadManager downloadManager;
    private ISecurityContext securityContext;
    private IBlobStore blobStore;
    private HttpServletRequest request;

    @Inject
    public OrganizationResourceImpl(ApiManagerConfig config, OrganizationService organizationService, ApiService apiService, PlanService planService, ClientAppService clientService, ContractService contractService, StatsService statsService, IDownloadManager downloadManager, ISecurityContext securityContext, IBlobStore blobStore, @Context HttpServletRequest request) {
        this.config = config;
        this.organizationService = organizationService;
        this.apiService = apiService;
        this.planService = planService;
        this.clientService = clientService;
        this.contractService = contractService;
        this.statsService = statsService;
        this.downloadManager = downloadManager;
        this.securityContext = securityContext;
        this.blobStore = blobStore;
        this.request = request;
    }

    public OrganizationResourceImpl() {
    }

    public OrganizationBean createOrg(NewOrganizationBean newOrgDto) throws OrganizationAlreadyExistsException, NotAuthorizedException, InvalidNameException {
        if (this.config.isAdminOnlyOrgCreationEnabled()) {
            this.securityContext.checkAdminPermissions();
        }
        LOGGER.debug("Attempting to create org: {0}", new Object[]{newOrgDto});
        return this.organizationService.createOrg(newOrgDto);
    }

    public OrganizationBean getOrg(String organizationId) throws OrganizationNotFoundException {
        LOGGER.debug("Attempting to get org: {0}", new Object[]{organizationId});
        OrganizationBean organizationBean = this.organizationService.getOrg(organizationId);
        if (this.securityContext.hasPermission(PermissionType.orgView, organizationId)) {
            return organizationBean;
        }
        return RestHelper.hideSensitiveDataFromOrganizationBean(organizationBean);
    }

    public void updateOrg(String organizationId, UpdateOrganizationBean updateOrgDto) throws OrganizationNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.orgEdit, organizationId);
        LOGGER.debug("Attempting to update org {0}: {1}", new Object[]{organizationId, updateOrgDto});
        this.organizationService.updateOrg(organizationId, updateOrgDto);
    }

    public void deleteOrg(String organizationId) throws OrganizationNotFoundException, NotAuthorizedException, EntityStillActiveException {
        this.securityContext.checkPermissions(PermissionType.orgAdmin, organizationId);
        LOGGER.debug("Attempting to delete org: {0}", new Object[]{organizationId});
        this.organizationService.deleteOrg(organizationId);
    }

    public SearchResultsBean<AuditEntryBean> getOrgActivity(String organizationId, int page, int pageSize) throws OrganizationNotFoundException, NotAuthorizedException {
        if (!this.securityContext.isMemberOf(organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        LOGGER.debug("Attempting to get org activity: {0} (page {1} / pageSize {2}", new Object[]{organizationId, page, pageSize});
        return this.organizationService.activity(organizationId, page, pageSize);
    }

    public ClientBean createClient(String organizationId, NewClientBean bean) throws OrganizationNotFoundException, ClientAlreadyExistsException, NotAuthorizedException, InvalidNameException {
        LOGGER.debug("Attempting to create client {0} in org {1}", new Object[]{bean, organizationId});
        this.securityContext.checkPermissions(PermissionType.clientEdit, organizationId);
        this.blobStore.attachToBlob(bean.getImage());
        return this.clientService.createClient(organizationId, bean);
    }

    public ClientBean getClient(String organizationId, String clientId) throws ClientNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientView, organizationId);
        LOGGER.debug("Attempting to get client {0} in org {1}", new Object[]{clientId, organizationId});
        return this.clientService.getClient(organizationId, clientId);
    }

    public void updateClient(String organizationId, String clientId, UpdateClientBean bean) throws ClientNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientEdit, organizationId);
        LOGGER.debug("Attempting to update client {0} in org {1} with {2}", new Object[]{clientId, organizationId, bean});
        this.clientService.updateClient(organizationId, clientId, bean);
    }

    public void deleteClient(String organizationId, String clientId) throws OrganizationNotFoundException, NotAuthorizedException, EntityStillActiveException {
        this.securityContext.checkPermissions(PermissionType.clientAdmin, organizationId);
        LOGGER.debug("Attempting to delete client {0} in org {1}", new Object[]{clientId, organizationId});
        this.clientService.deleteClient(organizationId, clientId);
    }

    public SearchResultsBean<AuditEntryBean> getClientActivity(String organizationId, String clientId, int page, int pageSize) throws ClientNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientView, organizationId);
        LOGGER.debug("Attempting to get activity for client {0} in org {1}", new Object[]{clientId, organizationId});
        return this.clientService.getClientActivity(organizationId, clientId, page, pageSize);
    }

    public List<ClientSummaryBean> listClients(String organizationId) throws OrganizationNotFoundException, NotAuthorizedException {
        this.securityContext.checkAllPermissions(Set.of(PermissionType.orgView, PermissionType.clientView), organizationId);
        LOGGER.debug("Attempting to list all clients in org {1}", new Object[]{organizationId});
        return this.clientService.listClients(organizationId);
    }

    public ClientVersionBean createClientVersion(String organizationId, String clientId, NewClientVersionBean newClientVersion) throws ClientNotFoundException, NotAuthorizedException, InvalidVersionException, ClientVersionAlreadyExistsException {
        this.securityContext.checkPermissions(PermissionType.clientEdit, organizationId);
        LOGGER.debug("Attempting to create clientVersion {0} in org {1} with {2}", new Object[]{clientId, organizationId, newClientVersion});
        return this.clientService.createClientVersion(organizationId, clientId, newClientVersion);
    }

    public List<ClientVersionSummaryBean> listClientVersions(String organizationId, String clientId) throws ClientNotFoundException, NotAuthorizedException {
        this.securityContext.checkAllPermissions(Set.of(PermissionType.orgView, PermissionType.clientView), organizationId);
        LOGGER.debug("Attempting to list all clientVersions in client {0} in org {1}", new Object[]{clientId, organizationId});
        return this.clientService.listClientVersions(organizationId, clientId);
    }

    public ApiKeyBean updateClientApiKey(String organizationId, String clientId, String version, ApiKeyBean bean) throws ClientNotFoundException, NotAuthorizedException, InvalidVersionException, InvalidClientStatusException {
        this.securityContext.checkPermissions(PermissionType.clientEdit, organizationId);
        LOGGER.debug("Attempting to update client {0} with version {1} API key in org {2} with {3}", new Object[]{clientId, version, organizationId, bean});
        return this.clientService.updateClientApiKey(organizationId, clientId, version, bean);
    }

    public ApiKeyBean getClientApiKey(String organizationId, String clientId, String version) throws ClientNotFoundException, NotAuthorizedException, InvalidVersionException {
        this.securityContext.checkPermissions(PermissionType.clientView, organizationId);
        LOGGER.debug("Attempting to get client {0} with version {1} API key in org {2}", new Object[]{clientId, version, organizationId});
        return this.clientService.getClientApiKey(organizationId, clientId, version);
    }

    public ClientVersionBean getClientVersion(String organizationId, String clientId, String version) throws ClientVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientView, organizationId);
        LOGGER.debug("Attempting to get client {0} with version {1} in org {1}", new Object[]{clientId, version, organizationId});
        return this.clientService.getClientVersion(organizationId, clientId, version);
    }

    public SearchResultsBean<AuditEntryBean> getClientVersionActivity(String organizationId, String clientId, String version, int page, int pageSize) throws ClientVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientView, organizationId);
        return this.clientService.getClientVersionActivity(organizationId, clientId, version, page, pageSize);
    }

    public ClientUsagePerApiBean getClientUsagePerApi(String organizationId, String clientId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        this.securityContext.checkPermissions(PermissionType.clientView, organizationId);
        return this.statsService.getClientUsagePerApi(organizationId, clientId, version, fromDate, toDate);
    }

    private boolean isDiscoverable(NewContractBean bean) {
        return this.securityContext.isDiscoverable(ISecurityContext.EntityType.API, bean.getApiOrgId(), bean.getApiId(), bean.getApiVersion()) && this.securityContext.isDiscoverable(ISecurityContext.EntityType.PLAN, bean.getApiOrgId(), bean.getPlanId());
    }

    public ContractBean createContract(String organizationId, String clientId, String version, NewContractBean bean) throws OrganizationNotFoundException, ClientNotFoundException, ApiNotFoundException, PlanNotFoundException, ContractAlreadyExistsException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientEdit, organizationId);
        boolean hasApiOrgPermissions = this.securityContext.hasAllPermissions(Set.of(PermissionType.apiView, PermissionType.planView), bean.getApiOrgId());
        if (hasApiOrgPermissions || this.isDiscoverable(bean)) {
            return this.contractService.createContract(organizationId, clientId, version, bean);
        }
        throw ExceptionFactory.notAuthorizedException();
    }

    public ContractBean getContract(String organizationId, String clientId, String version, Long contractId) throws ClientNotFoundException, ContractNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientView, organizationId);
        return this.contractService.getContract(contractId);
    }

    public Response probeContractPolicy(String organizationId, String clientId, String version, Long contractId, long policyId, String rawString) throws ClientNotFoundException, ContractNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientView, organizationId);
        List<IPolicyProbeResponse> probeResponses = this.contractService.probePolicy(contractId, policyId, rawString);
        return Response.ok(probeResponses).build();
    }

    public List<ContractSummaryBean> getClientVersionContracts(String organizationId, String clientId, String version) throws ClientNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientView, organizationId);
        return this.clientService.getClientVersionContracts(organizationId, clientId, version);
    }

    public Response getApiRegistryJSON(String organizationId, String clientId, String version, String download) throws ClientNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientView, organizationId);
        if (BooleanUtils.toBoolean((String)download)) {
            String path = String.format("%s/%s/%s", organizationId, clientId, version);
            DownloadBean dbean = (DownloadBean)this.tryAction(() -> this.downloadManager.createDownload(DownloadType.apiRegistryJson, path));
            return Response.ok((Object)dbean, (String)"application/json").build();
        }
        return this.getApiRegistryJSONInternal(organizationId, clientId, version);
    }

    public Response getApiRegistryJSONInternal(String organizationId, String clientId, String version) throws ClientVersionNotFoundException {
        ApiRegistryBean apiRegistry = this.organizationService.getApiRegistry(organizationId, clientId, version);
        return Response.ok((Object)apiRegistry, (String)"application/json").header("Content-Disposition", (Object)"attachment; filename=api-registry.json").build();
    }

    public Response getApiRegistryXML(String organizationId, String clientId, String version, String download) throws ClientVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientView, organizationId);
        if (BooleanUtils.toBoolean((String)download)) {
            return (Response)this.tryAction(() -> {
                String path = String.format("%s/%s/%s", organizationId, clientId, version);
                DownloadBean dbean = this.downloadManager.createDownload(DownloadType.apiRegistryXml, path);
                return Response.ok((Object)dbean, (String)"application/json").build();
            });
        }
        return this.getApiRegistryXMLInternal(organizationId, clientId, version);
    }

    public Response getApiRegistryXMLInternal(String organizationId, String clientId, String version) throws ClientVersionNotFoundException {
        ApiRegistryBean apiRegistry = this.organizationService.getApiRegistry(organizationId, clientId, version);
        return Response.ok((Object)apiRegistry, (String)"application/xml").header("Content-Disposition", (Object)"attachment; filename=api-registry.xml").build();
    }

    public void deleteAllContracts(String organizationId, String clientId, String version) throws ClientNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientEdit, organizationId);
        this.contractService.deleteAllContracts(organizationId, clientId, version);
    }

    public void deleteContract(String organizationId, String clientId, String version, Long contractId) throws ClientNotFoundException, ContractNotFoundException, NotAuthorizedException, InvalidClientStatusException {
        this.securityContext.checkPermissions(PermissionType.clientEdit, organizationId);
        this.contractService.deleteContract(organizationId, clientId, version, contractId);
    }

    public PolicyBean createClientPolicy(String organizationId, String clientId, String version, NewPolicyBean bean) throws OrganizationNotFoundException, ClientVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientEdit, organizationId);
        return this.clientService.createClientPolicy(organizationId, clientId, version, bean);
    }

    public PolicyBean getClientPolicy(String organizationId, String clientId, String version, long policyId) throws OrganizationNotFoundException, ClientVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientView, organizationId);
        return this.clientService.getClientPolicy(organizationId, clientId, version, policyId);
    }

    public void updateClientPolicy(String organizationId, String clientId, String version, long policyId, UpdatePolicyBean bean) throws OrganizationNotFoundException, ClientVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientEdit, organizationId);
        this.clientService.updateClientPolicy(organizationId, clientId, version, policyId, bean);
    }

    public void deleteClientPolicy(String organizationId, String clientId, String version, long policyId) throws OrganizationNotFoundException, ClientVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientEdit, organizationId);
        this.clientService.deleteClientPolicy(organizationId, clientId, version, policyId);
    }

    public List<PolicySummaryBean> listClientPolicies(String organizationId, String clientId, String version) throws OrganizationNotFoundException, ClientVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientView, organizationId);
        return this.clientService.listClientPolicies(organizationId, clientId, version);
    }

    public void reorderClientPolicies(String organizationId, String clientId, String version, PolicyChainBean policyChain) throws OrganizationNotFoundException, ClientVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.clientEdit, organizationId);
        this.clientService.reorderClientPolicies(organizationId, clientId, version, policyChain);
    }

    public ApiBeanDto createApi(String organizationId, NewApiBean bean) throws OrganizationNotFoundException, ApiAlreadyExistsException, NotAuthorizedException, InvalidNameException {
        this.securityContext.checkPermissions(PermissionType.apiEdit, organizationId);
        this.blobStore.attachToBlob(bean.getImage());
        return this.apiService.createApi(organizationId, bean);
    }

    public List<ApiSummaryBean> listApis(String organizationId) throws OrganizationNotFoundException {
        if (this.securityContext.hasAllPermissions(Set.of(PermissionType.orgView, PermissionType.apiView), organizationId)) {
            return this.apiService.listApis(organizationId);
        }
        return this.apiService.listApis(organizationId).stream().filter(api -> this.securityContext.isDiscoverable(ISecurityContext.EntityType.API, organizationId, api.getId())).collect(Collectors.toList());
    }

    public ApiBeanDto getApi(String organizationId, String apiId) throws ApiNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, organizationId, apiId, Set.of(PermissionType.apiView));
        return this.apiService.getApi(organizationId, apiId);
    }

    public void updateApi(String organizationId, String apiId, UpdateApiBean bean) throws ApiNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.apiEdit, organizationId);
        this.apiService.updateApi(organizationId, apiId, bean);
    }

    public void tagApi(String organizationId, String apiId, KeyValueTagDto bean) throws ApiNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.apiEdit, organizationId);
        this.apiService.addTag(organizationId, apiId, bean);
    }

    public void deleteApi(String organizationId, String apiId) throws ApiNotFoundException, NotAuthorizedException, InvalidApiStatusException {
        this.securityContext.checkPermissions(PermissionType.apiAdmin, organizationId);
        this.apiService.deleteApi(organizationId, apiId);
    }

    public void deleteApiImage(String organizationId, String apiId) throws ApiNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.apiEdit, organizationId);
        this.apiService.deleteApiImage(organizationId, apiId);
    }

    public SearchResultsBean<AuditEntryBean> getApiActivity(String organizationId, String apiId, int page, int pageSize) throws ApiNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.apiView, organizationId);
        return this.apiService.getApiActivity(organizationId, apiId, page, pageSize);
    }

    public ApiVersionBeanDto createApiVersion(String organizationId, String apiId, NewApiVersionBean bean) throws ApiNotFoundException, NotAuthorizedException, InvalidVersionException, ApiVersionAlreadyExistsException {
        this.securityContext.checkPermissions(PermissionType.apiEdit, organizationId);
        return this.apiService.createApiVersion(organizationId, apiId, bean);
    }

    public List<ApiVersionSummaryBean> listApiVersions(String organizationId, String apiId) throws ApiNotFoundException {
        if (this.securityContext.hasPermission(PermissionType.apiView, organizationId)) {
            return this.apiService.listApiVersions(organizationId, apiId);
        }
        return this.apiService.listApiVersions(organizationId, apiId).stream().filter(avb -> this.securityContext.isDiscoverable(ISecurityContext.EntityType.API, organizationId, apiId, avb.getVersion())).collect(Collectors.toList());
    }

    public ApiVersionBeanDto getApiVersion(String organizationId, String apiId, String version) throws ApiVersionNotFoundException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, organizationId, apiId, version, Set.of(PermissionType.apiView));
        if (this.securityContext.hasPermission(PermissionType.apiView, organizationId)) {
            return this.apiService.getApiVersion(organizationId, apiId, version);
        }
        ApiVersionBeanDto av = this.apiService.getApiVersion(organizationId, apiId, version);
        Set filteredPlans = av.getPlans().stream().filter(avp -> this.securityContext.getPermittedDiscoverabilities().contains(avp.getDiscoverability())).collect(Collectors.toSet());
        av.setPlans(filteredPlans);
        return av;
    }

    public ApiVersionStatusBean getApiVersionStatus(String organizationId, String apiId, String version) throws ApiVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, organizationId, apiId, version, Set.of(PermissionType.apiView));
        return this.apiService.getApiVersionStatus(organizationId, apiId, version);
    }

    public Response getApiDefinition(String organizationId, String apiId, String version) throws ApiVersionNotFoundException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, organizationId, apiId, version, Set.of(PermissionType.apiView));
        ApiService.ApiDefinitionStream apiDef = this.apiService.getApiDefinition(organizationId, apiId, version);
        return Response.ok().entity((Object)apiDef.getDefinition()).type(apiDef.getDefinitionType().getMediaType()).build();
    }

    public ApiVersionEndpointSummaryBean getApiVersionEndpointInfo(String organizationId, String apiId, String version) throws ApiVersionNotFoundException, InvalidApiStatusException, GatewayNotFoundException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, organizationId, apiId, version, Set.of(PermissionType.apiView));
        return this.apiService.getApiVersionEndpointInfo(organizationId, apiId, version);
    }

    public ApiVersionBeanDto updateApiVersion(String organizationId, String apiId, String version, @Valid UpdateApiVersionBean bean) throws ApiVersionNotFoundException, NotAuthorizedException, InvalidApiStatusException {
        this.securityContext.checkPermissions(PermissionType.apiEdit, organizationId);
        return this.apiService.updateApiVersion(organizationId, apiId, version, bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateApiDefinition(String organizationId, String apiId, String version) throws ApiVersionNotFoundException, NotAuthorizedException, InvalidApiStatusException {
        ServletInputStream data;
        this.securityContext.checkPermissions(PermissionType.apiEdit, organizationId);
        String contentType = this.request.getContentType();
        try {
            data = this.request.getInputStream();
        }
        catch (IOException e) {
            throw new SystemErrorException((Throwable)e);
        }
        try {
            ApiDefinitionType newDefinitionType;
            if (contentType.toLowerCase().contains("application/json")) {
                newDefinitionType = ApiDefinitionType.SwaggerJSON;
            } else if (contentType.toLowerCase().contains("application/x-yaml")) {
                newDefinitionType = ApiDefinitionType.SwaggerYAML;
            } else if (contentType.toLowerCase().contains("application/wsdl+xml")) {
                newDefinitionType = ApiDefinitionType.WSDL;
            } else {
                throw new SystemErrorException(Messages.i18n.format("InvalidApiDefinitionContentType", new Object[]{contentType}));
            }
            this.apiService.setApiDefinition(organizationId, apiId, version, newDefinitionType, (InputStream)data);
            LOGGER.debug("Updated API definition for {0}", new Object[]{apiId});
        }
        finally {
            IOUtils.closeQuietly((InputStream)data);
        }
    }

    public void updateApiDefinitionFromURL(String organizationId, String apiId, String version, NewApiDefinitionBean bean) throws ApiVersionNotFoundException, NotAuthorizedException, InvalidApiStatusException {
        this.securityContext.checkPermissions(PermissionType.apiEdit, organizationId);
        try {
            URL url = new URL(bean.getDefinitionUrl());
            InputStream is = url.openStream();
            this.apiService.setApiDefinition(organizationId, apiId, version, bean, is);
        }
        catch (IOException ioe) {
            throw new SystemErrorException((Throwable)ioe);
        }
    }

    public SearchResultsBean<AuditEntryBean> getApiVersionActivity(String organizationId, String apiId, String version, int page, int pageSize) throws ApiVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, organizationId, apiId, version, Set.of(PermissionType.apiView));
        return this.apiService.getApiVersionActivity(organizationId, apiId, version, page, pageSize);
    }

    public List<ApiPlanSummaryBean> getApiVersionPlans(String organizationId, String apiId, String version) throws ApiVersionNotFoundException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, organizationId, apiId, version, Set.of(PermissionType.apiView));
        if (this.securityContext.hasPermission(PermissionType.apiView, organizationId)) {
            return this.apiService.getApiVersionPlans(organizationId, apiId, version);
        }
        return this.apiService.getApiVersionPlans(organizationId, apiId, version).stream().filter(avp -> this.securityContext.getPermittedDiscoverabilities().contains(avp.getDiscoverability())).collect(Collectors.toList());
    }

    public void reorderApiPlans(String organizationId, String apiId, String version, ApiPlanOrderDto apiPlanOrder) throws ApiVersionNotFoundException {
        this.securityContext.checkPermissions(PermissionType.apiEdit, organizationId);
        this.apiService.reorderApiPlans(organizationId, apiId, version, apiPlanOrder);
    }

    public PolicyBean createApiPolicy(String organizationId, String apiId, String version, NewPolicyBean bean) throws OrganizationNotFoundException, ApiVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.apiEdit, organizationId);
        return this.apiService.createApiPolicy(organizationId, apiId, version, bean);
    }

    public PolicyBean getApiPolicy(String organizationId, String apiId, String version, long policyId) throws OrganizationNotFoundException, ApiVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, organizationId, apiId, version, Set.of(PermissionType.apiView));
        return this.apiService.getApiPolicy(organizationId, apiId, version, policyId);
    }

    public void updateApiPolicy(String organizationId, String apiId, String version, long policyId, UpdatePolicyBean bean) throws OrganizationNotFoundException, ApiVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.apiEdit, organizationId);
        this.apiService.updateApiPolicy(organizationId, apiId, version, policyId, bean);
    }

    public void deleteApiPolicy(String organizationId, String apiId, String version, long policyId) throws OrganizationNotFoundException, ApiVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.apiEdit, organizationId);
        this.apiService.deleteApiPolicy(organizationId, apiId, version, policyId);
    }

    public void deleteApiDefinition(String organizationId, String apiId, String version) throws OrganizationNotFoundException, ApiVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.apiEdit, organizationId);
        this.apiService.deleteApiDefinition(organizationId, apiId, version);
    }

    public List<PolicySummaryBean> listApiPolicies(String organizationId, String apiId, String version) throws OrganizationNotFoundException, ApiVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, organizationId, apiId, version, Set.of(PermissionType.apiView));
        return this.apiService.listApiPolicies(organizationId, apiId, version);
    }

    public void reorderApiPolicies(String organizationId, String apiId, String version, PolicyChainBean policyChain) throws OrganizationNotFoundException, ApiVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.apiEdit, organizationId);
        this.apiService.reorderApiPolicies(organizationId, apiId, version, policyChain);
    }

    public PolicyChainBean getApiPolicyChain(String organizationId, String apiId, String version, String planId) throws ApiVersionNotFoundException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, organizationId, apiId, version, Set.of(PermissionType.apiView));
        return this.apiService.getApiPolicyChain(organizationId, apiId, version, planId);
    }

    public List<ContractSummaryBean> getApiVersionContracts(String organizationId, String apiId, String version, int page, int pageSize) throws ApiVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, organizationId, apiId, version, Set.of(PermissionType.apiView));
        return this.apiService.getApiVersionContracts(organizationId, apiId, version, page, pageSize);
    }

    public PlanBean createPlan(String organizationId, NewPlanBean bean) throws OrganizationNotFoundException, PlanAlreadyExistsException, NotAuthorizedException, InvalidNameException {
        this.securityContext.checkPermissions(PermissionType.apiView, organizationId);
        return this.planService.createPlan(organizationId, bean);
    }

    public PlanBean getPlan(String organizationId, String planId) throws PlanNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.PLAN, organizationId, planId, Set.of(PermissionType.planView));
        return this.planService.getPlan(organizationId, planId);
    }

    public SearchResultsBean<AuditEntryBean> getPlanActivity(String organizationId, String planId, int page, int pageSize) throws PlanNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.PLAN, organizationId, planId, Set.of(PermissionType.planView));
        return this.planService.getPlanActivity(organizationId, planId, page, pageSize);
    }

    public List<PlanSummaryBean> listPlans(String organizationId) throws OrganizationNotFoundException, NotAuthorizedException {
        if (this.securityContext.hasPermission(PermissionType.planView, organizationId)) {
            return this.planService.listPlans(organizationId);
        }
        return this.planService.listPlans(organizationId).stream().filter(plan -> this.securityContext.isDiscoverable(ISecurityContext.EntityType.PLAN, organizationId, plan.getId())).collect(Collectors.toList());
    }

    public void updatePlan(String organizationId, String planId, UpdatePlanBean bean) throws PlanNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.planEdit, organizationId);
        this.planService.updatePlan(organizationId, planId, bean);
    }

    public PlanVersionBean createPlanVersion(String organizationId, String planId, NewPlanVersionBean bean) throws PlanNotFoundException, NotAuthorizedException, InvalidVersionException, PlanVersionAlreadyExistsException {
        this.securityContext.checkPermissions(PermissionType.planEdit, organizationId);
        return this.planService.createPlanVersion(organizationId, planId, bean);
    }

    public List<PlanVersionSummaryBean> listPlanVersions(String organizationId, String planId) throws PlanNotFoundException, NotAuthorizedException {
        if (this.securityContext.hasPermission(PermissionType.planView, organizationId)) {
            return this.planService.listPlanVersions(organizationId, planId);
        }
        return this.planService.listPlanVersions(organizationId, planId).stream().filter(pvb -> this.securityContext.isDiscoverable(ISecurityContext.EntityType.PLAN, organizationId, planId, pvb.getVersion())).collect(Collectors.toList());
    }

    public PlanVersionBean getPlanVersion(String organizationId, String planId, String version) throws PlanVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.PLAN, organizationId, planId, Set.of(PermissionType.planView));
        return this.planService.getPlanVersion(organizationId, planId, version);
    }

    public SearchResultsBean<AuditEntryBean> getPlanVersionActivity(String organizationId, String planId, String version, int page, int pageSize) throws PlanVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.PLAN, organizationId, planId, Set.of(PermissionType.planView));
        return this.planService.getPlanVersionActivity(organizationId, planId, version, page, pageSize);
    }

    public PolicyBean createPlanPolicy(String organizationId, String planId, String version, NewPolicyBean bean) throws OrganizationNotFoundException, PlanVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.planEdit, organizationId);
        return this.planService.createPlanPolicy(organizationId, planId, version, bean);
    }

    public List<PolicySummaryBean> listPlanPolicies(String organizationId, String planId, String version) throws OrganizationNotFoundException, PlanVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.PLAN, organizationId, planId, Set.of(PermissionType.planView));
        return this.planService.listPlanPolicies(organizationId, planId, version);
    }

    public PolicyBean getPlanPolicy(String organizationId, String planId, String version, long policyId) throws OrganizationNotFoundException, PlanVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.PLAN, organizationId, planId, Set.of(PermissionType.planView));
        return this.planService.getPlanPolicy(organizationId, planId, version, policyId);
    }

    public void updatePlanPolicy(String organizationId, String planId, String version, long policyId, UpdatePolicyBean bean) throws OrganizationNotFoundException, PlanVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.planEdit, organizationId);
        this.planService.updatePlanPolicy(organizationId, planId, version, policyId, bean);
    }

    public void deletePlanPolicy(String organizationId, String planId, String version, long policyId) throws OrganizationNotFoundException, PlanVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.planEdit, organizationId);
        this.planService.deletePlanPolicy(organizationId, planId, version, policyId);
    }

    public void deletePlan(String organizationId, String planId) throws PlanNotFoundException, NotAuthorizedException, InvalidPlanStatusException {
        this.securityContext.checkPermissions(PermissionType.planAdmin, organizationId);
        this.planService.deletePlan(organizationId, planId);
    }

    public void reorderPlanPolicies(String organizationId, String planId, String version, PolicyChainBean policyChain) throws OrganizationNotFoundException, PlanVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.planEdit, organizationId);
        this.planService.reorderPlanPolicies(organizationId, planId, version, policyChain);
    }

    public void grant(String organizationId, GrantRolesBean bean) throws OrganizationNotFoundException, RoleNotFoundException, UserNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.orgAdmin, organizationId);
        this.organizationService.grant(organizationId, bean);
    }

    public void revoke(String organizationId, String roleId, String userId) throws OrganizationNotFoundException, RoleNotFoundException, UserNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.orgAdmin, organizationId);
        this.organizationService.revoke(organizationId, roleId, userId);
    }

    public void revokeAll(String organizationId, String userId) throws OrganizationNotFoundException, RoleNotFoundException, UserNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissions(PermissionType.orgAdmin, organizationId);
        this.organizationService.revokeAll(organizationId, userId);
    }

    public List<MemberBean> listMembers(String organizationId) throws OrganizationNotFoundException, NotAuthorizedException {
        if (!this.securityContext.isMemberOf(organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        return this.organizationService.listMembers(organizationId);
    }

    public UsageHistogramBean getUsage(String organizationId, String apiId, String version, HistogramIntervalType interval, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        this.securityContext.checkPermissions(PermissionType.apiView, organizationId);
        return this.statsService.getUsage(organizationId, apiId, version, interval, fromDate, toDate);
    }

    public UsagePerClientBean getUsagePerClient(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        this.securityContext.checkPermissions(PermissionType.apiView, organizationId);
        return this.statsService.getUsagePerClient(organizationId, apiId, version, fromDate, toDate);
    }

    public UsagePerPlanBean getUsagePerPlan(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        this.securityContext.checkPermissions(PermissionType.apiView, organizationId);
        return this.statsService.getUsagePerPlan(organizationId, apiId, version, fromDate, toDate);
    }

    public ResponseStatsHistogramBean getResponseStats(String organizationId, String apiId, String version, HistogramIntervalType interval, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        this.securityContext.checkPermissions(PermissionType.apiView, organizationId);
        return this.statsService.getResponseStats(organizationId, apiId, version, interval, fromDate, toDate);
    }

    public ResponseStatsSummaryBean getResponseStatsSummary(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        this.securityContext.checkPermissions(PermissionType.apiView, organizationId);
        return this.statsService.getResponseStatsSummary(organizationId, apiId, version, fromDate, toDate);
    }

    public ResponseStatsPerClientBean getResponseStatsPerClient(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        this.securityContext.checkPermissions(PermissionType.apiView, organizationId);
        return this.statsService.getResponseStatsPerClient(organizationId, apiId, version, fromDate, toDate);
    }

    public ResponseStatsPerPlanBean getResponseStatsPerPlan(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        this.securityContext.checkPermissions(PermissionType.apiView, organizationId);
        return this.statsService.getResponseStatsPerPlan(organizationId, apiId, version, fromDate, toDate);
    }
}

