/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.events.dto.NewAccountCreatedDto;
import io.apiman.manager.api.rest.IEventResource;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.service.SsoEventService;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class EventResourceImpl
implements IEventResource {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(EventResourceImpl.class);
    private ISecurityContext securityContext;
    private SsoEventService ssoEventService;

    @Inject
    public EventResourceImpl(ISecurityContext securityContext, SsoEventService ssoEventService) {
        this.securityContext = securityContext;
        this.ssoEventService = ssoEventService;
    }

    public EventResourceImpl() {
    }

    public void newAccountCreated(NewAccountCreatedDto newAccountCreatedDto) {
        this.securityContext.checkAdminPermissions();
        LOGGER.debug("Received new account event via HTTP");
        this.ssoEventService.newAccountCreated(newAccountCreatedDto);
    }
}

