/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.manager.api.beans.download.DownloadBean;
import io.apiman.manager.api.core.IDownloadManager;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.IDownloadResource;
import io.apiman.manager.api.rest.IOrganizationResource;
import io.apiman.manager.api.rest.ISystemResource;
import io.apiman.manager.api.rest.exceptions.DownloadNotFoundException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@ApplicationScoped
@Transactional
public class DownloadResourceImpl
implements IDownloadResource {
    private IDownloadManager downloadManager;
    private ISystemResource system;
    private IOrganizationResource orgs;
    @Context
    private HttpServletRequest request;

    @Inject
    public DownloadResourceImpl(IDownloadManager downloadManager, ISystemResource system, IOrganizationResource orgs) {
        this.downloadManager = downloadManager;
        this.system = system;
        this.orgs = orgs;
    }

    public DownloadResourceImpl() {
    }

    public Response download(String downloadId) throws DownloadNotFoundException {
        DownloadBean download;
        try {
            download = this.downloadManager.getDownload(downloadId);
            if (download == null) {
                throw new DownloadNotFoundException();
            }
        }
        catch (StorageException e) {
            throw new DownloadNotFoundException((Throwable)e);
        }
        String path = download.getPath();
        switch (download.getType()) {
            case apiRegistryJson: {
                ApiRegistryInfo info = this.parseApiRegistryPath(path);
                return this.orgs.getApiRegistryJSONInternal(info.organizationId, info.clientId, info.version);
            }
            case apiRegistryXml: {
                ApiRegistryInfo info = this.parseApiRegistryPath(path);
                return this.orgs.getApiRegistryXMLInternal(info.organizationId, info.clientId, info.version);
            }
            case exportJson: {
                return this.system.exportData();
            }
        }
        throw new DownloadNotFoundException();
    }

    private ApiRegistryInfo parseApiRegistryPath(String path) {
        String[] split = path.split("/");
        ApiRegistryInfo info = new ApiRegistryInfo();
        info.organizationId = split[0];
        info.clientId = split[1];
        info.version = split[2];
        return info;
    }

    private static class ApiRegistryInfo {
        public String organizationId;
        public String clientId;
        public String version;

        private ApiRegistryInfo() {
        }
    }
}

