/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.apis.dto.ApiVersionBeanDto;
import io.apiman.manager.api.beans.developers.ApiVersionPolicySummaryDto;
import io.apiman.manager.api.beans.developers.DeveloperApiPlanSummaryDto;
import io.apiman.manager.api.beans.idm.DiscoverabilityLevel;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.orgs.NewOrganizationBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.ApiVersionEndpointSummaryBean;
import io.apiman.manager.api.beans.summary.ApiVersionSummaryBean;
import io.apiman.manager.api.beans.summary.PolicySummaryBean;
import io.apiman.manager.api.rest.IDeveloperPortalResource;
import io.apiman.manager.api.rest.exceptions.ApiVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.GatewayNotFoundException;
import io.apiman.manager.api.rest.exceptions.InvalidApiStatusException;
import io.apiman.manager.api.rest.exceptions.InvalidSearchCriteriaException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.OrganizationNotFoundException;
import io.apiman.manager.api.rest.exceptions.PlanVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.PolicyNotFoundException;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.util.PermissionsHelper;
import io.apiman.manager.api.rest.impl.util.RestHelper;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.service.ApiService;
import io.apiman.manager.api.service.DevPortalService;
import io.apiman.manager.api.service.OrganizationService;
import io.apiman.manager.api.service.PlanService;
import io.apiman.manager.api.service.SearchService;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@ApplicationScoped
@Transactional
@Path(value="devportal")
public class DeveloperPortalResourceImpl
implements IDeveloperPortalResource {
    private final IApimanLogger LOG = ApimanLoggerFactory.getLogger(DeveloperPortalResourceImpl.class);
    private ApiService apiService;
    private PlanService planService;
    private DevPortalService portalService;
    private OrganizationService orgService;
    private SearchService searchService;
    private ISecurityContext securityContext;

    @Inject
    public DeveloperPortalResourceImpl(ApiService apiService, PlanService planService, DevPortalService portalService, OrganizationService orgService, SearchService searchService, ISecurityContext securityContext) {
        this.apiService = apiService;
        this.planService = planService;
        this.portalService = portalService;
        this.orgService = orgService;
        this.searchService = searchService;
        this.securityContext = securityContext;
    }

    public DeveloperPortalResourceImpl() {
    }

    public SearchResultsBean<ApiSummaryBean> searchApis(SearchCriteriaBean criteria) throws OrganizationNotFoundException, InvalidSearchCriteriaException {
        this.LOG.debug("Searching for APIs by criteria {0}", new Object[]{criteria});
        return this.searchService.findApis(criteria, PermissionsHelper.orgConstraints(this.securityContext, PermissionType.apiView));
    }

    public SearchResultsBean<ApiSummaryBean> getFeaturedApis() {
        this.LOG.debug("Getting all featured APIs");
        return this.searchService.findAllFeaturedApis(PermissionsHelper.orgConstraints(this.securityContext, PermissionType.apiView));
    }

    public List<ApiVersionSummaryBean> listApiVersions(String orgId, String apiId) {
        this.LOG.debug("Listing all API versions");
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, orgId, apiId, Set.of(PermissionType.apiView));
        return this.apiService.listApiVersions(orgId, apiId).stream().filter(av -> this.securityContext.hasPermissionsOrDiscoverable(ISecurityContext.EntityType.API, orgId, apiId, av.getVersion(), Set.of(PermissionType.apiView))).collect(Collectors.toList());
    }

    public ApiVersionBeanDto getApiVersion(String orgId, String apiId, String apiVersion) {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, orgId, apiId, apiVersion, Set.of(PermissionType.apiView));
        ApiVersionBeanDto v = this.apiService.getApiVersion(orgId, apiId, apiVersion);
        Set filteredPlans = v.getPlans().stream().filter(ap -> this.securityContext.hasPermission(PermissionType.planView, orgId) || this.permittedDiscoverability(ap.getDiscoverability())).collect(Collectors.toSet());
        v.setPlans(filteredPlans);
        return RestHelper.hideSensitiveDataFromApiVersionBean(v);
    }

    public List<DeveloperApiPlanSummaryDto> getApiVersionPlans(String orgId, String apiId, String apiVersion) {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, orgId, apiId, apiVersion, Set.of(PermissionType.apiView));
        return this.portalService.getApiVersionPlans(orgId, apiId, apiVersion).stream().filter(ap -> this.securityContext.hasPermission(PermissionType.planView, orgId) || this.permittedDiscoverability(ap.getDiscoverability())).collect(Collectors.toList());
    }

    public Response createHomeOrgForDeveloper(NewOrganizationBean newOrg) {
        this.mustBeLoggedIn();
        if (!newOrg.getName().equals(this.securityContext.getCurrentUser())) {
            return Response.status((int)422, (String)"A developer's default org name must be identical to their username (case sensitive). This restriction may be lifted later.").build();
        }
        return Response.ok((Object)this.portalService.createHomeOrg(newOrg)).build();
    }

    public List<ApiVersionPolicySummaryDto> listApiPolicies(String orgId, String apiId, String apiVersion) throws OrganizationNotFoundException, ApiVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, orgId, apiId, apiVersion, Set.of(PermissionType.apiView));
        return this.portalService.getApiVersionPolicies(orgId, apiId, apiVersion);
    }

    public Response getApiDefinition(String orgId, String apiId, String apiVersion) throws ApiVersionNotFoundException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, orgId, apiId, apiVersion, Set.of(PermissionType.apiView));
        ApiService.ApiDefinitionStream apiDef = this.apiService.getApiDefinition(orgId, apiId, apiVersion);
        return Response.ok().entity((Object)apiDef.getDefinition()).type(apiDef.getDefinitionType().getMediaType()).build();
    }

    public ApiVersionEndpointSummaryBean getApiVersionEndpointInfo(String orgId, String apiId, String apiVersion) throws ApiVersionNotFoundException, InvalidApiStatusException, GatewayNotFoundException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.API, orgId, apiId, apiVersion, Set.of(PermissionType.apiView));
        return this.apiService.getApiVersionEndpointInfo(orgId, apiId, apiVersion);
    }

    public List<PolicySummaryBean> listPlanPolicies(String orgId, String planId, String version) throws OrganizationNotFoundException, PlanVersionNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.PLAN, orgId, planId, version, Set.of(PermissionType.planView));
        return this.planService.listPlanPolicies(orgId, planId, version);
    }

    public PolicyBean getPlanPolicy(String orgId, String planId, String version, long policyId) throws OrganizationNotFoundException, PlanVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        this.securityContext.checkPermissionsOrDiscoverability(ISecurityContext.EntityType.PLAN, orgId, planId, version, Set.of(PermissionType.planView));
        return this.planService.getPlanPolicy(orgId, planId, version, policyId);
    }

    private void mustBeLoggedIn() {
        if (this.securityContext.getCurrentUser() == null) {
            throw ExceptionFactory.notAuthorizedException();
        }
    }

    boolean permittedDiscoverability(DiscoverabilityLevel dl) {
        return this.securityContext.getPermittedDiscoverabilities().contains(dl);
    }
}

