/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.util.Preconditions;
import io.apiman.manager.api.beans.download.BlobDto;
import io.apiman.manager.api.beans.download.BlobRef;
import io.apiman.manager.api.core.IBlobStore;
import io.apiman.manager.api.rest.IBlobResource;
import io.apiman.manager.api.rest.impl.util.MultipartHelper;
import io.apiman.manager.api.security.ISecurityContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;

@ApplicationScoped
public class BlobResourceImpl
implements IBlobResource {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(BlobResourceImpl.class);
    private static final Pattern IMAGE_SUBTYPES_ALLOWED = Pattern.compile("^(apng|png|jpg|jpeg|jfif|pjpeg|pjp|svg|webp|gif|avif)$", 2);
    private IBlobStore blobStore;
    private ISecurityContext securityContext;

    @Inject
    public BlobResourceImpl(IBlobStore blobStore, ISecurityContext securityContext) {
        this.blobStore = blobStore;
        this.securityContext = securityContext;
    }

    public BlobResourceImpl() {
    }

    public Response getBlob(String uid) {
        BlobDto blob = this.blobStore.getBlob(uid);
        if (blob == null) {
            LOGGER.trace("Blob requested but not found: {0}", new Object[]{uid});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            LOGGER.trace("Blob requested: {0}", new Object[]{blob});
            InputStream bis = blob.getBlob().asByteSource().openBufferedStream();
            return Response.ok().header("Content-Type", (Object)blob.getMimeType()).entity((Object)bis).build();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public Response uploadBlob(MultipartFormDataInput multipartInput) throws IOException {
        Preconditions.checkState((this.securityContext.getCurrentUser() != null ? 1 : 0) != 0, (Object)"Must be logged in!");
        MultipartHelper.MultipartUploadHolder image = MultipartHelper.getRequiredImage(multipartInput, "image", 0x100000L);
        Preconditions.checkArgument((boolean)this.checkExtension(image.getMediaType().getSubtype()), (Object)("Must have a recognised image content type (" + IMAGE_SUBTYPES_ALLOWED + ")"));
        String filename = System.currentTimeMillis() + "." + image.getMediaType().getSubtype();
        BlobRef blobRef = this.blobStore.storeBlob(filename, image.getMediaType().toString(), image.getFileBackedOutputStream(), 0);
        URI location = UriBuilder.fromResource(IBlobResource.class).path(blobRef.getId()).build(new Object[0]);
        return Response.created((URI)location).entity((Object)blobRef).build();
    }

    private boolean checkExtension(String ext) {
        return IMAGE_SUBTYPES_ALLOWED.matcher(ext).matches();
    }
}

