/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.micro;

import io.apiman.manager.api.micro.User;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public final class Users {
    public static final String USERS_FILE_PROP = "apiman.micro.manager.users-file";

    public static final List<User> getUsers() throws Exception {
        ArrayList<User> rval;
        block7: {
            block6: {
                rval = new ArrayList<User>();
                URL usersUrl = Users.getUsersUrl();
                if (usersUrl == null) break block6;
                System.out.println("Loading users from: " + usersUrl);
                InputStream in = null;
                BufferedReader reader = null;
                try {
                    in = usersUrl.openStream();
                    reader = new BufferedReader(new InputStreamReader(in));
                    String line = reader.readLine();
                    while (line != null) {
                        if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                        String[] split = line.split(",");
                        User user = new User();
                        user.setId(split[0]);
                        user.setPassword(split[1]);
                        user.getRoles().add("apiuser");
                        boolean isAdmin = "true".equals(split[2]);
                        if (isAdmin) {
                            user.getRoles().add("apiadmin");
                        }
                        rval.add(user);
                        System.out.println("  added user => " + user.getId());
                        line = reader.readLine();
                    }
                }
                catch (Throwable t) {
                    try {
                        throw new RuntimeException(t);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly((InputStream)in);
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((Reader)reader);
                break block7;
            }
            System.out.println("Using default users.");
            User user = new User();
            user.setId("admin");
            user.setPassword("admin123!");
            user.getRoles().add("apiuser");
            user.getRoles().add("apiadmin");
            rval.add(user);
        }
        return rval;
    }

    private static URL getUsersUrl() throws Exception {
        String usersLoc = System.getProperty(USERS_FILE_PROP);
        if (usersLoc == null) {
            return null;
        }
        try {
            File usersFile = new File(usersLoc);
            if (usersFile.isFile()) {
                return usersFile.toURI().toURL();
            }
        }
        catch (Exception usersFile) {
            // empty catch block
        }
        URL url = new URL(usersLoc);
        return url;
    }
}

