/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.micro;

import io.apiman.common.logging.IApimanDelegateLogger;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.plugin.Plugin;
import io.apiman.common.plugin.PluginClassLoader;
import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.common.util.ReflectionUtils;
import io.apiman.common.util.crypt.CurrentDataEncrypter;
import io.apiman.common.util.crypt.IDataEncrypter;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.core.IApiCatalog;
import io.apiman.manager.api.core.IApiKeyGenerator;
import io.apiman.manager.api.core.IMetricsAccessor;
import io.apiman.manager.api.core.INewUserBootstrapper;
import io.apiman.manager.api.core.IPluginRegistry;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.UuidApiKeyGenerator;
import io.apiman.manager.api.core.crypt.DefaultDataEncrypter;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.core.i18n.Messages;
import io.apiman.manager.api.core.logging.ApimanLogger;
import io.apiman.manager.api.core.logging.JsonLoggerImpl;
import io.apiman.manager.api.core.logging.StandardLoggerImpl;
import io.apiman.manager.api.core.noop.NoOpMetricsAccessor;
import io.apiman.manager.api.es.ESMetricsAccessor;
import io.apiman.manager.api.es.EsStorage;
import io.apiman.manager.api.jpa.JpaStorage;
import io.apiman.manager.api.micro.ManagerApiMicroServiceConfig;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.security.impl.DefaultSecurityContext;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;

@ApplicationScoped
public class ManagerApiMicroServiceCdiFactory {
    private static JestClient sStorageESClient;
    private static JestClient sMetricsESClient;
    private static EsStorage sESStorage;

    @Produces
    @ApimanLogger
    public static IApimanLogger provideLogger(ManagerApiMicroServiceConfig config, InjectionPoint injectionPoint) {
        try {
            ApimanLogger logger = (ApimanLogger)injectionPoint.getAnnotated().getAnnotation(ApimanLogger.class);
            Class klazz = logger.value();
            return ManagerApiMicroServiceCdiFactory.getDelegate(config).newInstance().createLogger(klazz);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(String.format(Messages.i18n.format("LoggerFactory.InstantiationFailed", new Object[0]), new Object[0]), e);
        }
    }

    @Produces
    @ApplicationScoped
    public static INewUserBootstrapper provideNewUserBootstrapper(ManagerApiMicroServiceConfig config, IPluginRegistry pluginRegistry) {
        String type = config.getNewUserBootstrapperType();
        if (type == null) {
            return new INewUserBootstrapper(){

                public void bootstrapUser(UserBean user, IStorage storage) throws StorageException {
                }
            };
        }
        try {
            return ManagerApiMicroServiceCdiFactory.createCustomComponent(INewUserBootstrapper.class, config.getNewUserBootstrapperType(), config.getNewUserBootstrapperProperties(), pluginRegistry);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error or unknown user bootstrapper type: " + config.getNewUserBootstrapperType(), t);
        }
    }

    @Produces
    @ApplicationScoped
    public static IStorage provideStorage(ManagerApiMicroServiceConfig config, @New JpaStorage jpaStorage, @New EsStorage esStorage, IPluginRegistry pluginRegistry) {
        JpaStorage storage;
        if ("jpa".equals(config.getStorageType())) {
            storage = jpaStorage;
        } else if ("es".equals(config.getStorageType())) {
            storage = ManagerApiMicroServiceCdiFactory.initES(config, esStorage);
        } else {
            try {
                storage = ManagerApiMicroServiceCdiFactory.createCustomComponent(IStorage.class, config.getStorageType(), config.getStorageProperties(), pluginRegistry);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error or unknown storage type: " + config.getStorageType(), t);
            }
        }
        return storage;
    }

    @Produces
    @ApplicationScoped
    public static ISecurityContext provideSecurityContext(@New DefaultSecurityContext defaultSC) {
        return defaultSC;
    }

    @Produces
    @ApplicationScoped
    public static IStorageQuery provideStorageQuery(ManagerApiMicroServiceConfig config, @New JpaStorage jpaStorage, @New EsStorage esStorage, IPluginRegistry pluginRegistry) {
        if ("jpa".equals(config.getStorageQueryType())) {
            return jpaStorage;
        }
        if ("es".equals(config.getStorageQueryType())) {
            return ManagerApiMicroServiceCdiFactory.initES(config, esStorage);
        }
        try {
            return ManagerApiMicroServiceCdiFactory.createCustomComponent(IStorageQuery.class, config.getStorageQueryType(), config.getStorageQueryProperties(), pluginRegistry);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error or unknown storage query type: " + config.getStorageType(), t);
        }
    }

    @Produces
    @ApplicationScoped
    public static IMetricsAccessor provideMetricsAccessor(ManagerApiMicroServiceConfig config, @New NoOpMetricsAccessor noopMetrics, @New ESMetricsAccessor esMetrics, IPluginRegistry pluginRegistry) {
        ESMetricsAccessor metrics;
        if ("es".equals(config.getMetricsType())) {
            metrics = esMetrics;
        } else {
            try {
                metrics = ManagerApiMicroServiceCdiFactory.createCustomComponent(IMetricsAccessor.class, config.getMetricsType(), config.getMetricsProperties(), pluginRegistry);
            }
            catch (Throwable t) {
                System.err.println("Unknown apiman metrics accessor type: " + config.getMetricsType());
                metrics = noopMetrics;
            }
        }
        return metrics;
    }

    @Produces
    @ApplicationScoped
    public static IApiKeyGenerator provideApiKeyGenerator(ManagerApiMicroServiceConfig config, IPluginRegistry pluginRegistry, @New UuidApiKeyGenerator uuidApiKeyGen) {
        UuidApiKeyGenerator apiKeyGenerator;
        String type = config.getApiKeyGeneratorType();
        if ("uuid".equals(type)) {
            apiKeyGenerator = uuidApiKeyGen;
        } else {
            try {
                apiKeyGenerator = ManagerApiMicroServiceCdiFactory.createCustomComponent(IApiKeyGenerator.class, type, config.getApiKeyGeneratorProperties(), pluginRegistry);
            }
            catch (Exception e) {
                System.err.println("Unknown apiman API key generator type: " + type);
                System.err.println("Automatically falling back to UUID style API Keys.");
                apiKeyGenerator = uuidApiKeyGen;
            }
        }
        return apiKeyGenerator;
    }

    @Produces
    @ApplicationScoped
    public static IDataEncrypter provideDataEncrypter(ManagerApiMicroServiceConfig config, IPluginRegistry pluginRegistry, @New DefaultDataEncrypter defaultEncrypter) {
        try {
            IDataEncrypter encrypter;
            CurrentDataEncrypter.instance = encrypter = (IDataEncrypter)ManagerApiMicroServiceCdiFactory.createCustomComponent(IDataEncrypter.class, config.getDataEncrypterType(), config.getDataEncrypterProperties(), pluginRegistry, defaultEncrypter);
            return encrypter;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error or unknown data encrypter type: " + config.getDataEncrypterType(), t);
        }
    }

    @Produces
    @ApplicationScoped
    public static IApiCatalog provideApiCatalog(ManagerApiMicroServiceConfig config, IPluginRegistry pluginRegistry) {
        try {
            return ManagerApiMicroServiceCdiFactory.createCustomComponent(IApiCatalog.class, config.getApiCatalogType(), config.getApiCatalogProperties(), pluginRegistry);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error or unknown API catalog type: " + config.getApiCatalogType(), t);
        }
    }

    @Produces
    @ApplicationScoped
    @Named(value="storage")
    public static JestClient provideStorageESClient(ManagerApiMicroServiceConfig config) {
        if ("es".equals(config.getStorageType()) && sStorageESClient == null) {
            sStorageESClient = ManagerApiMicroServiceCdiFactory.createStorageJestClient(config);
        }
        return sStorageESClient;
    }

    @Produces
    @ApplicationScoped
    @Named(value="metrics")
    public static JestClient provideMetricsESClient(ManagerApiMicroServiceConfig config) {
        if ("es".equals(config.getMetricsType()) && sMetricsESClient == null) {
            sMetricsESClient = ManagerApiMicroServiceCdiFactory.createMetricsJestClient(config);
        }
        return sMetricsESClient;
    }

    private static JestClient createStorageJestClient(ManagerApiMicroServiceConfig config) {
        StringBuilder builder = new StringBuilder();
        builder.append(config.getStorageESProtocol());
        builder.append("://");
        builder.append(config.getStorageESHost());
        builder.append(":");
        builder.append(config.getStorageESPort());
        String connectionUrl = builder.toString();
        JestClientFactory factory = new JestClientFactory();
        HttpClientConfig.Builder httpConfig = (HttpClientConfig.Builder)new HttpClientConfig.Builder(connectionUrl).multiThreaded(true);
        String username = config.getStorageESUsername();
        String password = config.getStorageESPassword();
        if (username != null) {
            httpConfig.defaultCredentials(username, password);
        }
        httpConfig.connTimeout(config.getStorageESTimeout());
        httpConfig.readTimeout(config.getStorageESTimeout());
        factory.setHttpClientConfig(httpConfig.build());
        return factory.getObject();
    }

    private static JestClient createMetricsJestClient(ManagerApiMicroServiceConfig config) {
        StringBuilder builder = new StringBuilder();
        builder.append(config.getMetricsESProtocol());
        builder.append("://");
        builder.append(config.getMetricsESHost());
        builder.append(":");
        builder.append(config.getMetricsESPort());
        String connectionUrl = builder.toString();
        JestClientFactory factory = new JestClientFactory();
        HttpClientConfig.Builder httpConfig = (HttpClientConfig.Builder)new HttpClientConfig.Builder(connectionUrl).multiThreaded(true);
        String username = config.getMetricsESUsername();
        String password = config.getMetricsESPassword();
        if (username != null) {
            httpConfig.defaultCredentials(username, password);
        }
        httpConfig.connTimeout(config.getMetricsESTimeout());
        httpConfig.readTimeout(config.getMetricsESTimeout());
        factory.setHttpClientConfig(httpConfig.build());
        return factory.getObject();
    }

    private static EsStorage initES(ManagerApiMicroServiceConfig config, EsStorage esStorage) {
        if (sESStorage == null) {
            sESStorage = esStorage;
            sESStorage.setIndexName(config.getStorageESIndexName());
            if (config.isInitializeStorageES()) {
                sESStorage.initialize();
            }
        }
        return sESStorage;
    }

    private static <T> T createCustomComponent(Class<T> componentType, String componentSpec, Map<String, String> configProperties, IPluginRegistry pluginRegistry) throws Exception {
        return ManagerApiMicroServiceCdiFactory.createCustomComponent(componentType, componentSpec, configProperties, pluginRegistry, null);
    }

    private static <T> T createCustomComponent(Class<T> componentType, String componentSpec, Map<String, String> configProperties, IPluginRegistry pluginRegistry, T defaultComponent) throws Exception {
        if (componentSpec == null && defaultComponent == null) {
            throw new IllegalArgumentException("Null component type.");
        }
        if (componentSpec == null && defaultComponent != null) {
            return defaultComponent;
        }
        if (componentSpec.startsWith("class:")) {
            Class c = ReflectionUtils.loadClass((String)componentSpec.substring("class:".length()));
            return ManagerApiMicroServiceCdiFactory.createCustomComponent(componentType, c, configProperties);
        }
        if (componentSpec.startsWith("plugin:")) {
            PluginCoordinates coordinates = PluginCoordinates.fromPolicySpec((String)componentSpec);
            if (coordinates == null) {
                throw new IllegalArgumentException("Invalid plugin component spec: " + componentSpec);
            }
            int ssidx = componentSpec.indexOf(47);
            if (ssidx == -1) {
                throw new IllegalArgumentException("Invalid plugin component spec: " + componentSpec);
            }
            String classname = componentSpec.substring(ssidx + 1);
            Plugin plugin = pluginRegistry.loadPlugin(coordinates);
            PluginClassLoader classLoader = plugin.getLoader();
            Class class1 = classLoader.loadClass(classname);
            return ManagerApiMicroServiceCdiFactory.createCustomComponent(componentType, class1, configProperties);
        }
        Class c = ReflectionUtils.loadClass((String)componentSpec);
        return ManagerApiMicroServiceCdiFactory.createCustomComponent(componentType, c, configProperties);
    }

    private static <T> T createCustomComponent(Class<T> componentType, Class<?> componentClass, Map<String, String> configProperties) throws Exception {
        if (componentClass == null) {
            throw new IllegalArgumentException("Invalid component spec (class not found).");
        }
        try {
            Constructor<?> constructor = componentClass.getConstructor(Map.class);
            return (T)constructor.newInstance(configProperties);
        }
        catch (Exception exception) {
            return (T)componentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    private static Class<? extends IApimanDelegateLogger> getDelegate(ManagerApiMicroServiceConfig config) {
        String loggerName = config.getLoggerName();
        if (loggerName == null || StringUtils.isEmpty((String)loggerName)) {
            loggerName = "json";
        }
        switch (loggerName.toLowerCase()) {
            case "json": {
                return JsonLoggerImpl.class;
            }
            case "standard": {
                return StandardLoggerImpl.class;
            }
        }
        return ManagerApiMicroServiceCdiFactory.loadByFQDN(loggerName);
    }

    private static Class<? extends IApimanDelegateLogger> loadByFQDN(String fqdn) {
        try {
            return Class.forName(fqdn);
        }
        catch (ClassNotFoundException e) {
            System.err.println(String.format(Messages.i18n.format("LoggerFactory.LoggerNotFoundOnClasspath", new Object[0]), fqdn));
            return StandardLoggerImpl.class;
        }
    }
}

