/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.beans.util;

import io.apiman.gateway.engine.beans.util.CaseInsensitiveStringMultiMap;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QueryMap
extends CaseInsensitiveStringMultiMap
implements Serializable {
    private static final long serialVersionUID = -3539301043663183648L;

    public QueryMap() {
    }

    public QueryMap(int sizeHint) {
        super(sizeHint);
    }

    @Override
    public String toString() {
        return this.toQueryString();
    }

    public String toQueryString() {
        List<Map.Entry<String, String>> elems = this.getEntries();
        Collections.reverse(elems);
        return elems.stream().map(pair -> this.URLEnc((String)pair.getKey()) + "=" + this.URLEnc((String)pair.getValue())).collect(Collectors.joining("&"));
    }

    private String URLEnc(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Unable to URLEncode" + str);
            return str;
        }
    }
}

