/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.beans.util;

import io.apiman.gateway.engine.beans.util.IStringMultiMap;
import java.io.Serializable;
import java.nio.ByteOrder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.openhft.hashing.Access;
import net.openhft.hashing.LongHashFunction;

public class CaseInsensitiveStringMultiMap
implements IStringMultiMap,
Serializable {
    private static final long serialVersionUID = -2052530527825235543L;
    private static final Access<String> LOWER_CASE_ACCESS_INSTANCE = new LowerCaseAccess();
    private Element[] hashArray;
    private int keyCount = 0;

    public CaseInsensitiveStringMultiMap() {
        this.hashArray = new Element[32];
    }

    public CaseInsensitiveStringMultiMap(int sizeHint) {
        this.hashArray = new Element[(int)((double)sizeHint * 1.25)];
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return new ElemIterator(this.hashArray);
    }

    @Override
    public IStringMultiMap put(String key, String value) {
        long keyHash = this.getHash(key);
        int idx = this.getIndex(keyHash);
        if (this.hashArray[idx] == null) {
            ++this.keyCount;
            this.hashArray[idx] = new Element(key, value, keyHash);
        } else {
            this.remove(key);
            this.add(key, value);
        }
        return this;
    }

    private int getIndex(long hash) {
        return Math.abs((int)(hash % (long)this.hashArray.length));
    }

    private long getHash(String text) {
        return LongHashFunction.xx_r39().hash((Object)text, LOWER_CASE_ACCESS_INSTANCE, 0L, (long)text.length());
    }

    @Override
    public IStringMultiMap putAll(Map<String, String> map) {
        map.entrySet().stream().forEachOrdered(pair -> this.put((String)pair.getKey(), (String)pair.getValue()));
        return this;
    }

    @Override
    public IStringMultiMap add(String key, String value) {
        long hash = this.getHash(key);
        int idx = this.getIndex(hash);
        Element existingHead = this.hashArray[idx];
        if (existingHead == null) {
            this.hashArray[idx] = new Element(key, value, hash);
            ++this.keyCount;
        } else {
            if (existingHead.getByHash(hash, key) == null) {
                ++this.keyCount;
            }
            Element newHead = new Element(key, value, hash);
            newHead.previous = existingHead;
            this.hashArray[idx] = newHead;
        }
        return this;
    }

    private Element getElement(String key) {
        long hash = this.getHash(key);
        Element head = this.hashArray[this.getIndex(hash)];
        return head == null ? null : head.getByHash(hash, key);
    }

    @Override
    public IStringMultiMap addAll(Map<String, String> map) {
        map.entrySet().stream().forEachOrdered(pair -> this.put((String)pair.getKey(), (String)pair.getValue()));
        return this;
    }

    @Override
    public IStringMultiMap addAll(IStringMultiMap map) {
        map.getEntries().stream().forEachOrdered(pair -> this.add((String)pair.getKey(), (String)pair.getValue()));
        return this;
    }

    @Override
    public IStringMultiMap remove(String key) {
        long hash = this.getHash(key);
        int idx = this.getIndex(hash);
        Element headElem = this.hashArray[idx];
        if (headElem != null) {
            this.hashArray[idx] = headElem.removeByHash(hash, key);
        }
        return this;
    }

    @Override
    public String get(String key) {
        Element elem = this.getElement(key);
        return elem == null ? null : (String)elem.getValue();
    }

    @Override
    public List<Map.Entry<String, String>> getAllEntries(String key) {
        if (this.keyCount > 0) {
            Element elem = this.getElement(key);
            return elem == null ? Collections.emptyList() : elem.getAllEntries(key, this.getHash(key));
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getAll(String key) {
        if (this.keyCount > 0) {
            Element elem = this.getElement(key);
            return elem == null ? Collections.emptyList() : elem.getAllValues(key, this.getHash(key));
        }
        return Collections.emptyList();
    }

    @Override
    public int size() {
        return this.keyCount;
    }

    @Override
    public List<Map.Entry<String, String>> getEntries() {
        ArrayList<Map.Entry<String, String>> entryList = new ArrayList<Map.Entry<String, String>>(this.keyCount);
        for (Element oElem : this.hashArray) {
            if (oElem == null) continue;
            for (Element iElem = oElem; iElem != null; iElem = iElem.getNext()) {
                entryList.add(iElem);
            }
        }
        return entryList;
    }

    @Override
    public Map<String, String> toMap() {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Element oElem : this.hashArray) {
            if (oElem == null) continue;
            for (Map.Entry<String, String> iElem : oElem.getAllEntries()) {
                if (map.containsKey(iElem.getKey())) continue;
                map.put(iElem.getKey(), iElem.getValue());
            }
        }
        return map;
    }

    @Override
    public boolean containsKey(String key) {
        long hash = this.getHash(key);
        int idx = this.getIndex(hash);
        return this.hashArray[idx] != null && this.hashArray[idx].getByHash(hash, key) != null;
    }

    @Override
    public Set<String> keySet() {
        return this.toMap().keySet();
    }

    @Override
    public IStringMultiMap clear() {
        this.hashArray = new Element[this.hashArray.length];
        this.keyCount = 0;
        return this;
    }

    public String toString() {
        String elems = this.keySet().stream().map(this::getAllEntries).map(pairs -> (String)((Map.Entry)pairs.get(0)).getKey() + " => [" + this.joinValues((List<Map.Entry<String, String>>)pairs) + "]").collect(Collectors.joining(", "));
        return "{" + elems + "}";
    }

    private String joinValues(List<Map.Entry<String, String>> pairs) {
        return IntStream.rangeClosed(1, pairs.size()).mapToObj(i -> (Map.Entry)pairs.get(pairs.size() - i)).map(Map.Entry::getValue).collect(Collectors.joining(", "));
    }

    private static boolean insensitiveEquals(String a, String b) {
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            char charB;
            char charA = a.charAt(i);
            if (charA == (charB = b.charAt(i))) continue;
            if (charA >= 'A' && charA <= 'Z' && charA + 32 != charB) {
                return false;
            }
            if (charB < 'A' || charB > 'Z' || charB + 32 == charA) continue;
            return false;
        }
        return true;
    }

    private static final class LowerCaseAccess
    extends Access<String> {
        private LowerCaseAccess() {
        }

        public int getByte(String input, long offset) {
            char c = input.charAt((int)offset);
            if (c >= 'A' && c <= 'Z') {
                return c + 32;
            }
            return c;
        }

        public ByteOrder byteOrder(String input) {
            return ByteOrder.nativeOrder();
        }
    }

    private static final class ElemIterator
    implements Iterator<Map.Entry<String, String>> {
        final Element[] hashTable;
        Element next;
        Element selected;
        int idx = 0;

        public ElemIterator(Element[] hashTable) {
            this.hashTable = hashTable;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.setNext();
            }
            return this.next != null;
        }

        @Override
        public Map.Entry<String, String> next() {
            this.selected = this.next;
            this.setNext();
            return this.selected;
        }

        private void setNext() {
            if (this.selected != null && this.selected.hasNext()) {
                this.next = this.selected.getNext();
            } else {
                while (this.idx < this.hashTable.length) {
                    if (this.hashTable[this.idx] != null) {
                        this.next = this.hashTable[this.idx];
                        ++this.idx;
                        return;
                    }
                    ++this.idx;
                }
                this.next = null;
            }
        }
    }

    private final class Element
    extends AbstractMap.SimpleImmutableEntry<String, String>
    implements Iterable<Map.Entry<String, String>> {
        private static final long serialVersionUID = 4505963331324890429L;
        private final long keyHash;
        private Element previous;

        public Element(String key, String value, long keyHash) {
            super(key, value);
            this.previous = null;
            this.keyHash = keyHash;
        }

        public Element removeByHash(long hash, String key) {
            Element current = this;
            Element newHead = null;
            Element link = null;
            boolean removedAny = false;
            while (current != null) {
                if (current.eq(hash, key)) {
                    Element prev = current.previous;
                    current.previous = null;
                    current = prev;
                    removedAny = true;
                    if (link == null) continue;
                    link.previous = prev;
                    continue;
                }
                if (newHead == null) {
                    newHead = link = current;
                    current = newHead.previous;
                    continue;
                }
                link.previous = link = current;
                current = current.previous;
            }
            if (removedAny) {
                CaseInsensitiveStringMultiMap.this.keyCount--;
            }
            return newHead;
        }

        private boolean eq(long hashCode, String key) {
            return this.getKeyHash() == hashCode && CaseInsensitiveStringMultiMap.insensitiveEquals(key, (String)this.getKey());
        }

        public Element getByHash(long hashCode, String key) {
            return this.getKeyHash() == hashCode && CaseInsensitiveStringMultiMap.insensitiveEquals(key, (String)this.getKey()) ? this : this.getNext(hashCode, key);
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return this.getAllEntries().iterator();
        }

        public List<Map.Entry<String, String>> getAllEntries(String key, long hashCode) {
            ArrayList<Map.Entry<String, String>> allElems = new ArrayList<Map.Entry<String, String>>();
            for (Element elem = this; elem != null; elem = elem.getNext()) {
                if (elem.getKeyHash() != hashCode || !CaseInsensitiveStringMultiMap.insensitiveEquals(key, (String)elem.getKey())) continue;
                allElems.add(elem);
            }
            return allElems;
        }

        public List<Map.Entry<String, String>> getAllEntries() {
            ArrayList<Map.Entry<String, String>> allElems = new ArrayList<Map.Entry<String, String>>();
            for (Element elem = this; elem != null; elem = elem.getNext()) {
                allElems.add(elem);
            }
            return allElems;
        }

        public long getKeyHash() {
            return this.keyHash;
        }

        public List<String> getAllValues(String key, long hashCode) {
            ArrayList<String> allElems = new ArrayList<String>();
            for (Element elem = this; elem != null; elem = elem.getNext()) {
                if (elem.getKeyHash() != hashCode || !CaseInsensitiveStringMultiMap.insensitiveEquals(key, (String)elem.getKey())) continue;
                allElems.add((String)elem.getValue());
            }
            return allElems;
        }

        public boolean hasNext() {
            return this.previous != null;
        }

        public Element getNext() {
            return this.previous;
        }

        public Element getNext(long hash, String key) {
            Element elem = this;
            while (elem.previous != null) {
                elem = elem.previous;
                if (elem.getKeyHash() != hash || !CaseInsensitiveStringMultiMap.insensitiveEquals((String)elem.getKey(), key)) continue;
                return elem;
            }
            return null;
        }
    }
}

