/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.util.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class KeyStoreUtil {
    public static KeyManager[] getKeyManagers(Info pathInfo) throws Exception {
        if (pathInfo.store == null) {
            return null;
        }
        File clientKeyStoreFile = new File(pathInfo.store);
        if (!clientKeyStoreFile.isFile()) {
            throw new Exception("No KeyManager: " + pathInfo.store + " does not exist or is not a file.");
        }
        String clientKeyStorePassword = pathInfo.password;
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream clientFis = new FileInputStream(pathInfo.store);
        keyStore.load(clientFis, clientKeyStorePassword.toCharArray());
        clientFis.close();
        kmf.init(keyStore, clientKeyStorePassword.toCharArray());
        return kmf.getKeyManagers();
    }

    public static TrustManager[] getTrustManagers(Info pathInfo) throws Exception {
        File trustStoreFile = new File(pathInfo.store);
        if (!trustStoreFile.isFile()) {
            throw new Exception("No TrustManager: " + pathInfo.store + " does not exist.");
        }
        String trustStorePassword = pathInfo.password;
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore truststore = KeyStore.getInstance("JKS");
        FileInputStream fis = new FileInputStream(pathInfo.store);
        truststore.load(fis, trustStorePassword.toCharArray());
        fis.close();
        tmf.init(truststore);
        return tmf.getTrustManagers();
    }

    public static class Info {
        String store;
        String password;

        public Info(String store, String password) {
            this.store = store;
            this.password = password;
        }
    }
}

