/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> void callIfExists(T object, String methodName) throws SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            Method method = object.getClass().getMethod(methodName, new Class[0]);
            method.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static Class<?> loadClass(String classname) {
        Class<?> c = null;
        try {
            c = Class.forName(classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (c == null) {
            try {
                c = ReflectionUtils.class.getClassLoader().loadClass(classname);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (c == null) {
            try {
                c = Thread.currentThread().getContextClassLoader().loadClass(classname);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return c;
    }

    public static Method findSetter(Class<?> onClass, Class<?> targetClass) {
        Method[] methods;
        for (Method method : methods = onClass.getMethods()) {
            Class<?>[] ptypes = method.getParameterTypes();
            if (!method.getName().startsWith("set") || ptypes.length != 1 || ptypes[0] != targetClass) continue;
            return method;
        }
        return null;
    }
}

