/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.datastructures.map;

import java.util.LinkedHashMap;
import java.util.Map;

public abstract class LRUMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 8404941290861582868L;
    private int maxElems;

    public LRUMap(int initialCapacity, float loadFactor, int maxElems) {
        super(initialCapacity, loadFactor);
        this.maxElems = maxElems;
    }

    public LRUMap(int initialCapacity, int maxElems) {
        super(initialCapacity);
        this.maxElems = maxElems;
    }

    public LRUMap(int maxElems) {
        this.maxElems = maxElems;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.size() > this.maxElems) {
            this.handleRemovedElem(eldest);
            return true;
        }
        return false;
    }

    protected abstract void handleRemovedElem(Map.Entry<K, V> var1);
}

