/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.node10.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.ScriptTask;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.fs.FileStats;
import io.apigee.trireme.node10.modules.StatsImpl;
import java.io.File;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatWatcher
extends ScriptableObject {
    public static final String CLASS_NAME = "StatWatcher";
    private static final Logger log = LoggerFactory.getLogger(StatWatcher.class);
    private static final FileStats EMPTY_STATS = new FileStats();
    private Function onchange;
    private Function onstop;
    private ScriptRunner runner;
    private FileStats lastStats;
    private String origPath;
    private boolean persistent;
    private File file;
    private Future<?> timer;
    private Object domain;

    public String getClassName() {
        return CLASS_NAME;
    }

    @JSFunction
    public static void start(Context cx, Scriptable thisObj, Object[] args, Function func) {
        String filename = ArgUtils.stringArg((Object[])args, (int)0);
        boolean persistent = ArgUtils.booleanArg((Object[])args, (int)1);
        long interval = ArgUtils.longArg((Object[])args, (int)2);
        final StatWatcher self = (StatWatcher)thisObj;
        self.runner = (ScriptRunner)cx.getThreadLocal((Object)"runner");
        self.file = self.runner.translatePath(filename);
        self.origPath = filename;
        self.persistent = persistent;
        if (persistent) {
            self.runner.pin();
        }
        if (log.isDebugEnabled()) {
            log.debug("Going to poll stats on {} every {} milliseconds", (Object)filename, (Object)interval);
        }
        self.domain = self.runner.getDomain();
        self.timer = self.runner.createTimedTask(new Runnable(){

            public void run() {
                self.updateStats();
            }
        }, interval, TimeUnit.MILLISECONDS, true, self.domain);
        self.runner.getAsyncPool().execute(new Runnable(){

            public void run() {
                self.lastStats = self.getStats();
            }
        });
    }

    @JSFunction
    public static void stop(Context cx, Scriptable thisObj, Object[] args, Function func) {
        StatWatcher self = (StatWatcher)thisObj;
        if (self.timer != null) {
            self.timer.cancel(false);
            if (self.onstop != null) {
                self.onstop.call(cx, (Scriptable)self.onstop, null, Context.emptyArgs);
            }
        }
        if (self.persistent) {
            self.runner.unPin();
        }
    }

    private FileStats getStats() {
        try {
            return this.runner.getFilesystem().stat(this.file, this.origPath, false);
        }
        catch (OSException ose) {
            return EMPTY_STATS;
        }
    }

    private void updateStats() {
        this.runner.getAsyncPool().execute(new Runnable(){

            public void run() {
                final FileStats newStats = StatWatcher.this.getStats();
                if (!newStats.equals((Object)StatWatcher.this.lastStats)) {
                    log.debug("New and old stats differ -- firing callback");
                    final FileStats oldStats = StatWatcher.this.lastStats;
                    StatWatcher.this.runner.enqueueTask(new ScriptTask(){

                        public void execute(Context cx, Scriptable scope) {
                            StatWatcher.this.fireCallback(cx, oldStats, newStats);
                        }
                    }, StatWatcher.this.domain);
                }
                StatWatcher.this.lastStats = newStats;
            }
        });
    }

    private void fireCallback(Context cx, FileStats os2, FileStats ns) {
        if (this.onchange == null) {
            return;
        }
        StatsImpl oldStats = (StatsImpl)cx.newObject((Scriptable)this, "Stats");
        oldStats.setAttributes(cx, os2);
        StatsImpl newStats = (StatsImpl)cx.newObject((Scriptable)this, "Stats");
        newStats.setAttributes(cx, ns);
        this.onchange.call(cx, (Scriptable)this.onchange, null, new Object[]{newStats, oldStats, 0});
    }

    @JSGetter(value="onchange")
    public Function getOnChange() {
        return this.onchange;
    }

    @JSSetter(value="onchange")
    public void setOnChange(Function f) {
        this.onchange = f;
    }

    @JSGetter(value="onstop")
    public Function getOnStop() {
        return this.onstop;
    }

    @JSSetter(value="onchange")
    public void setOnStop(Function f) {
        this.onstop = f;
    }
}

