/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.net.spi;

public class PauseHelper {
    private final FlowControl control;
    private final int waterMark;
    private boolean pauseRequested;
    private int queueSize;
    private boolean paused;

    public PauseHelper(FlowControl control, int waterMark) {
        this.control = control;
        this.waterMark = waterMark;
    }

    public synchronized void pause() {
        this.pauseRequested = true;
        if (!this.paused) {
            this.paused = true;
            this.control.doPause();
        }
    }

    public synchronized void resume() {
        this.pauseRequested = false;
        if (this.paused && this.queueSize <= this.waterMark) {
            this.paused = false;
            this.control.doResume();
        }
    }

    public synchronized void incrementQueueLength(int delta) {
        this.queueSize += delta;
        if (this.paused && this.queueSize <= this.waterMark && !this.pauseRequested) {
            this.paused = false;
            this.control.doResume();
        } else if (!this.paused && this.queueSize > this.waterMark) {
            this.paused = true;
            this.control.doPause();
        }
    }

    public synchronized int getQueueLength() {
        return this.queueSize;
    }

    public static interface FlowControl {
        public void doPause();

        public void doResume();
    }
}

