/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.net.internal;

import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.ScriptTask;
import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.handles.AbstractHandle;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import io.apigee.trireme.kernel.handles.SocketHandle;
import io.apigee.trireme.net.spi.HttpRequestAdapter;
import io.apigee.trireme.net.spi.UpgradedSocket;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class UpgradedSocketDelegate
extends AbstractHandle
implements SocketHandle {
    private final NodeRuntime runtime;
    private final UpgradedSocket adapterSocket;
    private final InetSocketAddress localAddress;
    private final InetSocketAddress remoteAddress;

    public UpgradedSocketDelegate(UpgradedSocket adapterSocket, NodeRuntime runtime, HttpRequestAdapter request) {
        this.runtime = runtime;
        this.adapterSocket = adapterSocket;
        this.localAddress = new InetSocketAddress(request.getLocalAddress(), request.getLocalPort());
        this.remoteAddress = new InetSocketAddress(request.getRemoteAddress(), request.getRemotePort());
    }

    public int write(ByteBuffer buf, final IOCompletionHandler<Integer> handler) {
        final Object domain = this.runtime.getDomain();
        return this.adapterSocket.write(buf, new IOCompletionHandler<Integer>(){

            public void ioComplete(final int errCode, final Integer value) {
                UpgradedSocketDelegate.this.runtime.enqueueTask(new ScriptTask(){

                    @Override
                    public void execute(Context cx, Scriptable scope) {
                        handler.ioComplete(errCode, (Object)value);
                    }
                }, domain);
            }
        });
    }

    public void startReading(final IOCompletionHandler<ByteBuffer> handler) {
        this.adapterSocket.startReading(new IOCompletionHandler<ByteBuffer>(){

            public void ioComplete(final int errCode, final ByteBuffer value) {
                UpgradedSocketDelegate.this.runtime.enqueueTask(new ScriptTask(){

                    @Override
                    public void execute(Context cx, Scriptable scope) {
                        handler.ioComplete(errCode, (Object)value);
                    }
                });
            }
        });
    }

    public void stopReading() {
        this.adapterSocket.stopReading();
    }

    public void close() {
        this.adapterSocket.close();
    }

    public void shutdown(final IOCompletionHandler<Integer> handler) {
        this.adapterSocket.shutdownOutput(new IOCompletionHandler<Integer>(){

            public void ioComplete(final int errCode, final Integer value) {
                UpgradedSocketDelegate.this.runtime.enqueueTask(new ScriptTask(){

                    @Override
                    public void execute(Context cx, Scriptable scope) {
                        handler.ioComplete(errCode, (Object)value);
                    }
                });
            }
        });
    }

    public InetSocketAddress getSockName() {
        return this.localAddress;
    }

    public InetSocketAddress getPeerName() {
        return this.remoteAddress;
    }

    public void setNoDelay(boolean nd) throws OSException {
    }

    public void setKeepAlive(boolean nd) throws OSException {
    }

    public void bind(String address, int port) throws OSException {
        throw new OSException(-22);
    }

    public void listen(int backlog, IOCompletionHandler<AbstractHandle> handler) throws OSException {
        throw new OSException(-22);
    }

    public void connect(String host, int port, IOCompletionHandler<Integer> handler) throws OSException {
        throw new OSException(-22);
    }
}

