/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.net.internal;

import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.handles.AbstractHandle;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import io.apigee.trireme.kernel.handles.SocketHandle;
import io.apigee.trireme.net.spi.HttpRequestAdapter;
import io.apigee.trireme.net.spi.HttpResponseAdapter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class AdapterHandleDelegate
extends AbstractHandle
implements SocketHandle {
    private final HttpRequestAdapter req;
    private final HttpResponseAdapter resp;

    public AdapterHandleDelegate(HttpRequestAdapter req, HttpResponseAdapter resp) {
        this.req = req;
        this.resp = resp;
    }

    public void close() {
        this.resp.destroy();
    }

    public void shutdown(IOCompletionHandler<Integer> handler) {
    }

    public InetSocketAddress getSockName() {
        try {
            InetAddress addr = InetAddress.getByName(this.req.getLocalAddress());
            return new InetSocketAddress(addr, this.req.getLocalPort());
        }
        catch (UnknownHostException e) {
            return new InetSocketAddress(this.req.getLocalAddress(), this.req.getLocalPort());
        }
    }

    public InetSocketAddress getPeerName() {
        try {
            InetAddress addr = InetAddress.getByName(this.req.getRemoteAddress());
            return new InetSocketAddress(addr, this.req.getRemotePort());
        }
        catch (UnknownHostException e) {
            return new InetSocketAddress(this.req.getRemoteAddress(), this.req.getRemotePort());
        }
    }

    public void startReading(IOCompletionHandler<ByteBuffer> handler) {
    }

    public void stopReading() {
    }

    public void setNoDelay(boolean nd) throws OSException {
        throw new OSException(-22);
    }

    public void setKeepAlive(boolean nd) throws OSException {
        throw new OSException(-22);
    }

    public void bind(String address, int port) throws OSException {
        throw new OSException(-22);
    }

    public void listen(int backlog, IOCompletionHandler<AbstractHandle> handler) throws OSException {
        throw new OSException(-22);
    }

    public void connect(String host, int port, IOCompletionHandler<Integer> handler) throws OSException {
        throw new OSException(-22);
    }
}

