/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules.crypto;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.Crypto;
import io.apigee.trireme.kernel.crypto.CryptoException;
import io.apigee.trireme.kernel.crypto.CryptoService;
import io.apigee.trireme.kernel.crypto.SignatureAlgorithms;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;

public class VerifyImpl
extends ScriptableObject {
    private SignatureAlgorithms.Algorithm algorithm;
    private ArrayList<ByteBuffer> buffers = new ArrayList();

    public String getClassName() {
        return "Verify";
    }

    @JSFunction
    public static void init(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Crypto.ensureCryptoService(cx, thisObj);
        String algorithm = ArgUtils.stringArg(args, 0);
        VerifyImpl self = (VerifyImpl)thisObj;
        self.algorithm = SignatureAlgorithms.get().get(algorithm);
        if (self.algorithm == null) {
            self.algorithm = SignatureAlgorithms.get().getByJavaSigningName(algorithm);
        }
        if (self.algorithm == null) {
            throw Utils.makeError(cx, thisObj, "Invalid verify algorithm " + algorithm);
        }
    }

    @JSFunction
    public static void update(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ArgUtils.ensureArg(args, 0);
        String encoding = ArgUtils.stringArg(args, 1, null);
        ByteBuffer buf = Crypto.convertString(args[0], encoding, cx, thisObj);
        VerifyImpl self = (VerifyImpl)thisObj;
        self.buffers.add(buf);
    }

    @JSFunction
    public static boolean verify(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Buffer.BufferImpl certBuf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
        Buffer.BufferImpl sigBuf = ArgUtils.objArg(args, 1, Buffer.BufferImpl.class, true);
        VerifyImpl self = (VerifyImpl)thisObj;
        X509Certificate cert = null;
        PublicKey pubKey = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(certBuf.getArray(), certBuf.getArrayOffset(), certBuf.getLength());
        CryptoService crypto = Crypto.getCryptoService();
        try {
            try {
                pubKey = crypto.readPublicKey(self.algorithm.getKeyFormat(), (InputStream)bis);
            }
            catch (CryptoException cryptoException) {
                // empty catch block
            }
            if (pubKey == null) {
                bis.reset();
                try {
                    KeyPair pair = crypto.readKeyPair(self.algorithm.getKeyFormat(), (InputStream)bis, null);
                    pubKey = pair.getPublic();
                }
                catch (CryptoException pair) {
                    // empty catch block
                }
            }
            if (pubKey == null) {
                bis.reset();
                cert = crypto.readCertificate((InputStream)bis);
                if (cert == null) {
                    throw Utils.makeError(cx, thisObj, "no certificates available");
                }
            }
        }
        catch (IOException ioe) {
            throw Utils.makeError(cx, thisObj, "error reading key: " + ioe);
        }
        catch (CryptoException ce) {
            throw Utils.makeError(cx, thisObj, "invalid key: " + (Object)((Object)ce));
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
        try {
            Signature verifier = Signature.getInstance(self.algorithm.getSigningName());
            if (pubKey == null) {
                verifier.initVerify(cert);
            } else {
                verifier.initVerify(pubKey);
            }
            for (ByteBuffer bb : self.buffers) {
                verifier.update(bb);
            }
            return verifier.verify(sigBuf.getArray(), sigBuf.getArrayOffset(), sigBuf.getLength());
        }
        catch (GeneralSecurityException gse) {
            throw Utils.makeError(cx, thisObj, "error verifying: " + gse);
        }
    }
}

