/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTrustStore {
    private static final Logger log = LoggerFactory.getLogger((String)DefaultTrustStore.class.getName());
    private static final String DEFAULT_PASSWORD = "changeit";
    private static final DefaultTrustStore myself = new DefaultTrustStore();
    private TrustManager[] trustManagers;

    public static DefaultTrustStore get() {
        return myself;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    private DefaultTrustStore() {
        String password = this.getPassword();
        File trustStoreFile = null;
        if (System.getProperty("javax.net.ssl.trustStore") != null) {
            trustStoreFile = new File(System.getProperty("javax.net.ssl.trustStore"));
        } else {
            File javaSecurity = this.findJavaSecurity();
            if (!(javaSecurity == null || (trustStoreFile = new File(javaSecurity, "jssecacerts")).exists() && trustStoreFile.isFile())) {
                trustStoreFile = new File(javaSecurity, "cacerts");
            }
        }
        if (trustStoreFile == null || !trustStoreFile.exists() || !trustStoreFile.isFile()) {
            log.debug("Can't find cacerts or jssecacerts file -- giving up");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Looking for root CA certs in {}", (Object)trustStoreFile.getPath());
        }
        try {
            this.makeTrustStore(trustStoreFile, password);
        }
        catch (GeneralSecurityException e) {
            log.debug("Error loading default root CA certs: {}", (Object)e, (Object)e);
        }
        catch (IOException e) {
            log.debug("Error loading default root CA certs: {}", (Object)e, (Object)e);
        }
    }

    private String getPassword() {
        String pw = System.getProperty("javax.net.ssl.trustStorePassword");
        if (pw == null) {
            pw = DEFAULT_PASSWORD;
        }
        return pw;
    }

    private File findJavaSecurity() {
        String h = System.getProperty("java.home");
        if (h == null) {
            log.debug("java.home system property not defined -- giving up on CA search");
            return null;
        }
        File home = new File(h);
        File sec = new File(home, "lib/security");
        if (sec.exists() && sec.isDirectory()) {
            return sec;
        }
        sec = new File(home, "jre/lib/security");
        if (sec.exists() && sec.isDirectory()) {
            return sec;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeTrustStore(File storeFile, String pw) throws GeneralSecurityException, IOException {
        KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream in = new FileInputStream(storeFile);){
            store.load(in, pw.toCharArray());
        }
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(store);
        this.trustManagers = factory.getTrustManagers();
        if (log.isDebugEnabled()) {
            log.debug("Successfully created trust manager {}", (Object)this.trustManagers[0]);
        }
    }
}

