/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules.crypto;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.crypto.AbstractDH;
import io.apigee.trireme.kernel.crypto.DiffieHellmanGroups;
import java.math.BigInteger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;

public class DHGroupImpl
extends AbstractDH {
    public static final String CLASS_NAME = "DiffieHellmanGroup";

    public String getClassName() {
        return CLASS_NAME;
    }

    @JSConstructor
    public static Object construct(Context cx, Object[] args, Function ctor, boolean inNew) {
        if (!inNew) {
            return cx.newObject((Scriptable)ctor, CLASS_NAME);
        }
        DHGroupImpl self = new DHGroupImpl();
        String groupName = ArgUtils.stringArg(args, 0);
        BigInteger groupPrime = DiffieHellmanGroups.get().getGroup(groupName);
        if (groupPrime == null) {
            throw Utils.makeError(cx, (Scriptable)ctor, "Unknown Diffie-Hellman group " + groupName);
        }
        self.prime = groupPrime;
        return self;
    }

    @JSFunction
    public static Object generateKeys(Context cx, Scriptable thisObj, Object[] args, Function func) {
        DHGroupImpl self = (DHGroupImpl)thisObj;
        assert (self.prime != null);
        return self.generateKeys(cx);
    }

    @JSFunction
    public static Object computeSecret(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Buffer.BufferImpl keyBuf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
        DHGroupImpl self = (DHGroupImpl)thisObj;
        assert (self.prime != null);
        return self.computeSecret(cx, keyBuf);
    }

    @JSFunction
    public static Object getPrime(Context cx, Scriptable thisObj, Object[] args, Function func) {
        DHGroupImpl self = (DHGroupImpl)thisObj;
        if (self.prime == null) {
            return null;
        }
        return self.bufFromInt(self.prime, cx);
    }

    @JSFunction
    public static Object getGenerator(Context cx, Scriptable thisObj, Object[] args, Function func) {
        DHGroupImpl self = (DHGroupImpl)thisObj;
        return self.bufFromInt(DH_GENERATOR, cx);
    }

    @JSFunction
    public static Object getPublicKey(Context cx, Scriptable thisObj, Object[] args, Function func) {
        DHGroupImpl self = (DHGroupImpl)thisObj;
        if (self.pubKey == null) {
            return null;
        }
        return self.bufFromInt(self.pubKey.getY(), cx);
    }

    @JSFunction
    public static Object getPrivateKey(Context cx, Scriptable thisObj, Object[] args, Function func) {
        DHGroupImpl self = (DHGroupImpl)thisObj;
        if (self.privKey == null) {
            return null;
        }
        return self.bufFromInt(self.privKey.getX(), cx);
    }
}

