/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules.crypto;

import io.apigee.trireme.kernel.crypto.CryptoService;
import java.security.Provider;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoLoader {
    private static final Logger log = LoggerFactory.getLogger((String)CryptoLoader.class.getName());
    private CryptoService cryptoService;
    private Provider cryptoProvider;
    private static final CryptoLoader myself = new CryptoLoader();

    private CryptoLoader() {
        ServiceLoader<CryptoService> loc = ServiceLoader.load(CryptoService.class);
        if (loc.iterator().hasNext()) {
            if (log.isDebugEnabled()) {
                log.debug("Using crypto service implementation {}", (Object)this.cryptoService);
            }
            this.cryptoService = loc.iterator().next();
            this.cryptoProvider = this.cryptoService.getProvider();
        } else if (log.isDebugEnabled()) {
            log.debug("No crypto service available");
        }
    }

    public static CryptoLoader get() {
        return myself;
    }

    public CryptoService getCryptoService() {
        return this.cryptoService;
    }

    public Provider getCryptoProvider() {
        return this.cryptoProvider;
    }
}

