/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules.crypto;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.ScriptTask;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.CertificateParser;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.crypto.SecureContextImpl;
import io.apigee.trireme.kernel.BiCallback;
import io.apigee.trireme.kernel.Callback;
import io.apigee.trireme.kernel.GenericNodeRuntime;
import io.apigee.trireme.kernel.TriCallback;
import io.apigee.trireme.kernel.crypto.SSLCiphers;
import io.apigee.trireme.kernel.tls.TLSConnection;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionImpl
extends ScriptableObject {
    private static final Logger log = LoggerFactory.getLogger((String)ConnectionImpl.class.getName());
    private static final AtomicInteger lastId = new AtomicInteger();
    public static final String CLASS_NAME = "Connection";
    private final int id = lastId.incrementAndGet();
    private ScriptRunner runtime;
    SecureContextImpl context;
    private boolean requestCert;
    private boolean rejectUnauthorized;
    private Function onHandshakeStart;
    private Function onHandshakeDone;
    private Function onWrap;
    private Function onUnwrap;
    private Function onError;
    private TLSConnection processor;

    public ConnectionImpl() {
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    @JSConstructor
    public static Object construct(Context cx, Object[] args, Function ctor, boolean inNew) {
        if (!inNew) {
            return cx.newObject((Scriptable)ctor, CLASS_NAME, args);
        }
        SecureContextImpl ctxImpl = ArgUtils.objArg(args, 0, SecureContextImpl.class, true);
        boolean isServer = ArgUtils.booleanArg(args, 1);
        boolean requestCert = false;
        String serverName = null;
        if (isServer) {
            requestCert = ArgUtils.booleanArg(args, 2, false);
        } else {
            serverName = ArgUtils.stringArg(args, 2, null);
        }
        boolean rejectUnauthorized = ArgUtils.booleanArg(args, 3, false);
        int port = ArgUtils.intArg(args, 4, -1);
        ScriptRunner runtime = (ScriptRunner)cx.getThreadLocal((Object)"runner");
        ConnectionImpl conn = new ConnectionImpl(runtime, isServer, requestCert, rejectUnauthorized, serverName, port);
        conn.context = ctxImpl;
        if (log.isDebugEnabled()) {
            log.debug("Initializing Connection {}: isServer = {} requestCert = {} rejectUnauthorized = {}", new Object[]{conn.id, isServer, requestCert, rejectUnauthorized});
        }
        return conn;
    }

    private ConnectionImpl(ScriptRunner runtime, boolean serverMode, boolean requestCert, boolean rejectUnauth, String serverName, int port) {
        this.runtime = runtime;
        this.requestCert = requestCert;
        this.rejectUnauthorized = rejectUnauth;
        this.processor = new TLSConnection((GenericNodeRuntime)runtime, serverMode, serverName, port);
    }

    @JSFunction
    public static void init(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ConnectionImpl self = (ConnectionImpl)thisObj;
        SSLContext ctx = self.context.makeContext(cx, (Scriptable)self);
        self.processor.init(ctx, self.context.getCiphers(), self.context.getTrustManager());
        self.processor.setVerificationMode(self.requestCert, self.rejectUnauthorized);
    }

    @JSFunction
    public static int start(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ConnectionImpl self = (ConnectionImpl)thisObj;
        self.processor.start();
        return 0;
    }

    @JSSetter(value="onhandshakestart")
    public void setHandshakeStart(Function f) {
        this.onHandshakeStart = f;
        if (this.onHandshakeStart == null) {
            this.processor.setHandshakeStartCallback(null);
        } else {
            this.processor.setHandshakeStartCallback((Callback)new Callback<Void>(){

                public void call(Void val) {
                    ConnectionImpl.this.onHandshakeStart.call(Context.getCurrentContext(), (Scriptable)ConnectionImpl.this.onHandshakeStart, (Scriptable)ConnectionImpl.this, ScriptRuntime.emptyArgs);
                }
            });
        }
    }

    @JSGetter(value="onhandshakestart")
    public Function getHandshakeStart() {
        return this.onHandshakeStart;
    }

    @JSSetter(value="onhandshakedone")
    public void setHandshakeDone(Function f) {
        this.onHandshakeDone = f;
        if (this.onHandshakeDone == null) {
            this.processor.setHandshakeDoneCallback(null);
        } else {
            this.processor.setHandshakeDoneCallback((Callback)new Callback<Void>(){

                public void call(Void val) {
                    ConnectionImpl.this.onHandshakeDone.call(Context.getCurrentContext(), (Scriptable)ConnectionImpl.this.onHandshakeDone, (Scriptable)ConnectionImpl.this, ScriptRuntime.emptyArgs);
                }
            });
        }
    }

    @JSGetter(value="onhandshakedone")
    public Function getHandshakeDone() {
        return this.onHandshakeDone;
    }

    @JSSetter(value="onwrap")
    public void setOnWrap(Function f) {
        this.onWrap = f;
        if (f == null) {
            this.processor.setWriteCallback(null);
        } else {
            this.processor.setWriteCallback((TriCallback)new TriCallback<ByteBuffer, Boolean, Object>(){

                public void call(final ByteBuffer bb, final Boolean shutdown, final Object arg) {
                    ConnectionImpl.this.runtime.enqueueTask(new ScriptTask(){

                        @Override
                        public void execute(Context cx, Scriptable scope) {
                            ConnectionImpl self = ConnectionImpl.this;
                            Buffer.BufferImpl buf = bb == null ? null : Buffer.BufferImpl.newBuffer(cx, (Scriptable)self, bb, false);
                            Function cb = arg == null ? null : ((CallbackHolder)arg).getCallback();
                            ConnectionImpl.this.onWrap.call(cx, (Scriptable)ConnectionImpl.this.onWrap, (Scriptable)self, new Object[]{buf, shutdown, cb});
                        }
                    });
                }
            });
        }
    }

    @JSGetter(value="onwrap")
    public Function getOnWrap() {
        return this.onWrap;
    }

    @JSSetter(value="onunwrap")
    public void setOnUnwrap(Function f) {
        this.onUnwrap = f;
        if (f == null) {
            this.processor.setReadCallback(null);
        } else {
            this.processor.setReadCallback((BiCallback)new BiCallback<ByteBuffer, Integer>(){

                public void call(final ByteBuffer bb, final Integer err) {
                    ConnectionImpl.this.runtime.enqueueTask(new ScriptTask(){

                        @Override
                        public void execute(Context cx, Scriptable scope) {
                            ConnectionImpl self = ConnectionImpl.this;
                            Buffer.BufferImpl buf = bb == null ? null : Buffer.BufferImpl.newBuffer(cx, (Scriptable)self, bb, false);
                            ConnectionImpl.this.onUnwrap.call(cx, (Scriptable)ConnectionImpl.this.onUnwrap, (Scriptable)self, new Object[]{buf, err == -99});
                        }
                    });
                }
            });
        }
    }

    @JSGetter(value="onunwrap")
    public Function getOnUnwrap() {
        return this.onUnwrap;
    }

    @JSSetter(value="onerror")
    public void setOnError(Function f) {
        this.onError = f;
        if (this.onError == null) {
            this.processor.setErrorCallback(null);
        } else {
            this.processor.setErrorCallback((Callback)new Callback<Throwable>(){

                public void call(Throwable e) {
                    Scriptable err = Utils.makeErrorObject(Context.getCurrentContext(), (Scriptable)ConnectionImpl.this, e.toString());
                    ConnectionImpl.this.onError.call(Context.getCurrentContext(), (Scriptable)ConnectionImpl.this.onError, (Scriptable)ConnectionImpl.this, new Object[]{err});
                }
            });
        }
    }

    @JSGetter(value="onerror")
    public Function getOnError() {
        return this.onError;
    }

    @JSGetter(value="error")
    public Object getError() {
        SSLException err = this.processor.getError();
        if (err == null) {
            return Undefined.instance;
        }
        return Utils.makeErrorObject(Context.getCurrentContext(), (Scriptable)this, err.toString());
    }

    @JSGetter(value="sentShutdown")
    public boolean isSentShutdown() {
        return this.processor.isSentShutdown();
    }

    @JSGetter(value="receivedShutdown")
    public boolean isReceivedShutdown() {
        return this.processor.isReceivedShutdown();
    }

    @JSFunction
    public static void close(Context cx, Scriptable thisObj, Object[] args, Function func) {
    }

    @JSFunction
    public static void wrap(final Context cx, Scriptable thisObj, Object[] args, Function func) {
        Buffer.BufferImpl buf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
        final Function cb = ArgUtils.functionArg(args, 1, true);
        final ConnectionImpl self = (ConnectionImpl)thisObj;
        ByteBuffer bb = buf.getBuffer();
        self.processor.wrap(bb, (Callback)new CallbackHolder(cb){

            public void call(Object val) {
                cb.call(cx, (Scriptable)cb, (Scriptable)self, new Object[]{val});
            }
        });
    }

    @JSFunction
    public static void shutdown(final Context cx, Scriptable thisObj, Object[] args, Function func) {
        final Function cb = ArgUtils.functionArg(args, 0, false);
        final ConnectionImpl self = (ConnectionImpl)thisObj;
        self.processor.shutdown((Callback)new CallbackHolder(cb){

            public void call(Object val) {
                if (cb != null) {
                    cb.call(cx, (Scriptable)cb, (Scriptable)self, new Object[]{val});
                }
            }
        });
    }

    @JSFunction
    public static void shutdownInbound(final Context cx, Scriptable thisObj, Object[] args, Function func) {
        final Function cb = ArgUtils.functionArg(args, 0, false);
        final ConnectionImpl self = (ConnectionImpl)thisObj;
        self.processor.shutdownInbound((Callback)new Callback<Object>(){

            public void call(Object val) {
                if (cb != null) {
                    cb.call(cx, (Scriptable)cb, (Scriptable)self, ScriptRuntime.emptyArgs);
                }
            }
        });
    }

    @JSFunction
    public static void unwrap(final Context cx, Scriptable thisObj, Object[] args, Function func) {
        Buffer.BufferImpl buf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
        final Function cb = ArgUtils.functionArg(args, 1, true);
        final ConnectionImpl self = (ConnectionImpl)thisObj;
        ByteBuffer bb = buf.getBuffer();
        self.processor.unwrap(bb, (Callback)new Callback<Object>(){

            public void call(Object val) {
                cb.call(cx, (Scriptable)cb, (Scriptable)self, new Object[]{val});
            }
        });
    }

    @JSFunction
    public static Object getPeerCertificate(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ConnectionImpl self = (ConnectionImpl)thisObj;
        X509Certificate cert = self.processor.getPeerCertificate();
        if (cert == null) {
            return Undefined.instance;
        }
        return CertificateParser.get().parse(cx, (Scriptable)self, cert);
    }

    @JSFunction
    public static Object getSession(Context cx, Scriptable thisObj, Object[] args, Function func) {
        return Undefined.instance;
    }

    @JSFunction
    public static void setSession(Context cx, Scriptable thisObj, Object[] args, Function func) {
    }

    @JSFunction
    public static void loadSession(Context cx, Scriptable thisObj, Object[] args, Function func) {
    }

    @JSFunction
    public static boolean isSessionReused(Context cx, Scriptable thisObj, Object[] args, Function func) {
        return false;
    }

    @JSFunction
    public static boolean isInitFinished(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ConnectionImpl self = (ConnectionImpl)thisObj;
        return self.processor.isInitFinished();
    }

    @JSFunction
    public static Object verifyError(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ConnectionImpl self = (ConnectionImpl)thisObj;
        SSLException ve = self.processor.getVerifyError();
        if (ve == null) {
            return Undefined.instance;
        }
        return Utils.makeErrorObject(cx, (Scriptable)self, ve.toString());
    }

    @JSFunction
    public static Object getCurrentCipher(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ConnectionImpl self = (ConnectionImpl)thisObj;
        String cipherSuite = self.processor.getCipherSuite();
        if (cipherSuite == null) {
            return Undefined.instance;
        }
        SSLCiphers.Ciph cipher = SSLCiphers.get().getJavaCipher(cipherSuite);
        Scriptable c = cx.newObject((Scriptable)self);
        c.put("name", c, (Object)(cipher == null ? "unknown" : cipher.getSslName()));
        c.put("version", c, (Object)self.processor.getProtocol());
        c.put("javaCipher", c, (Object)cipherSuite);
        return c;
    }

    private static abstract class CallbackHolder
    implements Callback<Object> {
        private final Function callback;

        protected CallbackHolder(Function callback) {
            this.callback = callback;
        }

        public Function getCallback() {
            return this.callback;
        }
    }
}

