/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules.crypto;

import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.Crypto;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameterGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class AbstractDH
extends ScriptableObject {
    protected static final BigInteger DH_GENERATOR = new BigInteger("2");
    protected BigInteger prime;
    protected DHPrivateKey privKey;
    protected DHPublicKey pubKey;

    protected BigInteger intFromBuf(Buffer.BufferImpl buf, Context cx) {
        byte[] bytes;
        ByteBuffer bb = buf.getBuffer();
        if (bb.hasArray() && bb.arrayOffset() == 0 && bb.position() == 0 && bb.array().length == bb.remaining()) {
            bytes = bb.array();
        } else {
            bytes = new byte[bb.remaining()];
            bb.get(bytes);
        }
        try {
            return new BigInteger(bytes);
        }
        catch (NumberFormatException nfe) {
            throw Utils.makeError(cx, (Scriptable)this, "Invalid key");
        }
    }

    protected Buffer.BufferImpl bufFromInt(BigInteger i, Context cx) {
        byte[] bytes = i.toByteArray();
        return Buffer.BufferImpl.newBuffer(cx, (Scriptable)this, bytes);
    }

    protected Object generateKeys(Context cx) {
        DHParameterSpec params = new DHParameterSpec(this.prime, DH_GENERATOR);
        try {
            KeyPairGenerator gen = this.getKeyPairGen();
            gen.initialize(params);
            KeyPair kp = gen.generateKeyPair();
            this.privKey = (DHPrivateKey)kp.getPrivate();
            this.pubKey = (DHPublicKey)kp.getPublic();
            return this.bufFromInt(this.pubKey.getY(), cx);
        }
        catch (NoSuchAlgorithmException nse) {
            throw new AssertionError((Object)nse);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw Utils.makeError(cx, (Scriptable)this, e.toString());
        }
    }

    protected Object computeSecret(Context cx, Buffer.BufferImpl keyBuf) {
        if (this.pubKey == null) {
            throw Utils.makeError(cx, (Scriptable)this, "Private key not set");
        }
        BigInteger y = this.intFromBuf(keyBuf, cx);
        DHPublicKeySpec spec = new DHPublicKeySpec(y, this.prime, DH_GENERATOR);
        try {
            KeyFactory kf = this.getKeyFactory();
            PublicKey key = kf.generatePublic(spec);
            KeyAgreement agree = this.getKeyAgreement();
            agree.init(this.privKey);
            agree.doPhase(key, true);
            byte[] secret = agree.generateSecret();
            return Buffer.BufferImpl.newBuffer(cx, (Scriptable)this, secret);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvalidKeyException e) {
            throw Utils.makeError(cx, (Scriptable)this, e.toString());
        }
        catch (InvalidKeySpecException e) {
            throw Utils.makeError(cx, (Scriptable)this, e.toString());
        }
    }

    protected KeyPairGenerator getKeyPairGen() throws NoSuchAlgorithmException {
        if (Crypto.getCryptoProvider() == null) {
            return KeyPairGenerator.getInstance("DiffieHellman");
        }
        return KeyPairGenerator.getInstance("DiffieHellman", Crypto.getCryptoProvider());
    }

    protected AlgorithmParameterGenerator getParamGen() throws NoSuchAlgorithmException {
        if (Crypto.getCryptoProvider() == null) {
            return AlgorithmParameterGenerator.getInstance("DiffieHellman");
        }
        return AlgorithmParameterGenerator.getInstance("DiffieHellman", Crypto.getCryptoProvider());
    }

    protected KeyFactory getKeyFactory() throws NoSuchAlgorithmException {
        if (Crypto.getCryptoProvider() == null) {
            return KeyFactory.getInstance("DiffieHellman");
        }
        return KeyFactory.getInstance("DiffieHellman", Crypto.getCryptoProvider());
    }

    protected KeyAgreement getKeyAgreement() throws NoSuchAlgorithmException {
        if (Crypto.getCryptoProvider() == null) {
            return KeyAgreement.getInstance("DiffieHellman");
        }
        return KeyAgreement.getInstance("DiffieHellman", Crypto.getCryptoProvider());
    }
}

