/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.ScriptTask;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.Referenceable;
import io.apigee.trireme.kernel.ErrorCodes;
import io.apigee.trireme.kernel.GenericNodeRuntime;
import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import io.apigee.trireme.kernel.handles.NIODatagramHandle;
import io.apigee.trireme.net.NetUtils;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPWrap
implements InternalNodeModule {
    protected static final Logger log = LoggerFactory.getLogger(UDPWrap.class);

    @Override
    public String getModuleName() {
        return "udp_wrap";
    }

    @Override
    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runtime) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject exports = (ScriptableObject)cx.newObject(scope);
        exports.setPrototype(scope);
        exports.setParentScope(null);
        ScriptableObject.defineClass((Scriptable)exports, Referenceable.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)exports, UDPImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)exports, QueuedWrite.class);
        return exports;
    }

    public static class QueuedWrite
    extends ScriptableObject {
        public static final String CLASS_NAME = "_writeWrap";
        Function onComplete;
        Object domain;
        Buffer.BufferImpl buf;

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSSetter(value="oncomplete")
        public void setOnComplete(Function c) {
            this.onComplete = c;
        }

        @JSGetter(value="oncomplete")
        public Function getOnComplete() {
            return this.onComplete;
        }
    }

    public static class UDPImpl
    extends Referenceable {
        public static final String CLASS_NAME = "UDP";
        private Function onMessage;
        private ScriptRunner runner;
        private NIODatagramHandle handle;

        @JSConstructor
        public static Object newUDPImpl(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
            UDPImpl udp = new UDPImpl();
            udp.runner = UDPImpl.getRunner(cx);
            return udp;
        }

        @Override
        public String getClassName() {
            return CLASS_NAME;
        }

        @JSSetter(value="onmessage")
        public void setOnMessage(Function onmessage) {
            this.onMessage = onmessage;
        }

        @JSGetter(value="onmessage")
        public Object getOnMessage() {
            return this.onMessage;
        }

        @JSFunction
        public static int bind(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String address = ArgUtils.stringArg(args, 0);
            int port = ArgUtils.intArg(args, 1);
            int options = ArgUtils.intArg(args, 2);
            UDPImpl self = (UDPImpl)thisObj;
            self.handle = new NIODatagramHandle((GenericNodeRuntime)self.runner);
            try {
                self.handle.bind(address, port);
                UDPImpl.clearErrno();
                return 0;
            }
            catch (OSException nse) {
                UDPImpl.setErrno(nse.getCode());
                return -1;
            }
        }

        @JSFunction
        public static int bind6(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return UDPImpl.bind(cx, thisObj, args, func);
        }

        @Override
        @JSFunction
        public void close() {
            super.close();
            if (this.handle != null) {
                this.handle.close();
            }
        }

        @JSFunction
        public static Object send(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ArgUtils.ensureArg(args, 0);
            final Buffer.BufferImpl buf = (Buffer.BufferImpl)((Object)args[0]);
            int offset = ArgUtils.intArg(args, 1);
            int length = ArgUtils.intArg(args, 2);
            int port = ArgUtils.intArg(args, 3);
            String host = ArgUtils.stringArg(args, 4);
            final UDPImpl self = (UDPImpl)thisObj;
            UDPImpl.clearErrno();
            final QueuedWrite qw = (QueuedWrite)cx.newObject(thisObj, "_writeWrap");
            qw.buf = buf;
            qw.domain = self.runner.getDomain();
            ByteBuffer bbuf = buf.getBuffer();
            try {
                self.handle.send(host, port, bbuf, (IOCompletionHandler)new IOCompletionHandler<Integer>(){

                    public void ioComplete(int errCode, Integer value) {
                        self.writeComplete(errCode, qw);
                    }
                });
            }
            catch (OSException nse) {
                self.runner.enqueueTask(new ScriptTask(){

                    @Override
                    public void execute(Context cx, Scriptable scope) {
                        if (qw.onComplete != null) {
                            qw.onComplete.call(cx, scope, null, new Object[]{ErrorCodes.get().toString(nse.getCode()), self, qw, buf});
                        }
                    }
                });
            }
            return qw;
        }

        @JSFunction
        public static Object send6(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return UDPImpl.send(cx, thisObj, args, func);
        }

        protected void writeComplete(final int err, final QueuedWrite qw) {
            this.runner.enqueueTask(new ScriptTask(){

                @Override
                public void execute(Context cx, Scriptable scope) {
                    if (qw.onComplete != null) {
                        if (err == 0) {
                            qw.onComplete.call(cx, (Scriptable)qw.onComplete, (Scriptable)UDPImpl.this, new Object[]{0, UDPImpl.this, qw, qw.buf});
                        } else {
                            qw.onComplete.call(cx, (Scriptable)qw.onComplete, (Scriptable)UDPImpl.this, new Object[]{ErrorCodes.get().toString(err), UDPImpl.this, qw, qw.buf});
                        }
                    }
                }
            });
        }

        @JSFunction
        public void recvStart() {
            UDPImpl.clearErrno();
            if (this.handle != null) {
                this.handle.startReadingDatagrams((IOCompletionHandler)new IOCompletionHandler<NIODatagramHandle.ReceivedDatagram>(){

                    public void ioComplete(int errCode, NIODatagramHandle.ReceivedDatagram value) {
                        UDPImpl.this.readComplete(errCode, value.getBuffer(), value.getAddress());
                    }
                });
            }
            this.requestPin();
        }

        @JSFunction
        public void recvStop() {
            this.clearPin();
            UDPImpl.clearErrno();
            if (this.handle != null) {
                this.handle.stopReading();
            }
        }

        protected void readComplete(int err, ByteBuffer bbuf, SocketAddress addr) {
            Context cx = Context.getCurrentContext();
            if (err == 0) {
                if (this.onMessage != null) {
                    Buffer.BufferImpl buf = Buffer.BufferImpl.newBuffer(cx, (Scriptable)this, bbuf, false);
                    Scriptable rinfo = cx.newObject((Scriptable)this);
                    if (addr instanceof InetSocketAddress) {
                        InetSocketAddress iAddr = (InetSocketAddress)addr;
                        rinfo.put("port", rinfo, (Object)iAddr.getPort());
                        rinfo.put("address", rinfo, (Object)iAddr.getAddress().getHostAddress());
                    }
                    this.onMessage.call(cx, (Scriptable)this.onMessage, (Scriptable)this, new Object[]{this, buf, 0, buf.getLength(), rinfo});
                }
            } else if (this.onMessage != null) {
                this.onMessage.call(cx, (Scriptable)this.onMessage, (Scriptable)this, new Object[]{this, null, "EIO", 0});
            }
        }

        @JSFunction
        public static Object getsockname(Context cx, Scriptable thisObj, Object[] args, Function func) {
            UDPImpl self = (UDPImpl)thisObj;
            UDPImpl.clearErrno();
            InetSocketAddress addr = self.handle.getSockName();
            if (addr == null) {
                return null;
            }
            return NetUtils.formatAddress(addr.getAddress(), addr.getPort(), cx, thisObj);
        }

        @JSFunction
        public static int addMembership(Context cx, Scriptable thisObj, Object[] args, Function func) {
            UDPImpl.setErrno("EINVAL");
            return -1;
        }

        @JSFunction
        public static int dropMembership(Context cx, Scriptable thisObj, Object[] args, Function func) {
            UDPImpl.setErrno("EINVAL");
            return -1;
        }

        @JSFunction
        public static int setMulticastTTL(Context cx, Scriptable thisObj, Object[] args, Function func) {
            int ttl = ArgUtils.intArg(args, 0);
            UDPImpl self = (UDPImpl)thisObj;
            try {
                self.handle.setMulticastTtl(ttl);
                UDPImpl.clearErrno();
                return 0;
            }
            catch (OSException nse) {
                UDPImpl.setErrno(nse.getCode());
                return -1;
            }
        }

        @JSFunction
        public static int setMulticastLoopback(Context cx, Scriptable thisObj, Object[] args, Function func) {
            int loop = ArgUtils.intArg(args, 0);
            UDPImpl self = (UDPImpl)thisObj;
            try {
                self.handle.setMulticastLoopback(loop != 0);
                UDPImpl.clearErrno();
                return 0;
            }
            catch (OSException nse) {
                UDPImpl.setErrno(nse.getCode());
                return -1;
            }
        }

        @JSFunction
        public static int setBroadcast(Context cx, Scriptable thisObj, Object[] args, Function func) {
            int broadcastOn = ArgUtils.intArg(args, 0);
            UDPImpl self = (UDPImpl)thisObj;
            try {
                self.handle.setBroadcast(broadcastOn != 0);
                UDPImpl.clearErrno();
                return 0;
            }
            catch (OSException nse) {
                UDPImpl.setErrno(nse.getCode());
                return -1;
            }
        }

        @JSFunction
        public static int setTTL(Context cx, Scriptable thisObj, Object[] args, Function func) {
            UDPImpl.setErrno("EINVAL");
            return -1;
        }
    }
}

