/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.ScriptRunner;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;

public class OS
implements InternalNodeModule {
    @Override
    public String getModuleName() {
        return "os";
    }

    @Override
    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)scope, OSImpl.class);
        OSImpl exports = (OSImpl)cx.newObject(scope, "_osClass");
        return exports;
    }

    public static class OSImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_osClass";
        public static final String HIDDEN_OS_NAME = "Trireme";
        public static final String HIDDEN_OS_RELEASE = "Trireme";

        public String getClassName() {
            return CLASS_NAME;
        }

        protected static ScriptRunner getRunner(Context cx) {
            return (ScriptRunner)cx.getThreadLocal((Object)"runner");
        }

        @JSFunction
        public static Object getHostname(Context cx, Scriptable thisObj, Object[] args, Function func) {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw Utils.makeError(cx, thisObj, "Could not get hostname for localhost");
            }
        }

        @JSFunction
        public static Object getLoadAvg(Context cx, Scriptable thisObj, Object[] args, Function func) {
            double loadAvg = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
            Scriptable loadAvgArray = cx.newArray(thisObj, 3);
            loadAvgArray.put(0, loadAvgArray, (Object)loadAvg);
            loadAvgArray.put(1, loadAvgArray, (Object)0);
            loadAvgArray.put(2, loadAvgArray, (Object)0);
            return loadAvgArray;
        }

        @JSFunction
        public static Object getUptime(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return Math.max(ManagementFactory.getRuntimeMXBean().getUptime() / 1000L, 1L);
        }

        @JSFunction
        public static Object getFreeMem(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return Runtime.getRuntime().freeMemory() / 0x100000L;
        }

        @JSFunction
        public static Object getTotalMem(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return Runtime.getRuntime().totalMemory() / 0x100000L;
        }

        @JSFunction
        public static Object getCPUs(Context cx, Scriptable thisObj, Object[] args, Function func) {
            int numProcessors = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
            ScriptRunner runner = OSImpl.getRunner(cx);
            if (runner.getSandbox() != null && runner.getSandbox().isHideOSDetails()) {
                numProcessors = 1;
            }
            Object[] cpuObjects = new Object[numProcessors];
            for (int i = 0; i < numProcessors; ++i) {
                Scriptable cpuObject = cx.newObject(thisObj);
                cpuObject.put("model", cpuObject, (Object)"Java CPU");
                cpuObject.put("speed", cpuObject, (Object)-1);
                Scriptable cpuTimesObject = cx.newObject(thisObj);
                cpuTimesObject.put("user", cpuTimesObject, (Object)-1);
                cpuTimesObject.put("nice", cpuTimesObject, (Object)-1);
                cpuTimesObject.put("sys", cpuTimesObject, (Object)-1);
                cpuTimesObject.put("idle", cpuTimesObject, (Object)-1);
                cpuTimesObject.put("irq", cpuTimesObject, (Object)-1);
                cpuObject.put("times", cpuObject, (Object)cpuTimesObject);
                cpuObjects[i] = cpuObject;
            }
            return cx.newArray(thisObj, cpuObjects);
        }

        @JSFunction
        public static Object getOSType(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ScriptRunner runner = OSImpl.getRunner(cx);
            if (runner.getSandbox() != null && runner.getSandbox().isHideOSDetails()) {
                return "Trireme";
            }
            String name = System.getProperty("os.name");
            if (name.equals("Mac OS X")) {
                return "Darwin";
            }
            if (name.startsWith("Windows")) {
                return "Windows_NT";
            }
            return name;
        }

        @JSFunction
        public static Object getOSRelease(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ScriptRunner runner = OSImpl.getRunner(cx);
            if (runner.getSandbox() != null && runner.getSandbox().isHideOSDetails()) {
                return "Trireme";
            }
            return System.getProperty("os.version");
        }

        @JSFunction
        public static Object getInterfaceAddresses(Context cx, Scriptable thisObj, Object[] args, Function func) throws SocketException {
            Scriptable obj = cx.newObject(thisObj);
            ScriptRunner runner = OSImpl.getRunner(cx);
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netIf : Collections.list(nets)) {
                if (runner.getSandbox() != null && runner.getSandbox().isHideOSDetails() && !netIf.isLoopback()) continue;
                List<InterfaceAddress> ifAddresses = netIf.getInterfaceAddresses();
                Scriptable ifAddressesArray = cx.newArray(thisObj, ifAddresses.size());
                int i = 0;
                for (InterfaceAddress ifAddress : ifAddresses) {
                    InetAddress inetAddress = ifAddress.getAddress();
                    String family = inetAddress instanceof Inet4Address ? "IPv4" : (inetAddress instanceof Inet6Address ? "IPv6" : "<unknown>");
                    Scriptable ifAddressObject = cx.newObject(thisObj);
                    ifAddressObject.put("address", ifAddressObject, (Object)inetAddress.getHostAddress());
                    ifAddressObject.put("family", ifAddressObject, (Object)family);
                    ifAddressObject.put("internal", ifAddressObject, (Object)(netIf.isLoopback() || inetAddress.isLoopbackAddress() ? 1 : 0));
                    ifAddressesArray.put(i, ifAddressesArray, (Object)ifAddressObject);
                    ++i;
                }
                obj.put(netIf.getName(), obj, (Object)ifAddressesArray);
            }
            return obj;
        }

        @JSFunction
        public static Object getEndianness(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return "BE";
        }
    }
}

