/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.ClassCache;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.internal.ScriptUtils;
import io.apigee.trireme.kernel.Charsets;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSStaticFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Evals
implements InternalNodeModule {
    protected static final Logger log = LoggerFactory.getLogger(Evals.class);
    public static final String CACHE_KEY_HASH = "SHA-256";
    private static final Object CODE_KEY = "_compiledCode";
    private static final Object FILE_NAME_KEY = "_codeFileName";
    private static final Object SOURCE_KEY = "_sourceCode";

    @Override
    public String getModuleName() {
        return "evals";
    }

    @Override
    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Scriptable export = cx.newObject(scope);
        export.setPrototype(scope);
        export.setParentScope(null);
        ScriptableObject.defineClass((Scriptable)export, NodeScriptImpl.class);
        return export;
    }

    public static class NodeScriptImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "NodeScript";

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSStaticFunction
        public static Object runInThisContext(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String code = ArgUtils.stringArg(args, 0);
            String fileName = ArgUtils.stringArg(args, 1);
            if (log.isDebugEnabled()) {
                log.debug("Running code from {} in this context of {}", (Object)fileName, (Object)thisObj);
            }
            return NodeScriptImpl.runScript(cx, thisObj, code, fileName);
        }

        @JSStaticFunction
        public static Object runInNewContext(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String code = ArgUtils.stringArg(args, 0);
            Scriptable sandbox = ArgUtils.objArg(args, 1, Scriptable.class, true);
            String fileName = ArgUtils.stringArg(args, 2);
            if (log.isDebugEnabled()) {
                log.debug("Running code from {} in new context of {}", (Object)fileName, (Object)sandbox);
            }
            return NodeScriptImpl.runScript(cx, sandbox, code, fileName);
        }

        @JSStaticFunction
        public static Object compile(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String code = ArgUtils.stringArg(args, 0);
            String fileName = ArgUtils.stringArg(args, 1);
            if (log.isDebugEnabled()) {
                log.debug("Compiling code from {}", (Object)fileName);
            }
            ScriptableObject ret = (ScriptableObject)cx.newObject(thisObj);
            ret.associateValue(FILE_NAME_KEY, (Object)fileName);
            Script compiled = NodeScriptImpl.getCompiledScript(cx, code, fileName);
            if (compiled == null) {
                ret.associateValue(SOURCE_KEY, (Object)code);
            } else {
                ret.associateValue(CODE_KEY, (Object)compiled);
            }
            return ret;
        }

        @JSStaticFunction
        public static Object run(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ScriptableObject compiled;
            Scriptable context = ArgUtils.objArg(args, 0, Scriptable.class, true);
            Object comp = ArgUtils.objArg(args, 1, Object.class, true);
            try {
                compiled = (ScriptableObject)comp;
            }
            catch (ClassCastException cce) {
                throw Utils.makeTypeError(cx, thisObj, "Compiled script expected");
            }
            String fileName = (String)compiled.getAssociatedValue(FILE_NAME_KEY);
            if (fileName == null) {
                throw Utils.makeTypeError(cx, thisObj, "Invalid compiled script argument");
            }
            Script compiledScript = (Script)compiled.getAssociatedValue(CODE_KEY);
            if (compiledScript == null) {
                String scriptSource = (String)compiled.getAssociatedValue(SOURCE_KEY);
                if (scriptSource == null) {
                    throw Utils.makeTypeError(cx, thisObj, "Invalid compiled script argument");
                }
                return ScriptUtils.interpretScript(cx, context, scriptSource, fileName);
            }
            return compiledScript.exec(cx, context);
        }

        @JSStaticFunction
        public static Object createContext(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ScriptRunner runner = (ScriptRunner)cx.getThreadLocal((Object)"runner");
            Scriptable ctx = cx.newObject(runner.getScriptScope());
            ctx.setPrototype(NodeScriptImpl.getTopLevelScope((Scriptable)runner.getScriptScope()));
            ctx.setParentScope(null);
            return ctx;
        }

        @JSStaticFunction
        public static Object getGlobalContext(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ScriptRunner runner = (ScriptRunner)cx.getThreadLocal((Object)"runner");
            return runner.getScriptScope();
        }

        private static Object runScript(Context cx, Scriptable scope, String code, String fileName) {
            Script compiled = NodeScriptImpl.getCompiledScript(cx, code, fileName);
            if (compiled == null) {
                return ScriptUtils.interpretScript(cx, scope, code, fileName);
            }
            return compiled.exec(cx, scope);
        }

        private static Script getCompiledScript(Context cx, String code, String fileName) {
            ScriptRunner runner = (ScriptRunner)cx.getThreadLocal((Object)"runner");
            ClassCache cache = runner.getEnvironment().getClassCache();
            if (cache == null) {
                return ScriptUtils.tryCompile(cx, code, fileName);
            }
            String cacheKey = NodeScriptImpl.makeCacheKey(code);
            Script compiled = cache.getCachedScript(cacheKey);
            if (compiled == null && (compiled = ScriptUtils.tryCompile(cx, code, fileName)) != null) {
                cache.putCachedScript(cacheKey, compiled);
            }
            return compiled;
        }

        private static String makeCacheKey(String code) {
            try {
                MessageDigest md = MessageDigest.getInstance(Evals.CACHE_KEY_HASH);
                ByteBuffer codeBuf = Utils.stringToBuffer(code, Charsets.UTF8);
                md.update(codeBuf);
                ByteBuffer keyBuf = ByteBuffer.wrap(md.digest());
                return Utils.bufferToString(keyBuf, Charsets.BASE64);
            }
            catch (NoSuchAlgorithmException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Can't calculate cache key for source code: " + e);
                }
                return null;
            }
        }
    }
}

