/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.crypto.CipherImpl;
import io.apigee.trireme.core.modules.crypto.ConnectionImpl;
import io.apigee.trireme.core.modules.crypto.CryptoLoader;
import io.apigee.trireme.core.modules.crypto.DHGroupImpl;
import io.apigee.trireme.core.modules.crypto.DHImpl;
import io.apigee.trireme.core.modules.crypto.DecipherImpl;
import io.apigee.trireme.core.modules.crypto.HashImpl;
import io.apigee.trireme.core.modules.crypto.MacImpl;
import io.apigee.trireme.core.modules.crypto.SecureContextImpl;
import io.apigee.trireme.core.modules.crypto.SignImpl;
import io.apigee.trireme.core.modules.crypto.VerifyImpl;
import io.apigee.trireme.kernel.Charsets;
import io.apigee.trireme.kernel.crypto.CryptoAlgorithms;
import io.apigee.trireme.kernel.crypto.CryptoService;
import io.apigee.trireme.kernel.crypto.SSLCiphers;
import io.apigee.trireme.kernel.crypto.SignatureAlgorithms;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crypto
implements InternalNodeModule {
    private static final Logger log = LoggerFactory.getLogger(Crypto.class);
    public static final String MODULE_NAME = "crypto";
    public static final long MAX_BUFFER_LEN = 0x3FFFFFFFL;

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runtime) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)scope, CryptoImpl.class);
        CryptoImpl export = (CryptoImpl)cx.newObject(scope, "_cryptoClass");
        export.setRuntime(runtime);
        ScriptableObject proto = (ScriptableObject)export.getPrototype();
        FunctionObject randomBytes = (FunctionObject)proto.get("randomBytes", (Scriptable)proto);
        randomBytes.setParentScope((Scriptable)export);
        FunctionObject pseudoRandomBytes = (FunctionObject)proto.get("pseudoRandomBytes", (Scriptable)proto);
        pseudoRandomBytes.setParentScope((Scriptable)export);
        ScriptableObject.defineClass((Scriptable)export, HashImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)export, MacImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)export, CipherImpl.class);
        ScriptableObject.defineClass((Scriptable)export, DecipherImpl.class);
        ScriptableObject.defineClass((Scriptable)export, SignImpl.class);
        ScriptableObject.defineClass((Scriptable)export, VerifyImpl.class);
        ScriptableObject.defineClass((Scriptable)export, SecureContextImpl.class);
        ScriptableObject.defineClass((Scriptable)export, DHImpl.class);
        ScriptableObject.defineClass((Scriptable)export, DHGroupImpl.class);
        ScriptableObject.defineClass((Scriptable)export, ConnectionImpl.class);
        CryptoLoader.get();
        return export;
    }

    public static ByteBuffer convertString(Object o, String encoding, Context cx, Scriptable scope) {
        if (o instanceof String) {
            Charset cs = Charsets.get().resolveCharset(encoding);
            return Utils.stringToBuffer((String)o, cs);
        }
        if (o instanceof Buffer.BufferImpl) {
            return ((Buffer.BufferImpl)((Object)o)).getBuffer();
        }
        throw Utils.makeError(cx, scope, "argument must be a String or Buffer");
    }

    public static void ensureCryptoService(Context cx, Scriptable scope) {
        if (CryptoLoader.get().getCryptoService() == null) {
            throw Utils.makeError(cx, scope, "Crypto service not available");
        }
    }

    public static CryptoService getCryptoService() {
        return CryptoLoader.get().getCryptoService();
    }

    public static Provider getCryptoProvider() {
        return CryptoLoader.get().getCryptoProvider();
    }

    public static class CryptoImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_cryptoClass";
        private static final SecureRandom secureRandom = new SecureRandom();
        private static final Random pseudoRandom = new Random();
        private NodeRuntime runtime;

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSFunction
        public static Object randomBytes(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return CryptoImpl.randomBytesCommon(cx, thisObj, args, func, secureRandom);
        }

        @JSFunction
        public static Object pseudoRandomBytes(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return CryptoImpl.randomBytesCommon(cx, thisObj, args, func, pseudoRandom);
        }

        private static Object randomBytesCommon(Context cx, Scriptable thisObj, Object[] args, Function func, Random randomImpl) {
            CryptoImpl thisClass = (CryptoImpl)func.getParentScope();
            Number sizeNum = ArgUtils.objArg(args, 0, Number.class, false);
            if (sizeNum == null) {
                throw Utils.makeTypeError(cx, thisObj, "size must be a number");
            }
            if (sizeNum.longValue() < 0L) {
                throw Utils.makeTypeError(cx, thisObj, "size must be >= 0");
            }
            if (sizeNum.longValue() > 0x3FFFFFFFL) {
                throw Utils.makeTypeError(cx, thisObj, "size must be a valid integer");
            }
            Function callback = ArgUtils.objArg(args, 1, Function.class, false);
            byte[] randomBytes = new byte[sizeNum.intValue()];
            randomImpl.nextBytes(randomBytes);
            Buffer.BufferImpl randomBytesBuffer = Buffer.BufferImpl.newBuffer(cx, thisObj, randomBytes);
            if (callback != null) {
                thisClass.runtime.enqueueCallback(callback, (Scriptable)callback, thisObj, thisClass.runtime.getDomain(), new Object[]{null, randomBytesBuffer});
                return Undefined.instance;
            }
            return randomBytesBuffer;
        }

        @JSFunction
        public static Scriptable getCiphers(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return cx.newArray(thisObj, CryptoAlgorithms.get().getCiphers().toArray());
        }

        @JSFunction
        public static Scriptable getHashes(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return cx.newArray(thisObj, SignatureAlgorithms.get().getAlgorithms().toArray());
        }

        @JSFunction
        public static Scriptable getSSLCiphers(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String filter = "ALL";
            if (args.length > 0 && !Undefined.instance.equals(args[0])) {
                filter = Context.toString((Object)args[0]);
            }
            String[] ciphers = SSLCiphers.get().filterSSLCipherList(filter);
            Object[] jsCiphers = new Object[ciphers.length];
            System.arraycopy(ciphers, 0, jsCiphers, 0, ciphers.length);
            return cx.newArray(thisObj, jsCiphers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JSFunction
        public static Scriptable PBKDF2(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Crypto.ensureCryptoService(cx, thisObj);
            CryptoService crypto = Crypto.getCryptoService();
            Buffer.BufferImpl pwBuf = ArgUtils.bufferArg(args, 0);
            Buffer.BufferImpl saltBuf = ArgUtils.bufferArg(args, 1);
            int iterations = ArgUtils.intArg(args, 2);
            int keyLen = ArgUtils.intArg(args, 3);
            Function callback = ArgUtils.objArg(cx, thisObj, args, 4, Function.class, false);
            byte[] pw = pwBuf.toArray();
            byte[] salt = saltBuf.toArray();
            try {
                byte[] key = crypto.generatePBKDF2(pw, salt, iterations, keyLen);
                Buffer.BufferImpl keyBuf = Buffer.BufferImpl.newBuffer(cx, thisObj, key);
                if (callback == null) {
                    Buffer.BufferImpl bufferImpl = keyBuf;
                    return bufferImpl;
                }
                callback.call(cx, thisObj, null, new Object[]{Context.getUndefinedValue(), keyBuf});
            }
            finally {
                Arrays.fill(pw, (byte)0);
                Arrays.fill(pw, (byte)0);
            }
            return null;
        }

        private void setRuntime(NodeRuntime runtime) {
            this.runtime = runtime;
        }
    }
}

