/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.NodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.AbstractIdObject;
import io.apigee.trireme.core.internal.IdPropertyMap;
import io.apigee.trireme.kernel.Charsets;
import io.apigee.trireme.kernel.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class Buffer
implements NodeModule {
    public static final String MODULE_NAME = "buffer";
    public static final int MAX_LENGTH = 0x3FFFFFFF;

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Scriptable exp = cx.newObject(scope);
        Function buffer = new BufferImpl().exportAsClass(exp);
        exp.put("Buffer", exp, (Object)buffer);
        exp.put("SlowBuffer", exp, (Object)buffer);
        Scriptable jsBuffer = (Scriptable)runner.require("_trireme_buffer", cx);
        Function init = (Function)jsBuffer.get("_setNativePrototype", jsBuffer);
        init.call(cx, (Scriptable)init, exp, new Object[]{buffer});
        return exp;
    }

    public static class BufferImpl
    extends AbstractIdObject<BufferImpl> {
        public static final String CLASS_NAME = "Buffer";
        private static final IdPropertyMap props = new IdPropertyMap("Buffer");
        private static final int Id_byteLength = -1;
        private static final int Id_compare = -2;
        private static final int Id_toFloat = -3;
        private static final int Id_fromFloat = -4;
        private static final int Id_hexSlice = 2;
        private static final int Id_utf8Slice = 3;
        private static final int Id_asciiSlice = 4;
        private static final int Id_binarySlice = 5;
        private static final int Id_base64Slice = 6;
        private static final int Id_ucs2Slice = 7;
        private static final int Id_hexWrite = 8;
        private static final int Id_utf8Write = 9;
        private static final int Id_asciiWrite = 10;
        private static final int Id_binaryWrite = 11;
        private static final int Id_base64Write = 12;
        private static final int Id_ucs2Write = 13;
        private static final int Id_fill = 14;
        private static final int Id_copy = 15;
        private static final int Id_readDoubleLE = 16;
        private static final int Id_readDoubleBE = 17;
        private static final int Id_writeDoubleLE = 18;
        private static final int Id_writeDoubleBE = 19;
        private static final int Id_readInt32 = 20;
        private static final int Id_readUint32 = 21;
        private static final int Id_writeInt32 = 22;
        private static final int Id_writeUint32 = 23;
        private static final int Prop_length = 1;
        private static final int Prop_offset = 2;
        private byte[] buf;
        private int bufOffset;
        private int bufLength;

        public BufferImpl() {
            super(props);
        }

        @Override
        protected BufferImpl defaultConstructor() {
            throw new AssertionError();
        }

        @Override
        protected BufferImpl defaultConstructor(Context cx, Object[] args) {
            BufferImpl buf = new BufferImpl();
            if (args.length == 0) {
                return buf;
            }
            if (args[0] instanceof CharSequence) {
                String s = ArgUtils.stringArg(args, 0);
                String enc = ArgUtils.stringArg(args, 1, "utf8");
                Charset cs = Charsets.get().getCharset(enc);
                if (cs == null) {
                    throw Utils.makeTypeError(cx, (Scriptable)this, "Invalid encoding " + enc);
                }
                buf.fromStringInternal(s, cs);
            } else if (args[0] instanceof Number) {
                int len = ArgUtils.parseUnsignedIntForgiveably(args[0]);
                if (len < 0 || len > 0x3FFFFFFF) {
                    throw Utils.makeRangeError(cx, (Scriptable)this, "Length out of range");
                }
                buf.buf = new byte[len];
                buf.bufOffset = 0;
                buf.bufLength = len;
            } else if (args[0] instanceof BufferImpl) {
                BufferImpl src = (BufferImpl)((Object)args[0]);
                buf.buf = src.buf;
                buf.bufLength = ArgUtils.intArg(args, 1, src.bufLength);
                buf.bufOffset = ArgUtils.intArg(args, 2, 0);
                buf.bufOffset += src.bufOffset;
            } else if (args[0] instanceof Scriptable) {
                Scriptable s = (Scriptable)args[0];
                if (s.has("type", s) && s.has("data", s) && CLASS_NAME.equals(s.get("type", s)) && s.get("data", s) instanceof Scriptable) {
                    buf.fromArrayInternal(cx, (Scriptable)s.get("data", s));
                } else if (s.getPrototype().equals(ScriptableObject.getArrayPrototype((Scriptable)this))) {
                    buf.fromArrayInternal(cx, s);
                } else if (s.has("length", s)) {
                    int len = ArgUtils.parseUnsignedIntForgiveably(s.get("length", s));
                    if (len < 0 || len > 0x3FFFFFFF) {
                        throw Utils.makeRangeError(cx, (Scriptable)this, "Length out of range");
                    }
                    buf.buf = new byte[len];
                    for (Object id : s.getIds()) {
                        if (!(id instanceof Number)) continue;
                        int iid = ((Number)id).intValue();
                        Object v = s.get(iid, s);
                        if (iid >= len) continue;
                        int val = (Integer)Context.jsToJava((Object)v, Integer.class);
                        buf.buf[iid] = (byte)(val & 0xFF);
                    }
                } else {
                    buf.buf = new byte[0];
                }
                buf.bufOffset = 0;
                buf.bufLength = buf.buf.length;
            } else {
                throw Utils.makeTypeError(cx, (Scriptable)this, "Invalid argument type");
            }
            return buf;
        }

        protected void fillConstructorProperties(IdFunctionObject c) {
            this.addIdFunctionProperty((Scriptable)c, CLASS_NAME, -1, "_byteLength", 2);
            this.addIdFunctionProperty((Scriptable)c, CLASS_NAME, -2, "_compare", 2);
            this.addIdFunctionProperty((Scriptable)c, CLASS_NAME, -3, "_toFloat", 1);
            this.addIdFunctionProperty((Scriptable)c, CLASS_NAME, -4, "_fromFloat", 1);
        }

        protected Object getInstanceIdValue(int id) {
            switch (id) {
                case 1: {
                    return this.bufLength;
                }
                case 2: {
                    return this.bufOffset;
                }
            }
            return super.getInstanceIdValue(id);
        }

        @Override
        protected Object prototypeCall(int id, Context cx, Scriptable scope, Object[] args) {
            switch (id) {
                case 2: {
                    return this.slice(args, Charsets.NODE_HEX);
                }
                case 4: {
                    return this.slice(args, Charsets.ASCII);
                }
                case 3: {
                    return this.slice(args, Charsets.UTF8);
                }
                case 5: {
                    return this.slice(args, Charsets.NODE_BINARY);
                }
                case 6: {
                    return this.slice(args, Charsets.BASE64);
                }
                case 7: {
                    return this.slice(args, Charsets.UCS2);
                }
                case 8: {
                    return this.write(cx, args, Charsets.NODE_HEX);
                }
                case 10: {
                    return this.write(cx, args, Charsets.ASCII);
                }
                case 9: {
                    return this.write(cx, args, Charsets.UTF8);
                }
                case 11: {
                    return this.write(cx, args, Charsets.NODE_BINARY);
                }
                case 12: {
                    return this.write(cx, args, Charsets.BASE64);
                }
                case 13: {
                    return this.write(cx, args, Charsets.UCS2);
                }
                case 14: {
                    this.fill(cx, args);
                    break;
                }
                case 15: {
                    return this.copy(cx, args);
                }
                case 17: {
                    return this.readDoubleBE(args);
                }
                case 16: {
                    return this.readDoubleLE(args);
                }
                case 19: {
                    this.writeDouble(args, true);
                    break;
                }
                case 18: {
                    this.writeDouble(args, false);
                    break;
                }
                case 20: {
                    return this.readInt32(args);
                }
                case 21: {
                    return this.readUint32(args);
                }
                case 22: {
                    this.writeInt32(args);
                    break;
                }
                case 23: {
                    this.writeUint32(args);
                    break;
                }
                default: {
                    return super.prototypeCall(id, cx, scope, args);
                }
            }
            return Undefined.instance;
        }

        @Override
        protected Object anonymousCall(int id, Context cx, Scriptable scope, Object thisObj, Object[] args) {
            switch (id) {
                case -1: {
                    return BufferImpl.byteLength(args);
                }
                case -2: {
                    return BufferImpl.compare(cx, scope, args);
                }
                case -3: {
                    return this.toFloat(args);
                }
                case -4: {
                    return this.fromFloat(args);
                }
            }
            return super.anonymousCall(id, cx, scope, thisObj, args);
        }

        private static int byteLength(Object[] args) {
            CoderResult result;
            String data = ArgUtils.stringArg(args, 0);
            Charset charset = BufferImpl.resolveEncoding(args, 1);
            CharsetEncoder encoder = BufferImpl.getCharsetEncoder(charset, true);
            CharBuffer chars = CharBuffer.wrap(data);
            ByteBuffer tmp = ByteBuffer.allocate(256);
            int total = 0;
            do {
                tmp.clear();
                result = encoder.encode(chars, tmp, true);
                total += tmp.position();
            } while (result.isOverflow());
            do {
                tmp.clear();
                result = encoder.flush(tmp);
                total += tmp.position();
            } while (result.isOverflow());
            return total;
        }

        private static int compare(Context cx, Scriptable scope, Object[] args) {
            ByteBuffer bb2;
            BufferImpl b1 = ArgUtils.objArg(cx, scope, args, 0, BufferImpl.class, true);
            BufferImpl b2 = ArgUtils.objArg(cx, scope, args, 1, BufferImpl.class, true);
            int cmpLen = Math.min(b1.bufLength, b2.bufLength);
            ByteBuffer bb1 = ByteBuffer.wrap(b1.buf, b1.bufOffset, cmpLen);
            int cmp = bb1.compareTo(bb2 = ByteBuffer.wrap(b2.buf, b2.bufOffset, cmpLen));
            if (cmp == 0) {
                if (b1.bufLength < b2.bufLength) {
                    return -1;
                }
                if (b1.bufLength > b2.bufLength) {
                    return 1;
                }
                return 0;
            }
            if (cmp < 0) {
                return -1;
            }
            return 1;
        }

        private String slice(Object[] args, Charset cs) {
            int start = ArgUtils.intArg(args, 0);
            int end = ArgUtils.intArg(args, 1);
            int len = end - start;
            if (len <= 0) {
                return "";
            }
            end += this.bufOffset;
            ByteBuffer bb = ByteBuffer.wrap(this.buf, start += this.bufOffset, len);
            return StringUtils.bufferToString((ByteBuffer)bb, (Charset)cs);
        }

        private int write(Context cx, Object[] args, Charset cs) {
            String s = ArgUtils.stringArg(args, 0);
            int off = ArgUtils.intArg(args, 1);
            int len = ArgUtils.intArg(args, 2);
            Scriptable proto = ArgUtils.objArg(cx, (Scriptable)this, args, 3, Scriptable.class, false);
            if (s.isEmpty()) {
                return 0;
            }
            ByteBuffer writeBuf = ByteBuffer.wrap(this.buf, off += this.bufOffset, len);
            CharsetEncoder encoder = BufferImpl.getCharsetEncoder(cs, false);
            CharBuffer chars = CharBuffer.wrap(s);
            encoder.encode(chars, writeBuf, true);
            encoder.flush(writeBuf);
            if (proto != null) {
                proto.put("_charsWritten", proto, (Object)chars.position());
            }
            return writeBuf.position() - off;
        }

        private void fill(Context cx, Object[] args) {
            ArgUtils.ensureArg(args, 0);
            Object val = args[0];
            int start = ArgUtils.intArg(args, 1);
            int end = ArgUtils.intArg(args, 2);
            start += this.bufOffset;
            end += this.bufOffset;
            if (val instanceof Number) {
                Arrays.fill(this.buf, start, end, (byte)((Number)val).intValue());
            } else if (val instanceof Boolean) {
                Arrays.fill(this.buf, start, end, (Boolean)val != false ? (byte)1 : 0);
            } else if (val instanceof String) {
                this.fillString((String)val, start, end);
            } else {
                throw Utils.makeTypeError(cx, (Scriptable)this, "Invalid value argument");
            }
        }

        private void fillString(String s, int start, int end) {
            if (s.isEmpty()) {
                Arrays.fill(this.buf, start, end, (byte)0);
            } else {
                byte[] tmp = s.getBytes(Charsets.UTF8);
                if (tmp.length == 1) {
                    Arrays.fill(this.buf, start, end, tmp[0]);
                } else {
                    int pos = start;
                    while (pos + tmp.length <= end) {
                        System.arraycopy(tmp, 0, this.buf, pos, tmp.length);
                        pos += tmp.length;
                    }
                    int len = Math.min(tmp.length, end - pos);
                    System.arraycopy(tmp, 0, this.buf, pos, len);
                }
            }
        }

        private int copy(Context cx, Object[] args) {
            BufferImpl target = ArgUtils.objArg(cx, (Scriptable)this, args, 0, BufferImpl.class, true);
            int targetStart = ArgUtils.intArg(args, 1);
            int start = ArgUtils.intArg(args, 2);
            int end = ArgUtils.intArg(args, 3);
            System.arraycopy(this.buf, start += this.bufOffset, target.buf, targetStart, (end += this.bufOffset) - start);
            return end - start;
        }

        private Object toFloat(Object[] args) {
            int i = ArgUtils.intArg(args, 0);
            return Float.valueOf(Float.intBitsToFloat(i));
        }

        private int fromFloat(Object[] args) {
            ArgUtils.ensureArg(args, 0);
            if (args[0] == ScriptRuntime.NaNobj) {
                return Float.floatToIntBits(Float.NaN);
            }
            float f = ArgUtils.floatArg(args, 0);
            return Float.floatToIntBits(f);
        }

        private Object readUint32(Object[] args) {
            int off = ArgUtils.intArg(args, 0);
            boolean be = ArgUtils.booleanArg(args, 1);
            if (off + 4 > this.bufLength) {
                return Context.toNumber((Object)0);
            }
            int iv = be ? this.readInt32BE(off) : this.readInt32LE(off);
            long lv = (long)iv & 0xFFFFFFFFL;
            return Context.toNumber((Object)lv);
        }

        private int readInt32(Object[] args) {
            int off = ArgUtils.intArg(args, 0);
            boolean be = ArgUtils.booleanArg(args, 1);
            if (off + 4 > this.bufLength) {
                return 0;
            }
            return be ? this.readInt32BE(off) : this.readInt32LE(off);
        }

        private void writeUint32(Object[] args) {
            int off = ArgUtils.intArg(args, 0);
            long val = ArgUtils.longArg(args, 1);
            boolean be = ArgUtils.booleanArg(args, 2);
            if (off + 4 > this.bufLength) {
                return;
            }
            long lv = val & 0xFFFFFFFFL;
            if (be) {
                this.writeInt32BE(lv, off);
            } else {
                this.writeInt32LE(lv, off);
            }
        }

        private void writeInt32(Object[] args) {
            int off = ArgUtils.intArg(args, 0);
            int val = ArgUtils.intArg(args, 1);
            boolean be = ArgUtils.booleanArg(args, 2);
            if (off + 4 > this.bufLength) {
                return;
            }
            long lv = val;
            if (be) {
                this.writeInt32BE(lv, off);
            } else {
                this.writeInt32LE(lv, off);
            }
        }

        private double readDoubleLE(Object[] args) {
            int off = ArgUtils.intArg(args, 0);
            if (off + 8 > this.bufLength) {
                return 0.0;
            }
            long l = this.readInt64LE(off + this.bufOffset);
            return Double.longBitsToDouble(l);
        }

        private double readDoubleBE(Object[] args) {
            int off = ArgUtils.intArg(args, 0);
            if (off + 8 > this.bufLength) {
                return 0.0;
            }
            long l = this.readInt64BE(off + this.bufOffset);
            return Double.longBitsToDouble(l);
        }

        private void writeDouble(Object[] args, boolean bigEndian) {
            ArgUtils.ensureArg(args, 0);
            double val = args[0] == ScriptRuntime.NaNobj ? Double.NaN : ArgUtils.doubleArg(args, 0);
            int off = ArgUtils.intArg(args, 1);
            if (off + 8 <= this.bufLength) {
                long l = Double.doubleToLongBits(val);
                if (bigEndian) {
                    this.writeInt64BE(l, off + this.bufOffset);
                } else {
                    this.writeInt64LE(l, off + this.bufOffset);
                }
            }
        }

        private long readInt64BE(int offset) {
            return ((long)this.buf[offset] & 0xFFL) << 56 | ((long)this.buf[offset + 1] & 0xFFL) << 48 | ((long)this.buf[offset + 2] & 0xFFL) << 40 | ((long)this.buf[offset + 3] & 0xFFL) << 32 | ((long)this.buf[offset + 4] & 0xFFL) << 24 | ((long)this.buf[offset + 5] & 0xFFL) << 16 | ((long)this.buf[offset + 6] & 0xFFL) << 8 | (long)this.buf[offset + 7] & 0xFFL;
        }

        private long readInt64LE(int offset) {
            return (long)this.buf[offset] & 0xFFL | ((long)this.buf[offset + 1] & 0xFFL) << 8 | ((long)this.buf[offset + 2] & 0xFFL) << 16 | ((long)this.buf[offset + 3] & 0xFFL) << 24 | ((long)this.buf[offset + 4] & 0xFFL) << 32 | ((long)this.buf[offset + 5] & 0xFFL) << 40 | ((long)this.buf[offset + 6] & 0xFFL) << 48 | ((long)this.buf[offset + 7] & 0xFFL) << 56;
        }

        private int readInt32BE(int offset) {
            return (this.buf[this.bufOffset + offset] & 0xFF) << 24 | (this.buf[this.bufOffset + offset + 1] & 0xFF) << 16 | (this.buf[this.bufOffset + offset + 2] & 0xFF) << 8 | this.buf[this.bufOffset + offset + 3] & 0xFF;
        }

        private int readInt32LE(int offset) {
            return this.buf[this.bufOffset + offset] & 0xFF | (this.buf[this.bufOffset + offset + 1] & 0xFF) << 8 | (this.buf[this.bufOffset + offset + 2] & 0xFF) << 16 | (this.buf[this.bufOffset + offset + 3] & 0xFF) << 24;
        }

        private void writeInt64BE(long value, int offset) {
            this.buf[this.bufOffset + offset] = (byte)(value >>> 56 & 0xFFL);
            this.buf[this.bufOffset + offset + 1] = (byte)(value >>> 48 & 0xFFL);
            this.buf[this.bufOffset + offset + 2] = (byte)(value >>> 40 & 0xFFL);
            this.buf[this.bufOffset + offset + 3] = (byte)(value >>> 32 & 0xFFL);
            this.buf[this.bufOffset + offset + 4] = (byte)(value >>> 24 & 0xFFL);
            this.buf[this.bufOffset + offset + 5] = (byte)(value >>> 16 & 0xFFL);
            this.buf[this.bufOffset + offset + 6] = (byte)(value >>> 8 & 0xFFL);
            this.buf[this.bufOffset + offset + 7] = (byte)(value & 0xFFL);
        }

        private void writeInt64LE(long value, int offset) {
            this.buf[this.bufOffset + offset] = (byte)(value & 0xFFL);
            this.buf[this.bufOffset + offset + 1] = (byte)(value >>> 8 & 0xFFL);
            this.buf[this.bufOffset + offset + 2] = (byte)(value >>> 16 & 0xFFL);
            this.buf[this.bufOffset + offset + 3] = (byte)(value >>> 24 & 0xFFL);
            this.buf[this.bufOffset + offset + 4] = (byte)(value >>> 32 & 0xFFL);
            this.buf[this.bufOffset + offset + 5] = (byte)(value >>> 40 & 0xFFL);
            this.buf[this.bufOffset + offset + 6] = (byte)(value >>> 48 & 0xFFL);
            this.buf[this.bufOffset + offset + 7] = (byte)(value >>> 56 & 0xFFL);
        }

        private void writeInt32BE(long value, int offset) {
            this.buf[this.bufOffset + offset] = (byte)(value >>> 24 & 0xFFL);
            this.buf[this.bufOffset + offset + 1] = (byte)(value >>> 16 & 0xFFL);
            this.buf[this.bufOffset + offset + 2] = (byte)(value >>> 8 & 0xFFL);
            this.buf[this.bufOffset + offset + 3] = (byte)(value & 0xFFL);
        }

        private void writeInt32LE(long value, int offset) {
            this.buf[this.bufOffset + offset] = (byte)(value & 0xFFL);
            this.buf[this.bufOffset + offset + 1] = (byte)(value >>> 8 & 0xFFL);
            this.buf[this.bufOffset + offset + 2] = (byte)(value >>> 16 & 0xFFL);
            this.buf[this.bufOffset + offset + 3] = (byte)(value >>> 24 & 0xFFL);
        }

        public static BufferImpl newBuffer(Context cx, Scriptable scope, ByteBuffer bb, boolean copy) {
            BufferImpl buf = (BufferImpl)cx.newObject(scope, CLASS_NAME);
            if (bb == null) {
                return buf;
            }
            if (bb.hasArray() && !copy) {
                buf.buf = bb.array();
                buf.bufOffset = bb.arrayOffset() + bb.position();
                buf.bufLength = bb.remaining();
            } else {
                ByteBuffer tmp = bb.duplicate();
                buf.buf = new byte[tmp.remaining()];
                tmp.get(buf.buf);
                buf.bufOffset = 0;
                buf.bufLength = buf.buf.length;
            }
            return buf;
        }

        public static BufferImpl newBuffer(Context cx, Scriptable scope, byte[] bb) {
            return BufferImpl.newBuffer(cx, scope, bb, 0, bb.length);
        }

        public static BufferImpl newBuffer(Context cx, Scriptable scope, byte[] bb, int offset, int length) {
            BufferImpl buf = (BufferImpl)cx.newObject(scope, CLASS_NAME);
            if (bb == null) {
                return buf;
            }
            buf.buf = bb;
            buf.bufOffset = offset;
            buf.bufLength = length;
            return buf;
        }

        public ByteBuffer getBuffer() {
            if (this.bufOffset != 0) {
                ByteBuffer newBuf = ByteBuffer.wrap(this.buf, this.bufOffset, this.bufLength);
                return newBuf.slice();
            }
            return ByteBuffer.wrap(this.buf, this.bufOffset, this.bufLength);
        }

        public String getString(String encoding) {
            Charset cs = Charsets.get().getCharset(encoding);
            return StringUtils.bufferToString((ByteBuffer)ByteBuffer.wrap(this.buf, this.bufOffset, this.bufLength), (Charset)cs);
        }

        public byte[] getArray() {
            return this.buf;
        }

        public int getArrayOffset() {
            return this.bufOffset;
        }

        public byte[] toArray() {
            byte[] ret = new byte[this.bufLength];
            System.arraycopy(this.buf, this.bufOffset, ret, 0, this.bufLength);
            return ret;
        }

        @Override
        public String getClassName() {
            return CLASS_NAME;
        }

        public Object get(int index, Scriptable start) {
            if (index > -1 && index < this.bufLength) {
                return this.get(index);
            }
            return Undefined.instance;
        }

        public int get(int index) {
            return this.buf[index + this.bufOffset] & 0xFF;
        }

        public boolean has(int index, Scriptable start) {
            return index < this.bufLength;
        }

        public void put(int i, Scriptable start, Object value) {
            int index = i + this.bufOffset;
            if (index < 0 || index >= this.bufLength) {
                throw Utils.makeRangeError(Context.getCurrentContext(), (Scriptable)this, "index out of range");
            }
            int val = ScriptRuntime.toInt32((Object)value);
            this.putByte(index, val);
        }

        private void putByte(int pos, int v) {
            int val = v;
            if (val < 0) {
                val = 255 + val + 1;
            }
            this.buf[pos] = (byte)(val & 0xFF);
        }

        public int getLength() {
            return this.bufLength;
        }

        private void fromStringInternal(String s, Charset cs) {
            ByteBuffer writeBuf = StringUtils.stringToBuffer((String)s, (Charset)cs);
            assert (!writeBuf.isDirect());
            this.buf = writeBuf.array();
            this.bufOffset = writeBuf.arrayOffset();
            this.bufLength = writeBuf.remaining();
        }

        private void fromArrayInternal(Context cx, Scriptable s) {
            Object[] ids = s.getIds();
            this.buf = new byte[ids.length];
            int pos = 0;
            for (Object id : ids) {
                Object e;
                if (id instanceof Number) {
                    e = s.get(((Number)id).intValue(), s);
                } else if (id instanceof String) {
                    e = s.get((String)id, s);
                } else {
                    throw Utils.makeTypeError(cx, (Scriptable)this, "Invalid argument type in array");
                }
                this.putByte(pos++, (int)Context.toNumber((Object)e));
            }
        }

        private static Charset resolveEncoding(Object[] args, int pos) {
            Charset charset;
            String encArg = null;
            if (pos < args.length && args[pos] instanceof String) {
                encArg = Context.toString((Object)args[pos]);
            }
            if ((charset = Charsets.get().resolveCharset(encArg)) == null) {
                throw new EvaluatorException("Unknown encoding: " + encArg);
            }
            return charset;
        }

        private static CharsetEncoder getCharsetEncoder(Charset cs, boolean replacePartial) {
            CharsetEncoder encoder = Charsets.get().getEncoder(cs);
            if (Charsets.BASE64.equals(cs)) {
                encoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
            } else {
                encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            if (replacePartial) {
                encoder.onMalformedInput(CodingErrorAction.REPLACE);
            } else {
                encoder.onMalformedInput(CodingErrorAction.REPORT);
            }
            return encoder;
        }

        static {
            props.addMethod("hexSlice", 2, 2);
            props.addMethod("utf8Slice", 3, 2);
            props.addMethod("asciiSlice", 4, 2);
            props.addMethod("binarySlice", 5, 2);
            props.addMethod("base64Slice", 6, 2);
            props.addMethod("ucs2Slice", 7, 2);
            props.addMethod("hexWrite", 8, 4);
            props.addMethod("utf8Write", 9, 4);
            props.addMethod("asciiWrite", 10, 4);
            props.addMethod("binaryWrite", 11, 4);
            props.addMethod("base64Write", 12, 4);
            props.addMethod("ucs2Write", 13, 4);
            props.addMethod("_fill", 14, 3);
            props.addMethod("_copy", 15, 4);
            props.addMethod("_readDoubleLE", 16, 1);
            props.addMethod("_readDoubleBE", 17, 1);
            props.addMethod("_writeDoubleLE", 18, 2);
            props.addMethod("_writeDoubleBE", 19, 2);
            props.addMethod("_readInt32", 20, 2);
            props.addMethod("_readUint32", 21, 2);
            props.addMethod("_writeInt32", 22, 3);
            props.addMethod("_writeUint32", 23, 3);
            props.addProperty("length", 1, 1);
            props.addProperty("offset", 2, 1);
        }
    }
}

