/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import io.apigee.trireme.core.ClassCache;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.mozilla.javascript.Script;

public class SoftClassCache
implements ClassCache {
    private final AtomicLong totalOps = new AtomicLong();
    private final AtomicLong hits = new AtomicLong();
    private final ConcurrentHashMap<String, SoftReference<Script>> cache = new ConcurrentHashMap();

    @Override
    public Script getCachedScript(String key) {
        this.totalOps.incrementAndGet();
        SoftReference<Script> val = this.cache.get(key);
        if (val == null) {
            return null;
        }
        Script s = val.get();
        if (s == null) {
            this.cache.remove(key);
        } else {
            this.hits.incrementAndGet();
        }
        return s;
    }

    @Override
    public void putCachedScript(String key, Script script) {
        this.cache.put(key, new SoftReference<Script>(script));
    }

    public String toString() {
        return "SoftClassCache [ ops = " + this.totalOps + " hits = " + this.hits + " ]";
    }
}

